/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky.configs;

import me.sargunvohra.mcmods.autoconfig1u.ConfigData;
import me.sargunvohra.mcmods.autoconfig1u.annotation.Config;
import me.sargunvohra.mcmods.autoconfig1u.annotation.ConfigEntry;
import me.sargunvohra.mcmods.autoconfig1u.shadowed.blue.endless.jankson.Comment;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;

@Config(name="StarrySky")
public class StarrySkyConfig
implements ConfigData {
    @ConfigEntry.Gui.PrefixText
    @ConfigEntry.Category(value="GENERAL")
    @Comment(value="\nThe block the portal to the Starry Sky dimension needs to be built with.\nBuild it like a nether portal & has to be activated with flint & steel\nDefault: PACKED_ICE")
    public String starrySkyPortalFrameBlock = "PACKED_ICE";
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Category(value="GENERAL")
    @Comment(value="\nThe height of clouds in the Starry Sky dimension.\nDefault: 270")
    public float cloudHeight = 270.0f;
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Category(value="GENERAL")
    @Comment(value="\nUse a fancy rainbow skybox instead of a generic one.\nDefault: true")
    public boolean rainbowSkybox = true;
    @ConfigEntry.Category(value="GENERAL")
    @Comment(value="\nIf true nether portals in Starry Sky lead to Scary Sky, if false portals do not form.\nDefault: true")
    public boolean enableNetherPortalsToStarryNether = true;
    @ConfigEntry.Category(value="GENERAL")
    @Comment(value="\nIf true end portals in Starry Sky lead to Scarcy Sky, if false to the vanilla end.\nDefault: true")
    public boolean enableEndPortalsToStarryEnd = true;
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Category(value="GENERAL")
    @Comment(value="\nThe '/sphere' command lists all the data of the closest sphere (position, blocks, ...)\n\nDefault: 0")
    public int sphereCommandRequiredPermissionLevel = 0;
    @ConfigEntry.Gui.PrefixText
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Category(value="SYSTEM GENERATION")
    @Comment(value="\nSpheroids are generated in systems.\nEach system consists out of x spheroids over y chunks.\nHow big each system should be in chunks\u00b2\nHigher values make the very slight 'gaps' at the border between\nsystems less common, but since systems are generating all at once\nhigh values can result in small lag spikes every time a new system is generated. (but less spikes in total)\nDefault: 50")
    public int systemSizeChunks = 50;
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Category(value="SYSTEM GENERATION")
    @Comment(value="\nHow many spheres a system can contain max.\nSome will fail because of distance restrictions\nso it's not an exact value\nDefault: 2000")
    public int sphereDensityOverworld = 2000;
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Category(value="SYSTEM GENERATION")
    @Comment(value="\nHow much empty blocks should be enforced between individual spheres.\nIf the distance is too low generation of that one sphere will be cancelled.\nDefault: 10\n")
    public int minDistanceBetweenSpheresOverworld = 10;
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Category(value="SYSTEM GENERATION")
    @Comment(value="\nHow many spheres a system can contain max.\nSome will fail because of distance restrictions\nso it's not an exact value\nDefault: 2500")
    public int sphereDensityNether = 2500;
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Category(value="SYSTEM GENERATION")
    @Comment(value="\nHow much empty blocks should be enforced between individual spheres.\nIf the distance is too low generation of that one sphere will be cancelled.\nDefault: 10\n")
    public int minDistanceBetweenSpheresNether = 7;
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Category(value="SYSTEM GENERATION")
    @Comment(value="\nHow many spheres a system can contain max.\nSome will fail because of distance restrictions\nso it's not an exact value\nDefault: 1500")
    public int sphereDensityEnd = 1500;
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Category(value="SYSTEM GENERATION")
    @Comment(value="\nHow much empty blocks should be enforced between individual spheres.\nIf the distance is too low generation of that one sphere will be cancelled.\nDefault: 10\n")
    public int minDistanceBetweenSpheresEnd = 8;
    @ConfigEntry.Gui.PrefixText
    @ConfigEntry.Category(value="WORLD FLOOR GENERATION")
    @Comment(value="\nIf (or how high) there should be a world floor.\nWhen set to  1 there will the specified BottomBlock at y=1 and the floor block up to the floor height\nWhen set to >1 there will the specified BottomBlock at y=1\nWhen set to  0 there will be no ground, only void\nDefault: 3 (2 layers water, 1 layer bedrock)")
    @ConfigEntry.BoundedDiscrete(min=0L, max=128L)
    public int floorHeightOverworld = 3;
    @ConfigEntry.Category(value="WORLD FLOOR GENERATION")
    @Comment(value="\nThe block generating at y>1 (if floorHeight > 1)\nDefault: WATER")
    public String floorBlockOverworld = "WATER";
    @ConfigEntry.Category(value="WORLD FLOOR GENERATION")
    @Comment(value="\nThe block generating at y=0 (if floorHeight > 0)\nDefault: BEDROCK")
    public String bottomBlockOverworld = "BEDROCK";
    @ConfigEntry.Category(value="WORLD FLOOR GENERATION")
    @Comment(value="\nIf (or how high) there should be a world floor.\nWhen set to  1 there will the specified BottomBlock at y=1 and the floor block up to the floor height\nWhen set to >1 there will the specified BottomBlock at y=1\nWhen set to  0 there will be no ground, only void\nDefault: 3 (2 layers water, 1 layer bedrock)")
    @ConfigEntry.BoundedDiscrete(min=0L, max=128L)
    public int floorHeightNether = 3;
    @ConfigEntry.Category(value="WORLD FLOOR GENERATION")
    @Comment(value="\nThe block generating at y>1 (if floorHeight > 1)\nDefault: LAVA")
    public String floorBlockNether = "LAVA";
    @ConfigEntry.Category(value="WORLD FLOOR GENERATION")
    @Comment(value="\nThe block generating at y=0 (if floorHeight > 0)\nDefault: BEDROCK")
    public String bottomBlockNether = "BEDROCK";
    @ConfigEntry.Category(value="WORLD FLOOR GENERATION")
    @Comment(value="\nIf (or how high) there should be a world floor.\nWhen set to  1 there will the specified BottomBlock at y=1 and the floor block up to the floor height\nWhen set to >1 there will the specified BottomBlock at y=1\nWhen set to  0 there will be no ground, only void\nDefault: 0 (only void)")
    @ConfigEntry.BoundedDiscrete(min=0L, max=128L)
    public int floorHeightEnd = 0;
    @ConfigEntry.Category(value="WORLD FLOOR GENERATION")
    @Comment(value="\nThe block generating at y>1 (if floorHeight > 1)\nDefault: WATER")
    public String floorBlockEnd = "WATER";
    @ConfigEntry.Category(value="WORLD FLOOR GENERATION")
    @Comment(value="\nThe block generating at y=0 (if floorHeight > 0)\nDefault: BEDROCK")
    public String bottomBlockEnd = "BEDROCK";
    @ConfigEntry.Gui.PrefixText
    @ConfigEntry.Category(value="SPHEROIDS")
    @Comment(value="\nGenerate Pride Spheroids")
    public boolean generatePrideSpheroids = false;
    @ConfigEntry.Gui.PrefixText
    @ConfigEntry.Category(value="SPHEROIDS")
    @Comment(value="\nEnable Astromine Integration")
    public boolean generateAstromineSpheroids = true;
    @ConfigEntry.Category(value="SPHEROIDS")
    @Comment(value="\nEnable Industrial Revolution Integration")
    public boolean generateIndustrialRevolutionSpheroids = true;
    @ConfigEntry.Category(value="SPHEROIDS")
    @Comment(value="\nEnable Applied Energistics 2 Integration")
    public boolean generateAppliedEnergistics2Spheroids = true;
    @ConfigEntry.Category(value="SPHEROIDS")
    @Comment(value="\nEnable Modern Industrialization Integration")
    public boolean generateModernIndustrializationSpheroids = true;
    @ConfigEntry.Category(value="SPHEROIDS")
    @Comment(value="\nEnable Tech Reborn Integration")
    public boolean generateTechRebornSpheroids = true;
    @ConfigEntry.Category(value="SPHEROIDS")
    @Comment(value="\nEnable Sakura Rosea Integration")
    public boolean generateSakuraRoseaSpheroids = true;
    @ConfigEntry.Category(value="SPHEROIDS")
    @Comment(value="\nEnable Terrestria Integration")
    public boolean generateTerrestriaSpheroids = true;
    @ConfigEntry.Category(value="SPHEROIDS")
    @Comment(value="\nEnable Traverse Integration")
    public boolean generateTraverseSpheroids = true;
    @ConfigEntry.Category(value="SPHEROIDS")
    @Comment(value="\nEnable Sandwichable Integration")
    public boolean generateSandwichableSpheroids = true;
    @ConfigEntry.Category(value="SPHEROIDS")
    @Comment(value="\nEnable Biomes You Go Integration")
    public boolean generateBYGSpheroids = true;
    @ConfigEntry.Category(value="SPHEROIDS")
    @Comment(value="\nEnable Unearthed Integration")
    public boolean generateUnearthedSpheroids = true;
    @ConfigEntry.Category(value="SPHEROIDS")
    @Comment(value="\nEnable Blockus Integration")
    public boolean generateBlockusSpheroids = true;
    @ConfigEntry.Category(value="SPHEROIDS")
    @Comment(value="\nEnable Mythic Metals Integration")
    public boolean generateMythicMetalsSpheroids = true;
    @ConfigEntry.Category(value="SPHEROIDS")
    @Comment(value="\nEnable BetterNether Integration")
    public boolean generateBetterNetherSpheroids = true;
    @ConfigEntry.Category(value="SPHEROIDS")
    @Comment(value="\nEnable BetterEnd Integration")
    public boolean generateBetterEndSpheroids = true;
    @ConfigEntry.Category(value="SPHEROIDS")
    @Comment(value="\nEnable Cinderscapes Integration")
    public boolean generateCinderscapesSpheroids = true;
    @ConfigEntry.Category(value="SPHEROIDS")
    @Comment(value="\nEnable Ecotones Integration")
    public boolean generateEcotonesSpheroids = true;
    @ConfigEntry.Category(value="SPHEROIDS")
    @Comment(value="\nEnable Woods And Mires Integration")
    public boolean generateWoodsAndMiresSpheroids = true;
    @ConfigEntry.Category(value="SPHEROIDS")
    @Comment(value="\nEnable Biome Makeover Integration")
    public boolean generateBiomeMakeoverSpheroids = true;
    @ConfigEntry.Category(value="SPHEROIDS")
    @Comment(value="\nEnable Mythic Metals Integration for the Default Fantasy Modpack (turn off the default Mythic Metals integration)")
    public boolean generateMythicMetalsSpheroidsStandardFantasyEdition = false;

    private boolean isValidBlock(String blockName) {
        try {
            class_2960 identifier = new class_2960(blockName.toLowerCase());
            class_2680 bs = ((class_2248)class_2378.field_11146.method_10223(identifier)).method_9564();
            if (bs == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void validatePostLoad() {
        if (!this.isValidBlock(this.floorBlockOverworld)) {
            this.floorBlockOverworld = "WATER";
        }
        if (!this.isValidBlock(this.floorBlockNether)) {
            this.floorBlockNether = "LAVA";
        }
        if (!this.isValidBlock(this.floorBlockEnd)) {
            this.floorBlockEnd = "WATER";
        }
        if (!this.isValidBlock(this.bottomBlockOverworld)) {
            this.bottomBlockOverworld = "BEDROCK";
        }
        if (!this.isValidBlock(this.bottomBlockNether)) {
            this.bottomBlockNether = "BEDROCK";
        }
        if (!this.isValidBlock(this.bottomBlockEnd)) {
            this.bottomBlockEnd = "BEDROCK";
        }
        if (!this.isValidBlock(this.starrySkyPortalFrameBlock)) {
            this.starrySkyPortalFrameBlock = "PACKED_ICE";
        }
    }
}

