/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky.dimension.decorators;

import de.dafuqs.starrysky.Support;
import de.dafuqs.starrysky.dimension.SpheroidDecorator;
import de.dafuqs.starrysky.spheroid.spheroids.Spheroid;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5281;

public class RuinedPortalDecorator
extends SpheroidDecorator {
    private final class_2960 lootTable;
    private final class_2680 NETHERRACK = class_2246.field_10515.method_9564();
    private final class_2680 MAGMA_BLOCK = class_2246.field_10092.method_9564();
    private final class_2680 LAVA = class_2246.field_10164.method_9564();
    private final class_2680 OBSIDIAN = class_2246.field_10540.method_9564();
    private static final float OBSIDIAN_CHANCE = 0.9f;

    public RuinedPortalDecorator(class_2960 lootTable) {
        this.lootTable = lootTable;
    }

    @Override
    public void decorateSpheroid(class_5281 world, Spheroid spheroid, ArrayList<class_2338> decorationBlockPositions, Random random) {
        class_2338 spheroidPosition = spheroid.getPosition();
        for (int x = -spheroid.getRadius(); x <= spheroid.getRadius(); ++x) {
            block5: for (int z = -spheroid.getRadius(); z <= spheroid.getRadius(); ++z) {
                int startY = spheroidPosition.method_10264() + spheroid.getRadius() + 1;
                int upperY = Support.getLowerGroundBlock((class_1936)world, new class_2338(spheroidPosition.method_10263() + x, startY, spheroidPosition.method_10260() + z), spheroidPosition.method_10264());
                if (upperY <= spheroidPosition.method_10264()) continue;
                int randomI = random.nextInt(spheroid.getRadius() + 1);
                if (!((double)Math.abs(x * z) * 1.5 < (double)(randomI * randomI))) continue;
                class_2338 currentBlockPos = new class_2338(spheroidPosition.method_10263() + x, upperY, spheroidPosition.method_10260() + z);
                switch (random.nextInt(6)) {
                    case 0: {
                        world.method_8652(currentBlockPos, this.MAGMA_BLOCK, 3);
                        continue block5;
                    }
                    case 1: {
                        world.method_8652(currentBlockPos, this.LAVA, 3);
                        world.method_22350(currentBlockPos).method_12039(currentBlockPos);
                        continue block5;
                    }
                    default: {
                        world.method_8652(currentBlockPos, this.NETHERRACK, 3);
                    }
                }
            }
        }
        int centerTopBlockY = Support.getLowerGroundBlock((class_1936)world, new class_2338(spheroidPosition.method_10263(), spheroidPosition.method_10264() + spheroid.getRadius() + 1, spheroidPosition.method_10260()), spheroidPosition.method_10264());
        class_2338 currentBlockPos = new class_2338(spheroidPosition.method_10263(), centerTopBlockY, spheroidPosition.method_10260());
        this.placePortalBlock(world, currentBlockPos, random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11035, 1), random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11043, 1), random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11035, 2), random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11043, 2), random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11035, 2).method_10084(), random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11043, 2).method_10084(), random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11035, 2).method_10086(1), random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11043, 2).method_10086(1), random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11035, 2).method_10086(2), random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11043, 2).method_10086(2), random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11035, 2).method_10086(3), random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11043, 2).method_10086(3), random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11035, 2).method_10086(4), random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11043, 2).method_10086(4), random);
        this.placePortalBlock(world, currentBlockPos.method_10086(5), random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11035, 1).method_10086(5), random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11043, 1).method_10086(5), random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11035, 2).method_10086(5), random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11043, 2).method_10086(5), random);
        int randomX = Support.getRandomBetween(random, spheroidPosition.method_10263() - spheroid.getRadius() / 2, spheroidPosition.method_10263() + spheroid.getRadius() / 2);
        int randomZ = Support.getRandomBetween(random, spheroidPosition.method_10260() - spheroid.getRadius() / 2, spheroidPosition.method_10260() + spheroid.getRadius() / 2);
        centerTopBlockY = Support.getLowerGroundBlock((class_1936)world, new class_2338(randomX, spheroidPosition.method_10264() + spheroid.getRadius() + 2, randomZ), spheroidPosition.method_10264());
        if (centerTopBlockY != spheroidPosition.method_10264()) {
            class_2338 lootChestPosition = new class_2338(randomX, centerTopBlockY, randomZ).method_10084();
            this.placeLootChestAtPosition(world, lootChestPosition, this.lootTable, random);
        }
    }

    private void placePortalBlock(class_5281 world, class_2338 blockPos, Random random) {
        if (random.nextFloat() < 0.9f) {
            world.method_8652(blockPos, this.OBSIDIAN, 3);
        }
    }
}

