/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky.spheroid.spheroids;

import de.dafuqs.starrysky.Support;
import de.dafuqs.starrysky.advancements.SpheroidAdvancementIdentifier;
import de.dafuqs.starrysky.dimension.SpheroidDecorator;
import de.dafuqs.starrysky.spheroid.SpheroidEntitySpawnDefinition;
import de.dafuqs.starrysky.spheroid.spheroids.Spheroid;
import java.util.ArrayList;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2919;

public class RainbowSpheroid
extends Spheroid {
    private final ArrayList<class_2680> rainbowBlocks;

    public RainbowSpheroid(class_2919 random, SpheroidAdvancementIdentifier spheroidAdvancementIdentifier, int radius, ArrayList<SpheroidDecorator> spheroidDecorators, ArrayList<SpheroidEntitySpawnDefinition> entityTypesToSpawn, ArrayList<class_2680> rainbowBlocks) {
        super(spheroidAdvancementIdentifier, random, spheroidDecorators, radius, entityTypesToSpawn);
        this.radius = radius;
        this.rainbowBlocks = rainbowBlocks;
    }

    @Override
    public String getDescription() {
        return "+++ RainbowSpheroid +++\nPosition: x=" + this.getPosition().method_10263() + " y=" + this.getPosition().method_10264() + " z=" + this.getPosition().method_10260() + "\nRadius: " + this.radius + "\nRainbow Blocks ( + " + this.getRainbowBlockCount() + "): " + this.rainbowBlocks.toString();
    }

    public int getRainbowBlockCount() {
        return this.rainbowBlocks.size();
    }

    @Override
    public void generate(class_2791 chunk) {
        int chunkX = chunk.method_12004().field_9181;
        int chunkZ = chunk.method_12004().field_9180;
        int x = this.getPosition().method_10263();
        int y = this.getPosition().method_10264();
        int z = this.getPosition().method_10260();
        this.random.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        for (int x2 = Math.max(chunkX * 16, x - this.radius); x2 <= Math.min(chunkX * 16 + 15, x + this.radius); ++x2) {
            for (int y2 = y - this.radius; y2 <= y + this.radius; ++y2) {
                for (int z2 = Math.max(chunkZ * 16, z - this.radius); z2 <= Math.min(chunkZ * 16 + 15, z + this.radius); ++z2) {
                    class_2338 currBlockPos = new class_2338(x2, y2, z2);
                    long d = Math.round(Support.getDistance(x, y, z, x2, y2, z2));
                    if (d > (long)this.radius) continue;
                    int currentBlockID = (Math.abs(x2) + Math.abs(y2) + Math.abs(z2)) % this.getRainbowBlockCount();
                    class_2680 currentBlockState = this.rainbowBlocks.get(currentBlockID);
                    chunk.method_12010(currBlockPos, currentBlockState, false);
                }
            }
        }
    }
}

