/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky.spheroid.types;

import de.dafuqs.starrysky.StarrySkyCommon;
import de.dafuqs.starrysky.Support;
import de.dafuqs.starrysky.advancements.SpheroidAdvancementIdentifier;
import de.dafuqs.starrysky.dimension.SpheroidDecorator;
import de.dafuqs.starrysky.spheroid.SpheroidEntitySpawnDefinition;
import de.dafuqs.starrysky.spheroid.spheroids.CaveSpheroid;
import de.dafuqs.starrysky.spheroid.types.SpheroidType;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.class_2246;
import net.minecraft.class_2680;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import org.apache.logging.log4j.Level;

public class CaveSpheroidType
extends SpheroidType {
    private final class_2680 shellBlock;
    private final int minShellRadius;
    private final int maxShellRadius;
    private final class_2680 caveFloorBlock;
    private class_2680 topBlock;
    private class_2680 bottomBlock;
    private class_2960 lootTable;
    float lootTableChance;

    public CaveSpheroidType(SpheroidAdvancementIdentifier spheroidAdvancementIdentifier, int minRadius, int maxRadius, class_2680 shellBlock, class_2680 caveFloorBlock, int minShellRadius, int maxShellRadius) {
        super(spheroidAdvancementIdentifier, minRadius, maxRadius);
        if (shellBlock == class_2246.field_10124.method_9564()) {
            StarrySkyCommon.log(Level.ERROR, "CaveSpheroidType: Registered a SpheroidType with null shellBlock!");
        }
        if (caveFloorBlock == class_2246.field_10124.method_9564()) {
            StarrySkyCommon.log(Level.ERROR, "CaveSpheroidType: Registered a SpheroidType with null caveFloorBlock!");
        }
        this.caveFloorBlock = caveFloorBlock;
        this.shellBlock = shellBlock;
        this.minShellRadius = minShellRadius;
        this.maxShellRadius = maxShellRadius;
    }

    public CaveSpheroidType setTopBlockState(class_2680 state) {
        this.topBlock = state;
        return this;
    }

    public CaveSpheroidType setBottomBlockState(class_2680 state) {
        this.bottomBlock = state;
        return this;
    }

    public CaveSpheroidType addChestWithLootTable(class_2960 lootTable, float chance) {
        this.lootTable = lootTable;
        this.lootTableChance = chance;
        return this;
    }

    public class_2680 getTopBlock() {
        return this.topBlock != null ? this.topBlock : this.shellBlock;
    }

    public class_2680 getBottomBlock() {
        return this.bottomBlock != null ? this.bottomBlock : this.shellBlock;
    }

    @Override
    public String getDescription() {
        return "CaveSpheroid";
    }

    @Override
    public CaveSpheroid getRandomSpheroid(class_2919 chunkRandom) {
        int radius = this.getRandomRadius(chunkRandom);
        int shellRadius = Support.getRandomBetween((Random)chunkRandom, this.minShellRadius, this.maxShellRadius);
        ArrayList<SpheroidDecorator> spheroidDecorators = this.getSpheroidDecoratorsWithChance(chunkRandom);
        ArrayList<SpheroidEntitySpawnDefinition> entityTypesToSpawn = this.getRandomEntityTypesToSpawn(chunkRandom);
        class_2680 topBlock = this.getTopBlock();
        class_2680 bottomBlock = this.getBottomBlock();
        class_2960 lootTable = null;
        if (chunkRandom.nextFloat() < this.lootTableChance) {
            lootTable = this.lootTable;
        }
        return new CaveSpheroid(chunkRandom, this.spheroidAdvancementIdentifier, radius, spheroidDecorators, entityTypesToSpawn, this.caveFloorBlock, this.shellBlock, shellRadius, topBlock, bottomBlock, lootTable);
    }
}

