/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky.spheroid.types;

import de.dafuqs.starrysky.StarrySkyCommon;
import de.dafuqs.starrysky.Support;
import de.dafuqs.starrysky.advancements.SpheroidAdvancementIdentifier;
import de.dafuqs.starrysky.dimension.SpheroidDecorator;
import de.dafuqs.starrysky.spheroid.SpheroidEntitySpawnDefinition;
import de.dafuqs.starrysky.spheroid.spheroids.DungeonSpheroid;
import de.dafuqs.starrysky.spheroid.types.SpheroidType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Random;
import net.minecraft.class_1299;
import net.minecraft.class_2680;
import net.minecraft.class_2919;
import org.apache.logging.log4j.Level;

public class DungeonSpheroidType
extends SpheroidType {
    private final class_1299 entityType;
    private final LinkedHashMap<class_2680, Float> validShellBlocks;
    private final int minShellRadius;
    private final int maxShellRadius;

    public DungeonSpheroidType(SpheroidAdvancementIdentifier spheroidAdvancementIdentifier, int minRadius, int maxRadius, class_1299 entityType, LinkedHashMap<class_2680, Float> validShellBlocks, int minShellRadius, int maxShellRadius) {
        super(spheroidAdvancementIdentifier, minRadius, maxRadius);
        if (entityType == null) {
            StarrySkyCommon.log(Level.ERROR, "DungeonSpheroidType: Registered a SpheroidType with null entity!");
        }
        this.entityType = entityType;
        this.validShellBlocks = validShellBlocks;
        this.minShellRadius = minShellRadius;
        this.maxShellRadius = maxShellRadius;
    }

    @Override
    public String getDescription() {
        return "DungeonSpheroid";
    }

    @Override
    public DungeonSpheroid getRandomSpheroid(class_2919 chunkRandom) {
        int radius = this.getRandomRadius(chunkRandom);
        int shellRadius = Support.getRandomBetween((Random)chunkRandom, this.minShellRadius, this.maxShellRadius);
        class_2680 shellBlock = Support.getWeightedRandom(this.validShellBlocks, (Random)chunkRandom);
        ArrayList<SpheroidDecorator> spheroidDecorators = this.getSpheroidDecoratorsWithChance(chunkRandom);
        ArrayList<SpheroidEntitySpawnDefinition> entityTypesToSpawn = this.getRandomEntityTypesToSpawn(chunkRandom);
        return new DungeonSpheroid(chunkRandom, this.spheroidAdvancementIdentifier, radius, spheroidDecorators, entityTypesToSpawn, this.entityType, shellBlock, shellRadius);
    }
}

