/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky.dimension;

import de.dafuqs.starrysky.Support;
import de.dafuqs.starrysky.dimension.DecorationMode;
import de.dafuqs.starrysky.dimension.spheroid.spheroids.Spheroid;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3614;
import net.minecraft.class_5281;

public abstract class SpheroidDecorator {
    public abstract void decorateSpheroid(class_5281 var1, Spheroid var2, class_2338 var3, Random var4);

    protected void placeLootChestAtPosition(class_5281 world, class_2338 blockPos, class_2960 lootTable, Random random) {
        class_2680 chestBlockState = class_2246.field_10034.method_9564();
        if (world.method_8320(blockPos) == class_2246.field_10382.method_9564()) {
            chestBlockState = (class_2680)chestBlockState.method_11657((class_2769)class_2281.field_10772, (Comparable)Boolean.valueOf(true));
        }
        int r = random.nextInt(4);
        world.method_8652(blockPos, (class_2680)chestBlockState.method_11657((class_2769)class_2281.field_10768, (Comparable)(switch (r) {
            case 0 -> class_2350.field_11043;
            case 1 -> class_2350.field_11035;
            case 2 -> class_2350.field_11034;
            default -> class_2350.field_11039;
        })), 3);
        class_2586 chestBlockEntity = world.method_8321(blockPos);
        if (chestBlockEntity instanceof class_2595) {
            ((class_2595)chestBlockEntity).method_11285(lootTable, random.nextLong());
        }
    }

    protected class_2338 findNextNonAirBlockInDirection(class_5281 world, class_2338 blockPos, class_2350 direction, int maxBlocks) {
        for (int i = 0; i < maxBlocks; ++i) {
            if (world.method_8320(blockPos.method_10079(direction, i)).method_26215()) continue;
            return blockPos;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected List<class_2338> getDecorationPositionsInChunk(Spheroid spheroid, class_5281 world, class_2338 origin, Random random, float chance, DecorationMode decorationMode) {
        ArrayList<class_2338> blockPosList = new ArrayList<class_2338>();
        if (random == null || chance <= 0.0f) {
            return blockPosList;
        }
        if (decorationMode == DecorationMode.CENTER) {
            if (spheroid.isCenterInChunkBlockPos(origin)) {
                blockPosList.add(spheroid.getPosition());
            }
            return blockPosList;
        }
        if (decorationMode == DecorationMode.TOP_CENTER) {
            if (spheroid.isCenterInChunkBlockPos(origin)) {
                blockPosList.add(spheroid.getPosition().method_10069(0, spheroid.getRadius() + 1, 0));
            }
            return blockPosList;
        }
        if (decorationMode == DecorationMode.BOTTOM_CENTER) {
            if (spheroid.isCenterInChunkBlockPos(origin)) {
                blockPosList.add(spheroid.getPosition().method_10069(0, -spheroid.getRadius() - 1, 0));
            }
            return blockPosList;
        }
        int y = 0;
        int x = origin.method_10263();
        while (x < origin.method_10263() + 16) {
            block7: for (int z = origin.method_10260(); z < origin.method_10260() + 16; ++z) {
                if (!(chance >= 1.0f) && !(random.nextFloat() < chance) || !this.isSpheroidAtCoords(spheroid, x, z)) continue;
                switch (decorationMode) {
                    case TOP: {
                        y = Support.getLowerGroundBlock((class_1936)world, new class_2338(x, spheroid.getPosition().method_10264() + spheroid.getRadius(), z), spheroid.getPosition().method_10264());
                        if (y != spheroid.getPosition().method_10264()) break;
                        continue block7;
                    }
                    case BOTTOM: {
                        y = Support.getUpperGroundBlock((class_1936)world, new class_2338(x, spheroid.getPosition().method_10264() - spheroid.getRadius(), z), spheroid.getPosition().method_10264());
                        if (y != spheroid.getPosition().method_10264()) break;
                        continue block7;
                    }
                    case CAVE_BOTTOM: {
                        class_2338 startPos = new class_2338(x, spheroid.getPosition().method_10264(), z);
                        int minHeight = spheroid.getPosition().method_10264() - spheroid.getRadius();
                        if ((world.method_22347(startPos) || !world.method_8316(startPos).method_15769()) && (y = Support.getLowerGroundBlock((class_1936)world, startPos, minHeight)) != minHeight) break;
                        continue block7;
                    }
                    case CAVE_TOP: {
                        class_2338 startPos = new class_2338(x, spheroid.getPosition().method_10264(), z);
                        int maxHeight = spheroid.getPosition().method_10264() + spheroid.getRadius();
                        if (!world.method_22347(startPos) && world.method_8316(startPos).method_15769() || (y = Support.getUpperGroundBlock((class_1936)world, startPos, maxHeight)) == maxHeight) continue block7;
                    }
                }
                blockPosList.add(new class_2338(x, y, z));
            }
            ++x;
        }
        return blockPosList;
    }

    protected boolean isSpheroidAtCoords(Spheroid spheroid, int x, int z) {
        return Support.getSquaredDistance(x, 0.0, z, spheroid.getPosition().method_10263(), 0.0, spheroid.getPosition().method_10260()) <= (double)(spheroid.getRadius() * spheroid.getRadius());
    }

    public boolean surroundedByAir(class_5281 world, class_2338 pos) {
        Iterator directionIterator = class_2350.class_2353.field_11062.iterator();
        do {
            class_2350 direction;
            class_2680 blockState;
            class_3614 material;
            if (!(material = (blockState = world.method_8320(pos.method_10093(direction = (class_2350)directionIterator.next()))).method_26207()).method_15799()) continue;
            return false;
        } while (directionIterator.hasNext());
        return true;
    }
}

