/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky.dimension;

import de.dafuqs.starrysky.StarrySkyCommon;
import de.dafuqs.starrysky.Support;
import de.dafuqs.starrysky.dimension.SpheroidDistributionType;
import de.dafuqs.starrysky.dimension.spheroid.lists.DynamicOreSpheroids;
import de.dafuqs.starrysky.dimension.spheroid.lists.SpheroidListAppliedEnergistics2;
import de.dafuqs.starrysky.dimension.spheroid.lists.SpheroidListAstromine;
import de.dafuqs.starrysky.dimension.spheroid.lists.SpheroidListBYG;
import de.dafuqs.starrysky.dimension.spheroid.lists.SpheroidListBetterEnd;
import de.dafuqs.starrysky.dimension.spheroid.lists.SpheroidListBetterNether;
import de.dafuqs.starrysky.dimension.spheroid.lists.SpheroidListBiomeMakeover;
import de.dafuqs.starrysky.dimension.spheroid.lists.SpheroidListBlockus;
import de.dafuqs.starrysky.dimension.spheroid.lists.SpheroidListCinderscapes;
import de.dafuqs.starrysky.dimension.spheroid.lists.SpheroidListEcotones;
import de.dafuqs.starrysky.dimension.spheroid.lists.SpheroidListIndustrialRevolution;
import de.dafuqs.starrysky.dimension.spheroid.lists.SpheroidListLGBT;
import de.dafuqs.starrysky.dimension.spheroid.lists.SpheroidListModernIndustrialization;
import de.dafuqs.starrysky.dimension.spheroid.lists.SpheroidListMythicMetals;
import de.dafuqs.starrysky.dimension.spheroid.lists.SpheroidListSakuraRosea;
import de.dafuqs.starrysky.dimension.spheroid.lists.SpheroidListSandwichable;
import de.dafuqs.starrysky.dimension.spheroid.lists.SpheroidListTechReborn;
import de.dafuqs.starrysky.dimension.spheroid.lists.SpheroidListTerrestria;
import de.dafuqs.starrysky.dimension.spheroid.lists.SpheroidListTraverse;
import de.dafuqs.starrysky.dimension.spheroid.lists.SpheroidListUnearthed;
import de.dafuqs.starrysky.dimension.spheroid.lists.SpheroidListVanilla;
import de.dafuqs.starrysky.dimension.spheroid.lists.SpheroidListVanillaEnd;
import de.dafuqs.starrysky.dimension.spheroid.lists.SpheroidListVanillaNether;
import de.dafuqs.starrysky.dimension.spheroid.lists.SpheroidListWoodsAndMires;
import de.dafuqs.starrysky.dimension.spheroid.types.SpheroidType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Random;
import net.minecraft.class_2680;
import net.minecraft.class_2919;
import org.apache.logging.log4j.Level;

public class SpheroidLoader {
    private static boolean initialized = false;
    private static final LinkedHashMap<SpheroidDistributionType, LinkedHashMap<SpheroidType, Float>> availableSpheroidTypesByDistributionTypeWithWeight = new LinkedHashMap();
    private static final LinkedHashMap<SpheroidDistributionType, LinkedHashMap<SpheroidType, Float>> availableSpheroidTypesByDistributionTypeWithWeightNether = new LinkedHashMap();
    private static final LinkedHashMap<SpheroidDistributionType, LinkedHashMap<SpheroidType, Float>> availableSpheroidTypesByDistributionTypeWithWeightEnd = new LinkedHashMap();
    private static final HashMap<SpheroidDimensionType, LinkedHashMap<String, ArrayList<class_2680>>> dynamicOresByDimensionType = new LinkedHashMap(){
        {
            this.put(SpheroidDimensionType.OVERWORLD, new LinkedHashMap());
            this.put(SpheroidDimensionType.NETHER, new LinkedHashMap());
            this.put(SpheroidDimensionType.END, new LinkedHashMap());
        }
    };
    private static final LinkedHashMap<SpheroidDistributionType, Float> spheroidDistributionTypeWeights = new LinkedHashMap<SpheroidDistributionType, Float>(){
        {
            this.put(SpheroidDistributionType.ESSENTIAL, Float.valueOf(10.0f));
            this.put(SpheroidDistributionType.DECORATIVE, Float.valueOf(10.0f));
            this.put(SpheroidDistributionType.ORE, Float.valueOf(10.0f));
            this.put(SpheroidDistributionType.FLUID, Float.valueOf(6.0f));
            this.put(SpheroidDistributionType.WOOD, Float.valueOf(4.0f));
            this.put(SpheroidDistributionType.TREASURE, Float.valueOf(1.0f));
            this.put(SpheroidDistributionType.DUNGEON, Float.valueOf(0.1f));
        }
    };
    private static final LinkedHashMap<SpheroidDistributionType, Float> spheroidDistributionTypeWeightsNether = new LinkedHashMap<SpheroidDistributionType, Float>(){
        {
            this.put(SpheroidDistributionType.ESSENTIAL, Float.valueOf(10.0f));
            this.put(SpheroidDistributionType.DECORATIVE, Float.valueOf(10.0f));
            this.put(SpheroidDistributionType.ORE, Float.valueOf(10.0f));
            this.put(SpheroidDistributionType.FLUID, Float.valueOf(6.0f));
            this.put(SpheroidDistributionType.WOOD, Float.valueOf(4.0f));
            this.put(SpheroidDistributionType.TREASURE, Float.valueOf(1.0f));
            this.put(SpheroidDistributionType.DUNGEON, Float.valueOf(0.1f));
        }
    };
    private static final LinkedHashMap<SpheroidDistributionType, Float> spheroidDistributionTypeWeightsEnd = new LinkedHashMap<SpheroidDistributionType, Float>(){
        {
            this.put(SpheroidDistributionType.ESSENTIAL, Float.valueOf(50.0f));
            this.put(SpheroidDistributionType.DECORATIVE, Float.valueOf(10.0f));
            this.put(SpheroidDistributionType.ORE, Float.valueOf(6.0f));
            this.put(SpheroidDistributionType.WOOD, Float.valueOf(3.0f));
            this.put(SpheroidDistributionType.FLUID, Float.valueOf(1.0f));
            this.put(SpheroidDistributionType.TREASURE, Float.valueOf(1.0f));
            this.put(SpheroidDistributionType.DUNGEON, Float.valueOf(0.1f));
        }
    };

    public void registerSpheroidType(SpheroidDimensionType spheroidDimensionType, SpheroidDistributionType spheroidDistributionType, Float weight, SpheroidType spheroidType) {
        switch (spheroidDimensionType) {
            case OVERWORLD: {
                availableSpheroidTypesByDistributionTypeWithWeight.get((Object)spheroidDistributionType).put(spheroidType, weight);
                return;
            }
            case NETHER: {
                availableSpheroidTypesByDistributionTypeWithWeightNether.get((Object)spheroidDistributionType).put(spheroidType, weight);
                return;
            }
            case END: {
                availableSpheroidTypesByDistributionTypeWithWeightEnd.get((Object)spheroidDistributionType).put(spheroidType, weight);
            }
        }
    }

    public void registerDynamicOre(SpheroidDimensionType spheroidDimensionType, String oreName, class_2680 oreBlockState) {
        LinkedHashMap<String, ArrayList<class_2680>> dynamicOres = dynamicOresByDimensionType.get((Object)spheroidDimensionType);
        if (dynamicOres.containsKey(oreName)) {
            dynamicOres.get(oreName).add(oreBlockState);
        } else {
            ArrayList<class_2680> newArrayList = new ArrayList<class_2680>();
            newArrayList.add(oreBlockState);
            dynamicOres.put(oreName, newArrayList);
        }
    }

    public SpheroidLoader() {
        if (!initialized) {
            StarrySkyCommon.log(Level.INFO, "Loading Integration Packs...");
            for (SpheroidDistributionType spheroidDistributionType : SpheroidDistributionType.values()) {
                availableSpheroidTypesByDistributionTypeWithWeight.put(spheroidDistributionType, new LinkedHashMap());
            }
            for (SpheroidDistributionType spheroidDistributionType : SpheroidDistributionType.values()) {
                availableSpheroidTypesByDistributionTypeWithWeightNether.put(spheroidDistributionType, new LinkedHashMap());
            }
            for (SpheroidDistributionType spheroidDistributionType : SpheroidDistributionType.values()) {
                availableSpheroidTypesByDistributionTypeWithWeightEnd.put(spheroidDistributionType, new LinkedHashMap());
            }
            SpheroidListVanilla.setup(this);
            SpheroidListVanillaNether.setup(this);
            SpheroidListVanillaEnd.setup(this);
            if (SpheroidListLGBT.shouldGenerate()) {
                SpheroidListLGBT.setup(this);
            }
            if (SpheroidListTechReborn.shouldGenerate()) {
                SpheroidListTechReborn.setup(this);
            }
            if (SpheroidListAstromine.shouldGenerate()) {
                SpheroidListAstromine.setup(this);
            }
            if (SpheroidListAppliedEnergistics2.shouldGenerate()) {
                SpheroidListAppliedEnergistics2.setup(this);
            }
            if (SpheroidListModernIndustrialization.shouldGenerate()) {
                SpheroidListModernIndustrialization.setup(this);
            }
            if (SpheroidListIndustrialRevolution.shouldGenerate()) {
                SpheroidListIndustrialRevolution.setup(this);
            }
            if (SpheroidListSakuraRosea.shouldGenerate()) {
                SpheroidListSakuraRosea.setup(this);
            }
            if (SpheroidListBlockus.shouldGenerate()) {
                SpheroidListBlockus.setup(this);
            }
            if (SpheroidListBYG.shouldGenerate()) {
                SpheroidListBYG.setup(this);
            }
            if (SpheroidListTerrestria.shouldGenerate()) {
                SpheroidListTerrestria.setup(this);
            }
            if (SpheroidListTraverse.shouldGenerate()) {
                SpheroidListTraverse.setup(this);
            }
            if (SpheroidListUnearthed.shouldGenerate()) {
                SpheroidListUnearthed.setup(this);
            }
            if (SpheroidListSandwichable.shouldGenerate()) {
                SpheroidListSandwichable.setup(this);
            }
            if (SpheroidListMythicMetals.shouldGenerate()) {
                SpheroidListMythicMetals.setup(this);
            }
            if (SpheroidListBetterNether.shouldGenerate()) {
                SpheroidListBetterNether.setup(this);
            }
            if (SpheroidListBetterEnd.shouldGenerate()) {
                SpheroidListBetterEnd.setup(this);
            }
            if (SpheroidListCinderscapes.shouldGenerate()) {
                SpheroidListCinderscapes.setup(this);
            }
            if (SpheroidListEcotones.shouldGenerate()) {
                SpheroidListEcotones.setup(this);
            }
            if (SpheroidListWoodsAndMires.shouldGenerate()) {
                SpheroidListWoodsAndMires.setup(this);
            }
            if (SpheroidListBiomeMakeover.shouldGenerate()) {
                SpheroidListBiomeMakeover.setup(this);
            }
            LinkedHashMap<SpheroidType, Float> dynamicOreSpheroids = DynamicOreSpheroids.getOreSpheroidTypesBasedOnDict(dynamicOresByDimensionType.get((Object)SpheroidDimensionType.OVERWORLD));
            availableSpheroidTypesByDistributionTypeWithWeight.get((Object)SpheroidDistributionType.ORE).putAll(dynamicOreSpheroids);
            dynamicOreSpheroids = DynamicOreSpheroids.getOreSpheroidTypesBasedOnDict(dynamicOresByDimensionType.get((Object)SpheroidDimensionType.NETHER));
            availableSpheroidTypesByDistributionTypeWithWeightNether.get((Object)SpheroidDistributionType.ORE).putAll(dynamicOreSpheroids);
            dynamicOreSpheroids = DynamicOreSpheroids.getOreSpheroidTypesBasedOnDict(dynamicOresByDimensionType.get((Object)SpheroidDimensionType.END));
            availableSpheroidTypesByDistributionTypeWithWeightEnd.get((Object)SpheroidDistributionType.ORE).putAll(dynamicOreSpheroids);
            initialized = true;
            StarrySkyCommon.log(Level.INFO, "Initializing complete!");
        }
    }

    public static SpheroidType getWeightedRandomSpheroid(SpheroidDimensionType spheroidDimensionType, class_2919 systemRandom) {
        switch (spheroidDimensionType) {
            case OVERWORLD: {
                SpheroidDistributionType chosenDistributionType = Support.getWeightedRandom(spheroidDistributionTypeWeights, (Random)systemRandom);
                return Support.getWeightedRandom(availableSpheroidTypesByDistributionTypeWithWeight.get((Object)chosenDistributionType), (Random)systemRandom);
            }
            case NETHER: {
                SpheroidDistributionType chosenDistributionType = Support.getWeightedRandom(spheroidDistributionTypeWeightsNether, (Random)systemRandom);
                return Support.getWeightedRandom(availableSpheroidTypesByDistributionTypeWithWeightNether.get((Object)chosenDistributionType), (Random)systemRandom);
            }
        }
        SpheroidDistributionType chosenDistributionType = Support.getWeightedRandom(spheroidDistributionTypeWeightsEnd, (Random)systemRandom);
        return Support.getWeightedRandom(availableSpheroidTypesByDistributionTypeWithWeightEnd.get((Object)chosenDistributionType), (Random)systemRandom);
    }

    public static enum SpheroidDimensionType {
        OVERWORLD,
        NETHER,
        END;

    }
}

