/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.starrysky.StarrySkyCommon;
import de.dafuqs.starrysky.Support;
import de.dafuqs.starrysky.advancements.SpheroidAdvancementIdentifier;
import de.dafuqs.starrysky.dimension.SpheroidLoader;
import de.dafuqs.starrysky.dimension.SystemGenerator;
import de.dafuqs.starrysky.dimension.spheroid.spheroids.Spheroid;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1923;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3233;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_5284;
import net.minecraft.class_5311;
import net.minecraft.class_5539;
import org.apache.logging.log4j.Level;

public class StarrySkyChunkGenerator
extends class_2794 {
    private final long seed;
    protected final class_5284 settings;
    private final SystemGenerator systemGenerator;
    private final int FLOOR_HEIGHT;
    private final class_2680 FLOOR_BLOCK_STATE;
    private final class_2680 BOTTOM_BLOCK_STATE;
    public static final Codec<StarrySkyChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1966.field_24713.fieldOf("biome_source").forGetter(surfaceChunkGenerator -> surfaceChunkGenerator.field_24747), (App)Codec.LONG.fieldOf("seed").stable().forGetter(surfaceChunkGenerator -> surfaceChunkGenerator.seed), (App)class_5284.field_24781.fieldOf("settings").forGetter(surfaceChunkGenerator -> () -> surfaceChunkGenerator.settings)).apply((Applicative)instance, instance.stable(StarrySkyChunkGenerator::new)));

    public StarrySkyChunkGenerator(class_1966 biomeSource, long l, Supplier<class_5284> chunkGeneratorType) {
        this(biomeSource, biomeSource, l, chunkGeneratorType.get());
    }

    private StarrySkyChunkGenerator(class_1966 biomeSource, class_1966 biomeSource2, long seed, class_5284 chunkGeneratorType) {
        super(biomeSource, biomeSource2, new class_5311(Optional.empty(), Collections.emptyMap()), seed);
        SpheroidLoader.SpheroidDimensionType spheroidDimensionType;
        this.seed = seed;
        this.settings = chunkGeneratorType;
        if (class_2246.field_10515.method_9564().equals(chunkGeneratorType.method_28005())) {
            spheroidDimensionType = SpheroidLoader.SpheroidDimensionType.NETHER;
            this.FLOOR_HEIGHT = StarrySkyCommon.STARRY_SKY_CONFIG.floorHeightNether;
            this.FLOOR_BLOCK_STATE = ((class_2248)class_2378.field_11146.method_10223(new class_2960(StarrySkyCommon.STARRY_SKY_CONFIG.floorBlockNether.toLowerCase()))).method_9564();
            this.BOTTOM_BLOCK_STATE = ((class_2248)class_2378.field_11146.method_10223(new class_2960(StarrySkyCommon.STARRY_SKY_CONFIG.bottomBlockNether.toLowerCase()))).method_9564();
        } else if (class_2246.field_10471.method_9564().equals(chunkGeneratorType.method_28005())) {
            spheroidDimensionType = SpheroidLoader.SpheroidDimensionType.END;
            this.FLOOR_HEIGHT = StarrySkyCommon.STARRY_SKY_CONFIG.floorHeightEnd;
            this.FLOOR_BLOCK_STATE = ((class_2248)class_2378.field_11146.method_10223(new class_2960(StarrySkyCommon.STARRY_SKY_CONFIG.floorBlockEnd.toLowerCase()))).method_9564();
            this.BOTTOM_BLOCK_STATE = ((class_2248)class_2378.field_11146.method_10223(new class_2960(StarrySkyCommon.STARRY_SKY_CONFIG.bottomBlockEnd.toLowerCase()))).method_9564();
        } else {
            spheroidDimensionType = SpheroidLoader.SpheroidDimensionType.OVERWORLD;
            this.FLOOR_HEIGHT = StarrySkyCommon.STARRY_SKY_CONFIG.floorHeightOverworld;
            this.FLOOR_BLOCK_STATE = ((class_2248)class_2378.field_11146.method_10223(new class_2960(StarrySkyCommon.STARRY_SKY_CONFIG.floorBlockOverworld.toLowerCase()))).method_9564();
            this.BOTTOM_BLOCK_STATE = ((class_2248)class_2378.field_11146.method_10223(new class_2960(StarrySkyCommon.STARRY_SKY_CONFIG.bottomBlockOverworld.toLowerCase()))).method_9564();
        }
        this.systemGenerator = new SystemGenerator(spheroidDimensionType);
    }

    private static class_2338 returnClosestStrongholdSphere(class_2338 blockPos, class_3218 world, int radius) {
        class_2794 chunkGenerator = world.method_14178().method_12129();
        if (chunkGenerator instanceof StarrySkyChunkGenerator) {
            Support.SpheroidDistance spheroidDistance = Support.getClosestSpheroid3x3(world, blockPos, SpheroidAdvancementIdentifier.stronghold);
            if (Math.sqrt(spheroidDistance.squaredDistance) <= (double)(radius * 16)) {
                return spheroidDistance.spheroid.getPosition();
            }
        }
        return null;
    }

    public class_2338 method_12103(class_3218 world, class_3195<?> feature, class_2338 center, int radius, boolean skipExistingChunks) {
        if (feature.method_14019().equals("stronghold")) {
            return StarrySkyChunkGenerator.returnClosestStrongholdSphere(center, world, radius);
        }
        return super.method_12103(world, feature, center, radius, skipExistingChunks);
    }

    protected Codec<? extends class_2794> method_28506() {
        return CODEC;
    }

    @Environment(value=EnvType.CLIENT)
    public class_2794 method_27997(long seed) {
        return new StarrySkyChunkGenerator(this.field_24747.method_27985(seed), seed, () -> this.settings);
    }

    public void method_12110(class_3233 region, class_2791 chunk) {
        class_1923 chunkPos = chunk.method_12004();
        int chunkPosStartX = chunkPos.method_8326();
        int chunkPosStartZ = chunkPos.method_8328();
        if (this.FLOOR_HEIGHT > 0) {
            for (int y = 0; y <= this.method_16398(); ++y) {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        chunk.method_12010(new class_2338(chunkPosStartX + x, y, chunkPosStartZ + z), this.getSeaBlock(y), false);
                    }
                }
            }
        }
    }

    private class_2680 getSeaBlock(int heightY) {
        if (heightY == 0) {
            return this.BOTTOM_BLOCK_STATE;
        }
        return this.FLOOR_BLOCK_STATE;
    }

    public int method_12104() {
        return StarrySkyCommon.starryWorld.method_31605();
    }

    public CompletableFuture<class_2791> method_12088(Executor executor, class_5138 accessor, class_2791 chunk) {
        this.placeSpheroids(chunk);
        return CompletableFuture.completedFuture(chunk);
    }

    public void method_12107(class_3233 chunkRegion) {
        class_1923 chunkPos = chunkRegion.method_33561();
        List<Spheroid> localSystem = this.systemGenerator.getSystemAtChunkPos(chunkPos.field_9181, chunkPos.field_9180);
        class_2919 chunkRandom = new class_2919();
        chunkRandom.method_12661(chunkRegion.method_8412(), chunkPos.field_9181, chunkPos.field_9180);
        for (Spheroid spheroid : localSystem) {
            spheroid.populateEntities(chunkPos, chunkRegion, chunkRandom);
        }
    }

    public int method_16398() {
        return this.FLOOR_HEIGHT;
    }

    public int method_16397(int x, int z, class_2902.class_2903 heightmap, class_5539 world) {
        return this.FLOOR_HEIGHT;
    }

    public class_4966 method_26261(int x, int z, class_5539 world) {
        Object[] states = new class_2680[world.method_31605()];
        Arrays.fill(states, class_2246.field_10124.method_9564());
        return new class_4966(world.method_31607(), (class_2680[])states);
    }

    public void placeSpheroids(class_2791 chunk) {
        class_2919 chunkRandom = new class_2919(StarrySkyCommon.starryWorld.method_8412());
        chunkRandom.method_12659(chunk.method_12004().method_17885(), chunk.method_12004().method_17886());
        List<Spheroid> localSystem = this.systemGenerator.getSystemAtChunkPos(chunk.method_12004().field_9181, chunk.method_12004().field_9180);
        for (Spheroid spheroid : localSystem) {
            if (!spheroid.isInChunk(chunk.method_12004())) continue;
            StarrySkyCommon.log(Level.DEBUG, "Generating spheroid in chunk x:" + chunk.method_12004().field_9181 + " z:" + chunk.method_12004().field_9180 + " (StartX:" + chunk.method_12004().method_8326() + " StartZ:" + chunk.method_12004().method_8328() + ") " + spheroid.getDescription());
            spheroid.generate(chunk);
            StarrySkyCommon.log(Level.DEBUG, "Finished.");
        }
    }
}

