/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky.dimension;

import de.dafuqs.starrysky.StarrySkyCommon;
import de.dafuqs.starrysky.Support;
import de.dafuqs.starrysky.dimension.SpheroidLoader;
import de.dafuqs.starrysky.dimension.StarrySkyDimension;
import de.dafuqs.starrysky.dimension.spheroid.lists.SpheroidListVanilla;
import de.dafuqs.starrysky.dimension.spheroid.lists.SpheroidListVanillaEnd;
import de.dafuqs.starrysky.dimension.spheroid.lists.SpheroidListVanillaNether;
import de.dafuqs.starrysky.dimension.spheroid.spheroids.Spheroid;
import de.dafuqs.starrysky.dimension.spheroid.types.SpheroidType;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2919;
import net.minecraft.class_5321;
import org.apache.logging.log4j.Level;

public class SystemGenerator {
    public static HashMap<SpheroidLoader.SpheroidDimensionType, SystemGenerator> systemGeneratorMap = new HashMap();
    private final SpheroidLoader.SpheroidDimensionType spheroidDimensionType;
    private final HashMap<Point, List<Spheroid>> cache = new HashMap();
    public static SpheroidLoader spheroidLoader;
    private final int SYSTEM_SIZE_CHUNKS;
    private final int MIN_DISTANCE_BETWEEN_SPHERES;
    private final int SPHERE_DENSITY;
    private final int FLOOR_HEIGHT;

    public static SystemGenerator getSystemGeneratorOfWorld(class_5321<class_1937> worldRegistryKey) {
        if (worldRegistryKey.equals(StarrySkyDimension.STARRY_SKY_WORLD_KEY)) {
            return systemGeneratorMap.get((Object)SpheroidLoader.SpheroidDimensionType.OVERWORLD);
        }
        if (worldRegistryKey.equals(StarrySkyDimension.STARRY_SKY_NETHER_WORLD_KEY)) {
            return systemGeneratorMap.get((Object)SpheroidLoader.SpheroidDimensionType.NETHER);
        }
        return systemGeneratorMap.get((Object)SpheroidLoader.SpheroidDimensionType.END);
    }

    public SystemGenerator(SpheroidLoader.SpheroidDimensionType spheroidDimensionType) {
        this.spheroidDimensionType = spheroidDimensionType;
        spheroidLoader = new SpheroidLoader();
        systemGeneratorMap.put(spheroidDimensionType, this);
        this.SYSTEM_SIZE_CHUNKS = StarrySkyCommon.STARRY_SKY_CONFIG.systemSizeChunks;
        switch (spheroidDimensionType) {
            case OVERWORLD: {
                this.MIN_DISTANCE_BETWEEN_SPHERES = StarrySkyCommon.STARRY_SKY_CONFIG.minDistanceBetweenSpheresOverworld;
                this.SPHERE_DENSITY = StarrySkyCommon.STARRY_SKY_CONFIG.sphereDensityOverworld;
                this.FLOOR_HEIGHT = StarrySkyCommon.STARRY_SKY_CONFIG.floorHeightOverworld;
                break;
            }
            case NETHER: {
                this.MIN_DISTANCE_BETWEEN_SPHERES = StarrySkyCommon.STARRY_SKY_CONFIG.minDistanceBetweenSpheresNether;
                this.SPHERE_DENSITY = StarrySkyCommon.STARRY_SKY_CONFIG.sphereDensityNether;
                this.FLOOR_HEIGHT = StarrySkyCommon.STARRY_SKY_CONFIG.floorHeightNether;
                break;
            }
            default: {
                this.MIN_DISTANCE_BETWEEN_SPHERES = StarrySkyCommon.STARRY_SKY_CONFIG.minDistanceBetweenSpheresEnd;
                this.SPHERE_DENSITY = StarrySkyCommon.STARRY_SKY_CONFIG.sphereDensityEnd;
                this.FLOOR_HEIGHT = StarrySkyCommon.STARRY_SKY_CONFIG.floorHeightEnd;
            }
        }
    }

    public List<Spheroid> getSystemAtChunkPos(int chunkX, int chunkZ) {
        Point systemPos = Support.getSystemCoordinateFromChunkCoordinate(chunkX, chunkZ);
        return this.getSystemAtPoint(systemPos);
    }

    public List<Spheroid> getSystemAtPoint(Point systemPos) {
        List<Spheroid> curSystem = this.cache.get(systemPos);
        if (curSystem == null) {
            curSystem = this.generateSpheroidsAtSystemPoint(systemPos);
            this.cache.put(systemPos, curSystem);
        }
        return curSystem;
    }

    private class_2919 getSystemRandom(Point systemPoint) {
        int firstChunkPosX = systemPoint.x * this.SYSTEM_SIZE_CHUNKS;
        int firstChunkPosZ = systemPoint.y * this.SYSTEM_SIZE_CHUNKS;
        class_2919 systemRandom = new class_2919(StarrySkyCommon.starryWorld.method_8412());
        systemRandom.method_12659(firstChunkPosX, firstChunkPosZ);
        StarrySkyCommon.log(Level.DEBUG, "Generated seed for system at " + systemPoint.x + "," + systemPoint.y + "(first chunk: " + firstChunkPosX + "," + firstChunkPosZ);
        return systemRandom;
    }

    private class_2338 getBlockPosInSystem(Point systemPoint, int radius, class_2338 originalBlockPos) {
        int newX = originalBlockPos.method_10263();
        int newZ = originalBlockPos.method_10260();
        if (originalBlockPos.method_10263() - radius < systemPoint.x * StarrySkyCommon.STARRY_SKY_CONFIG.systemSizeChunks * 16) {
            newX = systemPoint.x * StarrySkyCommon.STARRY_SKY_CONFIG.systemSizeChunks * 16 + radius;
        }
        if (originalBlockPos.method_10263() + radius > (systemPoint.x + 1) * StarrySkyCommon.STARRY_SKY_CONFIG.systemSizeChunks * 16 - 1) {
            newX = (systemPoint.x + 1) * StarrySkyCommon.STARRY_SKY_CONFIG.systemSizeChunks * 16 - radius;
        }
        if (originalBlockPos.method_10260() - radius < systemPoint.y * StarrySkyCommon.STARRY_SKY_CONFIG.systemSizeChunks * 16) {
            newX = systemPoint.y * StarrySkyCommon.STARRY_SKY_CONFIG.systemSizeChunks * 16 + radius;
        }
        if (originalBlockPos.method_10260() + radius > (systemPoint.y + 1) * StarrySkyCommon.STARRY_SKY_CONFIG.systemSizeChunks * 16 - 1) {
            newX = (systemPoint.y + 1) * StarrySkyCommon.STARRY_SKY_CONFIG.systemSizeChunks * 16 - radius;
        }
        return new class_2338(newX, originalBlockPos.method_10264(), newZ);
    }

    private List<Spheroid> generateSpheroidsAtSystemPoint(Point systemPoint) {
        int systemPointX = systemPoint.x;
        int systemPointZ = systemPoint.y;
        class_2919 systemRandom = this.getSystemRandom(systemPoint);
        ArrayList<Spheroid> spheroids = new ArrayList<Spheroid>();
        ArrayList<Spheroid> defaultSpheroids = this.getDefaultSpheroids(systemPointX, systemPointZ, systemRandom);
        spheroids.addAll(defaultSpheroids);
        int worldHeight = StarrySkyCommon.starryWorld.method_31605();
        for (int currentDensity = 0; currentDensity < this.SPHERE_DENSITY; ++currentDensity) {
            Spheroid currentSpheroid = this.getRandomSpheroid(systemRandom);
            TempPosition tempPosition = new TempPosition();
            tempPosition.xPos = Support.getRandomBetween((Random)systemRandom, currentSpheroid.getRadius(), this.SYSTEM_SIZE_CHUNKS * 16 - currentSpheroid.getRadius());
            tempPosition.xPos += this.SYSTEM_SIZE_CHUNKS * 16 * systemPointX;
            tempPosition.zPos = Support.getRandomBetween((Random)systemRandom, currentSpheroid.getRadius(), this.SYSTEM_SIZE_CHUNKS * 16 - currentSpheroid.getRadius());
            tempPosition.zPos += this.SYSTEM_SIZE_CHUNKS * 16 * systemPointZ;
            tempPosition.yPos = systemRandom.nextInt(worldHeight - currentSpheroid.getRadius() * 2 - this.FLOOR_HEIGHT) + currentSpheroid.getRadius() + this.FLOOR_HEIGHT;
            boolean discard = false;
            for (Spheroid spheroid : spheroids) {
                int distMin = spheroid.getRadius() + currentSpheroid.getRadius() + this.MIN_DISTANCE_BETWEEN_SPHERES;
                int distSquared = tempPosition.distanceSquared(spheroid);
                if (distSquared >= distMin * distMin) continue;
                discard = true;
                break;
            }
            if (discard) continue;
            class_2338 finalSpheroidBlockPos = tempPosition.toBlockPos();
            currentSpheroid.setPositionAndCalculateChunks(finalSpheroidBlockPos);
            spheroids.add(currentSpheroid);
        }
        StarrySkyCommon.log(Level.DEBUG, "Created a new system with " + spheroids.size() + " spheroids at system position " + systemPointX + "," + systemPointZ);
        return spheroids;
    }

    private ArrayList<Spheroid> getDefaultSpheroids(int systemPointX, int systemPointZ, class_2919 random) {
        ArrayList<Spheroid> defaultSpheroids = new ArrayList<Spheroid>();
        switch (this.spheroidDimensionType) {
            case NETHER: {
                if (systemPointX != 0 || systemPointZ != 0) break;
                Spheroid spheroid = SpheroidListVanillaNether.NETHERRACK.getRandomSpheroid(random);
                spheroid.setPositionAndCalculateChunks(new class_2338(16, 70, 16));
                defaultSpheroids.add(spheroid);
                break;
            }
            case END: {
                if (systemPointX == 0 && systemPointZ == 0) {
                    Spheroid spheroid = SpheroidListVanillaEnd.END_SPAWN_WITH_PORTAL_AND_DRAGON.getRandomSpheroid(random);
                    spheroid.setPositionAndCalculateChunks(new class_2338(0, 29, 0));
                    defaultSpheroids.add(spheroid);
                    break;
                }
                if (!(systemPointX == -1 && systemPointZ == 0 || systemPointX == 0 && systemPointZ == -1) && (systemPointX != -1 || systemPointZ != -1)) break;
                Spheroid spheroid = SpheroidListVanillaEnd.END_SPAWN_WITH_PORTAL.getRandomSpheroid(random);
                spheroid.setPositionAndCalculateChunks(new class_2338(0, 29, 0));
                defaultSpheroids.add(spheroid);
                break;
            }
            default: {
                if (systemPointX != 0 || systemPointZ != 0) break;
                Spheroid spheroid = SpheroidListVanilla.OAK_WOOD.getRandomSpheroid(random);
                spheroid.setPositionAndCalculateChunks(new class_2338(16, 70, 16));
                defaultSpheroids.add(spheroid);
            }
        }
        return defaultSpheroids;
    }

    private Spheroid getRandomSpheroid(class_2919 systemRandom) {
        SpheroidType spheroidType;
        while ((spheroidType = SpheroidLoader.getWeightedRandomSpheroid(this.spheroidDimensionType, systemRandom)) == null) {
        }
        StarrySkyCommon.log(Level.DEBUG, "Created a new sphere of type " + spheroidType + " Next random: " + systemRandom.nextInt());
        return spheroidType.getRandomSpheroid(systemRandom);
    }

    public static class TempPosition {
        int xPos;
        int yPos;
        int zPos;

        public class_2338 toBlockPos() {
            return new class_2338(this.xPos, this.yPos, this.zPos);
        }

        private int distanceSquared(Spheroid pl1) {
            int xDist = this.xPos - pl1.getPosition().method_10263();
            int yDist = this.yPos - pl1.getPosition().method_10264();
            int zDist = this.zPos - pl1.getPosition().method_10260();
            return xDist * xDist + yDist * yDist + zDist * zDist;
        }
    }
}

