/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky.dimension.decorators;

import de.dafuqs.starrysky.Support;
import de.dafuqs.starrysky.dimension.SpheroidDecorator;
import de.dafuqs.starrysky.dimension.spheroid.spheroids.Spheroid;
import java.util.Random;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5281;

public class CenterPondDecorator
extends SpheroidDecorator {
    private final class_2960 lootTable;
    private final float lootTableChance;
    private final class_2680 beachBlockState;
    private final class_2680 liquidBlockState;

    public CenterPondDecorator(class_2680 beachBlockState, class_2680 liquidBlockState, class_2960 lootTable, float lootTableChance) {
        this.beachBlockState = beachBlockState;
        this.liquidBlockState = liquidBlockState;
        this.lootTable = lootTable;
        this.lootTableChance = lootTableChance;
    }

    @Override
    public void decorateSpheroid(class_5281 world, Spheroid spheroid, class_2338 origin, Random random) {
        if (!spheroid.isCenterInChunkBlockPos(origin)) {
            return;
        }
        if (spheroid.getRadius() > 9) {
            int pondRadius = (int)((double)spheroid.getRadius() / 2.5);
            class_2338 spheroidTop = spheroid.getPosition().method_10086(spheroid.getRadius());
            int waterLevelY = spheroidTop.method_10264();
            boolean waterLevelSet = false;
            for (int x = -pondRadius - 1; x <= pondRadius; ++x) {
                for (int y = -pondRadius; y < 1; ++y) {
                    for (int z = -pondRadius - 1; z <= pondRadius; ++z) {
                        class_2338 currentBlockPos = spheroidTop.method_10069(x, y, z);
                        if (!world.method_8320(currentBlockPos).method_26215()) continue;
                        waterLevelY = currentBlockPos.method_10264() - 1;
                        waterLevelSet = true;
                        break;
                    }
                    if (waterLevelSet) break;
                }
                if (waterLevelSet) break;
            }
            if ((double)(waterLevelY - spheroid.getPosition().method_10264()) < (double)pondRadius * 1.5) {
                return;
            }
            boolean hasLootChest = random.nextFloat() < this.lootTableChance;
            class_2338 lootChestPosition = null;
            int pond15 = (int)Math.round((double)pondRadius * 1.5);
            for (int x = -pond15; x <= pond15; ++x) {
                for (int y = -pondRadius; y < pondRadius; ++y) {
                    for (int z = -pond15; z <= pond15; ++z) {
                        class_2338 currentBlockPos = spheroidTop.method_10069(x, y, z);
                        class_2680 blockState = null;
                        if (currentBlockPos.method_10264() > waterLevelY) {
                            blockState = class_2246.field_10124.method_9564();
                        } else {
                            double distance = Support.getDistance(currentBlockPos, spheroidTop);
                            double pondDistance = distance / (double)pondRadius;
                            if (pondDistance < 1.1) {
                                if (hasLootChest && x == 0 && z == 0 && lootChestPosition == null) {
                                    lootChestPosition = currentBlockPos;
                                }
                                blockState = this.liquidBlockState;
                            } else if (pondDistance < 1.7) {
                                blockState = this.beachBlockState;
                            }
                        }
                        if (blockState == null || world.method_8320(currentBlockPos).method_26215()) continue;
                        world.method_8652(currentBlockPos, blockState, 3);
                    }
                }
            }
            if (lootChestPosition != null) {
                this.placeLootChestAtPosition(world, lootChestPosition, this.lootTable, random);
            }
        }
    }
}

