/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky.dimension.decorators.overworld;

import de.dafuqs.starrysky.dimension.DecorationMode;
import de.dafuqs.starrysky.dimension.SpheroidDecorator;
import de.dafuqs.starrysky.dimension.spheroid.spheroids.Spheroid;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5281;
import net.minecraft.class_5689;
import net.minecraft.class_5691;

public class PointedDripstoneDecorator
extends SpheroidDecorator {
    private final float chance;
    private final PointedDripstoneDecoratorMode mode;

    public PointedDripstoneDecorator(float chance, PointedDripstoneDecoratorMode mode) {
        this.chance = chance;
        this.mode = mode;
    }

    @Override
    public void decorateSpheroid(class_5281 world, Spheroid spheroid, class_2338 origin, Random random) {
        int height = random.nextInt(6);
        switch (this.mode) {
            case UP: {
                for (class_2338 bp : this.getDecorationPositionsInChunk(spheroid, world, origin, random, this.chance, DecorationMode.TOP)) {
                    PointedDripstoneDecorator.generatePointedDripstone(world, bp, class_2350.field_11036, height, false);
                }
                break;
            }
            case DOWN: {
                for (class_2338 bp : this.getDecorationPositionsInChunk(spheroid, world, origin, random, this.chance, DecorationMode.BOTTOM)) {
                    PointedDripstoneDecorator.generatePointedDripstone(world, bp, class_2350.field_11033, height, false);
                }
                break;
            }
            case CAVE: {
                for (class_2338 bp : this.getDecorationPositionsInChunk(spheroid, world, origin, random, this.chance, DecorationMode.CAVE_BOTTOM)) {
                    PointedDripstoneDecorator.generatePointedDripstone(world, bp, class_2350.field_11036, height, false);
                }
                for (class_2338 bp : this.getDecorationPositionsInChunk(spheroid, world, origin, random, this.chance, DecorationMode.CAVE_TOP)) {
                    PointedDripstoneDecorator.generatePointedDripstone(world, bp, class_2350.field_11033, height, false);
                }
                break;
            }
        }
    }

    protected static void generatePointedDripstone(class_5281 world, class_2338 pos, class_2350 direction, int height, boolean merge) {
        class_2338.class_2339 mutable = pos.method_25503();
        PointedDripstoneDecorator.getDripstoneThickness(direction, height, merge, state -> {
            if (state.method_27852(class_2246.field_28048)) {
                state = (class_2680)state.method_11657((class_2769)class_5689.field_28052, (Comparable)Boolean.valueOf(world.method_22351((class_2338)mutable)));
            }
            world.method_8652((class_2338)mutable, state, 2);
            mutable.method_10098(direction);
        });
    }

    protected static void getDripstoneThickness(class_2350 direction, int height, boolean merge, Consumer<class_2680> callback) {
        if (height >= 3) {
            callback.accept(PointedDripstoneDecorator.getState(direction, class_5691.field_28068));
            for (int i = 0; i < height - 3; ++i) {
                callback.accept(PointedDripstoneDecorator.getState(direction, class_5691.field_28067));
            }
        }
        if (height >= 2) {
            callback.accept(PointedDripstoneDecorator.getState(direction, class_5691.field_28066));
        }
        if (height >= 1) {
            callback.accept(PointedDripstoneDecorator.getState(direction, merge ? class_5691.field_28064 : class_5691.field_28065));
        }
    }

    private static class_2680 getState(class_2350 direction, class_5691 thickness) {
        return (class_2680)((class_2680)class_2246.field_28048.method_9564().method_11657((class_2769)class_5689.field_28050, (Comparable)direction)).method_11657((class_2769)class_5689.field_28051, (Comparable)thickness);
    }

    public static enum PointedDripstoneDecoratorMode {
        UP,
        DOWN,
        CAVE;

    }
}

