/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky.dimension.spheroid.spheroids;

import de.dafuqs.starrysky.Support;
import de.dafuqs.starrysky.advancements.SpheroidAdvancementIdentifier;
import de.dafuqs.starrysky.dimension.SpheroidDecorator;
import de.dafuqs.starrysky.dimension.spheroid.SpheroidEntitySpawnDefinition;
import de.dafuqs.starrysky.dimension.spheroid.lists.SpheroidList;
import de.dafuqs.starrysky.dimension.spheroid.spheroids.Spheroid;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2919;
import net.minecraft.class_2960;

public class CoralSpheroid
extends Spheroid {
    protected class_2680 shellBlock;
    protected int shellRadius;
    protected class_2680 WATER = class_2246.field_10382.method_9564();
    protected class_2960 centerChestLootTable;

    public CoralSpheroid(class_2919 random, SpheroidAdvancementIdentifier spheroidAdvancementIdentifier, int radius, ArrayList<SpheroidDecorator> spheroidDecorators, ArrayList<SpheroidEntitySpawnDefinition> entityTypesToSpawn, class_2680 shellBlock, int shellRadius, class_2960 centerChestLootTable) {
        super(spheroidAdvancementIdentifier, random, spheroidDecorators, radius, entityTypesToSpawn);
        this.shellBlock = shellBlock;
        this.shellRadius = shellRadius;
        this.centerChestLootTable = centerChestLootTable;
    }

    @Override
    public void generate(class_2791 chunk) {
        int chunkX = chunk.method_12004().field_9181;
        int chunkZ = chunk.method_12004().field_9180;
        int x = this.getPosition().method_10263();
        int y = this.getPosition().method_10264();
        int z = this.getPosition().method_10260();
        boolean hasChest = this.centerChestLootTable != null;
        this.random.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        for (int x2 = Math.max(chunkX * 16, x - this.radius); x2 <= Math.min(chunkX * 16 + 15, x + this.radius); ++x2) {
            for (int y2 = y - this.radius; y2 <= y + this.radius; ++y2) {
                for (int z2 = Math.max(chunkZ * 16, z - this.radius); z2 <= Math.min(chunkZ * 16 + 15, z + this.radius); ++z2) {
                    class_2338 currBlockPos = new class_2338(x2, y2, z2);
                    long d = Math.round(Support.getDistance(x, y, z, x2, y2, z2));
                    if (d == 0L && hasChest) {
                        this.placeCenterChestWithLootTable(chunk, currBlockPos, this.centerChestLootTable, (Random)this.random, true);
                        continue;
                    }
                    if (d <= (long)(this.radius - this.shellRadius - 1)) {
                        int rand = this.random.nextInt(7);
                        if (rand < 2) {
                            class_2680 coral = this.getRandomCoralBlock(this.random);
                            if (rand == 0 && chunk.method_8320(currBlockPos.method_10074()).method_26204() == class_2246.field_10382) {
                                chunk.method_12010(currBlockPos.method_10074(), coral, false);
                                chunk.method_12010(currBlockPos, this.getRandomWaterLoggableBlock(this.random), false);
                                continue;
                            }
                            chunk.method_12010(currBlockPos, coral, false);
                            continue;
                        }
                        chunk.method_12010(currBlockPos, this.WATER, false);
                        continue;
                    }
                    if (d <= (long)(this.radius - this.shellRadius)) {
                        chunk.method_12010(currBlockPos, this.WATER, false);
                        continue;
                    }
                    if (d > (long)this.radius) continue;
                    chunk.method_12010(currBlockPos, this.shellBlock, false);
                }
            }
        }
    }

    @Override
    public String getDescription() {
        return "+++ CoralSpheroid +++\nPosition: x=" + this.getPosition().method_10263() + " y=" + this.getPosition().method_10264() + " z=" + this.getPosition().method_10260() + "\nRadius: " + this.radius + "\nShell: " + this.shellBlock.toString() + " (Radius: " + this.shellRadius + ")";
    }

    public class_2680 getRandomCoralBlock(class_2919 random) {
        return SpheroidList.LIST_FULL_CORAL_BLOCKS.get(random.nextInt(SpheroidList.LIST_FULL_CORAL_BLOCKS.size()));
    }

    public class_2680 getRandomWaterLoggableBlock(class_2919 random) {
        return SpheroidList.LIST_WATERLOGGABLE_CORAL_BLOCKS.get(random.nextInt(SpheroidList.LIST_WATERLOGGABLE_CORAL_BLOCKS.size()));
    }
}

