/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky.dimension.spheroid.spheroids;

import de.dafuqs.starrysky.Support;
import de.dafuqs.starrysky.advancements.SpheroidAdvancementIdentifier;
import de.dafuqs.starrysky.dimension.SpheroidDecorator;
import de.dafuqs.starrysky.dimension.spheroid.SpheroidEntitySpawnDefinition;
import de.dafuqs.starrysky.dimension.spheroid.spheroids.Spheroid;
import java.util.ArrayList;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2919;

public class DoubleCoreSpheroid
extends Spheroid {
    private final class_2680 innerCoreBlock;
    private final class_2680 outerCoreBlock;
    private final class_2680 shellBlock;
    private final int innerCoreRadius;
    private final int shellRadius;

    public DoubleCoreSpheroid(class_2919 random, SpheroidAdvancementIdentifier spheroidAdvancementIdentifier, int radius, ArrayList<SpheroidDecorator> spheroidDecorators, ArrayList<SpheroidEntitySpawnDefinition> entityTypesToSpawn, class_2680 innerCoreBlock, class_2680 outerCoreBlock, class_2680 shellBlock, int innerCoreRadius, int shellRadius) {
        super(spheroidAdvancementIdentifier, random, spheroidDecorators, radius, entityTypesToSpawn);
        this.innerCoreBlock = innerCoreBlock;
        this.outerCoreBlock = outerCoreBlock;
        this.shellBlock = shellBlock;
        this.shellRadius = shellRadius;
        this.innerCoreRadius = radius <= shellRadius + innerCoreRadius ? Math.max(1, radius - shellRadius - 2) : innerCoreRadius;
    }

    @Override
    public String getDescription() {
        return "+++ DoubleCoreSpheroid +++\nPosition: x=" + this.getPosition().method_10263() + " y=" + this.getPosition().method_10264() + " z=" + this.getPosition().method_10260() + "\nRadius: " + this.radius + "\nShell: " + this.shellBlock.toString() + " (Radius: " + this.shellRadius + ")\nInner Core: " + this.innerCoreBlock.toString() + " (Radius: " + this.innerCoreRadius + ")\nOuter Core: " + this.outerCoreBlock.toString();
    }

    @Override
    public void generate(class_2791 chunk) {
        int chunkX = chunk.method_12004().field_9181;
        int chunkZ = chunk.method_12004().field_9180;
        int x = this.getPosition().method_10263();
        int y = this.getPosition().method_10264();
        int z = this.getPosition().method_10260();
        this.random.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        for (int x2 = Math.max(chunkX * 16, x - this.radius); x2 <= Math.min(chunkX * 16 + 15, x + this.radius); ++x2) {
            for (int y2 = y - this.radius; y2 <= y + this.radius; ++y2) {
                for (int z2 = Math.max(chunkZ * 16, z - this.radius); z2 <= Math.min(chunkZ * 16 + 15, z + this.radius); ++z2) {
                    class_2338 currBlockPos = new class_2338(x2, y2, z2);
                    long d = Math.round(Support.getDistance(x, y, z, x2, y2, z2));
                    if (d <= (long)this.innerCoreRadius) {
                        chunk.method_12010(currBlockPos, this.innerCoreBlock, false);
                        continue;
                    }
                    if (d <= (long)(this.radius - this.shellRadius)) {
                        chunk.method_12010(currBlockPos, this.outerCoreBlock, false);
                        continue;
                    }
                    if (d > (long)this.radius) continue;
                    chunk.method_12010(currBlockPos, this.shellBlock, false);
                }
            }
        }
    }
}

