/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky.dimension.spheroid.spheroids;

import de.dafuqs.starrysky.Support;
import de.dafuqs.starrysky.advancements.SpheroidAdvancementIdentifier;
import de.dafuqs.starrysky.dimension.SpheroidDecorator;
import de.dafuqs.starrysky.dimension.spheroid.SpheroidEntitySpawnDefinition;
import de.dafuqs.starrysky.dimension.spheroid.spheroids.Spheroid;
import java.util.ArrayList;
import net.minecraft.class_1299;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2919;
import net.minecraft.class_39;

public class DungeonSpheroid
extends Spheroid {
    private final class_1299 entityType;
    private final class_2680 shellBlock;
    private final int shellRadius;

    public DungeonSpheroid(class_2919 random, SpheroidAdvancementIdentifier spheroidAdvancementIdentifier, int radius, ArrayList<SpheroidDecorator> spheroidDecorators, ArrayList<SpheroidEntitySpawnDefinition> entityTypesToSpawn, class_1299 entityType, class_2680 shellBlock, int shellRadius) {
        super(spheroidAdvancementIdentifier, random, spheroidDecorators, radius, entityTypesToSpawn);
        this.entityType = entityType;
        this.shellBlock = shellBlock;
        this.shellRadius = shellRadius;
    }

    @Override
    public void generate(class_2791 chunk) {
        int chunkX = chunk.method_12004().field_9181;
        int chunkZ = chunk.method_12004().field_9180;
        int x = this.getPosition().method_10263();
        int y = this.getPosition().method_10264();
        int z = this.getPosition().method_10260();
        class_2680 chestBlockState = class_2246.field_10034.method_9564();
        this.random.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        for (int x2 = Math.max(chunkX * 16, x - this.radius); x2 <= Math.min(chunkX * 16 + 15, x + this.radius); ++x2) {
            for (int y2 = y - this.radius; y2 <= y + this.radius; ++y2) {
                for (int z2 = Math.max(chunkZ * 16, z - this.radius); z2 <= Math.min(chunkZ * 16 + 15, z + this.radius); ++z2) {
                    class_2338 currBlockPos = new class_2338(x2, y2, z2);
                    long d = Math.round(Support.getDistance(x, y, z, x2, y2, z2));
                    if (d == 0L) {
                        chunk.method_12010(currBlockPos, class_2246.field_10260.method_9564(), false);
                        chunk.method_12007((class_2586)new class_2636(currBlockPos, class_2246.field_10260.method_9564()));
                        class_2586 blockEntity_1 = chunk.method_8321(currBlockPos);
                        if (!(blockEntity_1 instanceof class_2636)) continue;
                        ((class_2636)blockEntity_1).method_11390().method_8274(this.entityType);
                        continue;
                    }
                    if (this.isAboveCaveFloorBlock(d, x2, y2, z2, this.shellRadius) && this.random.nextInt(this.radius * 9) == 0) {
                        chunk.method_12010(currBlockPos, chestBlockState, false);
                        chunk.method_12007((class_2586)new class_2595(currBlockPos, chestBlockState));
                        class_2586 chestBlockEntity = chunk.method_8321(currBlockPos);
                        if (!(chestBlockEntity instanceof class_2595)) continue;
                        ((class_2595)chestBlockEntity).method_11285(class_39.field_356, this.random.nextLong());
                        continue;
                    }
                    if (d <= (long)(this.radius - this.shellRadius)) {
                        chunk.method_12010(currBlockPos, class_2246.field_10543.method_9564(), false);
                        continue;
                    }
                    if (d > (long)this.radius) continue;
                    chunk.method_12010(currBlockPos, this.shellBlock, false);
                }
            }
        }
    }

    @Override
    public String getDescription() {
        return "+++ DungeonSpheroid +++\nPosition: x=" + this.getPosition().method_10263() + " y=" + this.getPosition().method_10264() + " z=" + this.getPosition().method_10260() + "\nRadius: " + this.radius + "\nShellBlock: " + this.shellBlock + "\nShellRadius: " + this.shellRadius + "\nEntityType: " + this.entityType.method_5897();
    }
}

