/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky.dimension.spheroid.spheroids;

import de.dafuqs.starrysky.Support;
import de.dafuqs.starrysky.advancements.SpheroidAdvancementIdentifier;
import de.dafuqs.starrysky.dimension.SpheroidDecorator;
import de.dafuqs.starrysky.dimension.spheroid.SpheroidEntitySpawnDefinition;
import de.dafuqs.starrysky.dimension.spheroid.spheroids.Spheroid;
import java.util.ArrayList;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2919;

public class LiquidSpheroid
extends Spheroid {
    private final class_2680 CAVE_AIR = class_2246.field_10543.method_9564();
    private final class_2680 liquid;
    private final class_2680 shellBlock;
    private final int shellRadius;
    private final int fillPercent;
    private final boolean holeInBottom;
    private final class_2680 coreBlock;
    private int coreRadius;

    public LiquidSpheroid(class_2919 random, SpheroidAdvancementIdentifier spheroidAdvancementIdentifier, int radius, ArrayList<SpheroidDecorator> spheroidDecorators, ArrayList<SpheroidEntitySpawnDefinition> entityTypesToSpawn, class_2680 liquid, class_2680 shellBlock, int shellRadius, int fillPercent, boolean holeInBottom, class_2680 coreBlock, int coreRadius) {
        super(spheroidAdvancementIdentifier, random, spheroidDecorators, radius, entityTypesToSpawn);
        this.liquid = liquid;
        this.shellBlock = shellBlock;
        this.shellRadius = shellRadius;
        this.fillPercent = fillPercent;
        this.holeInBottom = holeInBottom;
        this.coreBlock = coreBlock;
        this.coreRadius = this.coreBlock != null ? coreRadius : 0;
        if (this.coreRadius >= this.radius - this.shellRadius - 1) {
            this.coreRadius = this.radius - this.shellRadius - 2;
        }
    }

    @Override
    public String getDescription() {
        String s = "+++ LiquidSpheroid +++\nPosition: x=" + this.getPosition().method_10263() + " y=" + this.getPosition().method_10264() + " z=" + this.getPosition().method_10260() + "\nRadius: " + this.radius + "\nShell: " + this.shellBlock.toString() + "(Radius: " + this.shellRadius + ")\nLiquid: " + this.liquid.toString();
        s = this.coreBlock != null ? s + "\nCore: " + this.coreBlock.toString() + "(Radius: " + this.coreRadius + ")" : s + "\nNo Core";
        s = s + "\nFill Percent: " + this.fillPercent + "\nHole in bottom: " + this.holeInBottom;
        return s;
    }

    @Override
    public void generate(class_2791 chunk) {
        int chunkX = chunk.method_12004().field_9181;
        int chunkZ = chunk.method_12004().field_9180;
        int x = this.getPosition().method_10263();
        int y = this.getPosition().method_10264();
        int z = this.getPosition().method_10260();
        int liquidRadius = this.radius - this.shellRadius;
        float maxLiquidY = (float)y + ((float)this.fillPercent / 100.0f * (float)liquidRadius * 2.0f - (float)liquidRadius);
        this.random.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        for (int x2 = Math.max(chunkX * 16, x - this.radius); x2 <= Math.min(chunkX * 16 + 15, x + this.radius); ++x2) {
            for (int y2 = y - this.radius; y2 <= y + this.radius; ++y2) {
                for (int z2 = Math.max(chunkZ * 16, z - this.radius); z2 <= Math.min(chunkZ * 16 + 15, z + this.radius); ++z2) {
                    class_2338 currBlockPos = new class_2338(x2, y2, z2);
                    long d = Math.round(Support.getDistance(x, y, z, x2, y2, z2));
                    if (this.holeInBottom && x - x2 == 0 && z - z2 == 0 && y - y2 + 1 >= liquidRadius) {
                        chunk.method_12010(new class_2338((class_2382)currBlockPos), this.liquid, false);
                        chunk.method_12039(currBlockPos);
                        continue;
                    }
                    if (this.coreBlock != null && d <= (long)this.coreRadius) {
                        chunk.method_12010(currBlockPos, this.coreBlock, false);
                        continue;
                    }
                    if (d <= (long)liquidRadius) {
                        if ((float)y2 <= maxLiquidY) {
                            chunk.method_12010(currBlockPos, this.liquid, false);
                            continue;
                        }
                        chunk.method_12010(currBlockPos, this.CAVE_AIR, false);
                        continue;
                    }
                    if (d > (long)this.radius) continue;
                    chunk.method_12010(currBlockPos, this.shellBlock, false);
                }
            }
        }
    }
}

