/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky.dimension.spheroid.spheroids;

import de.dafuqs.starrysky.Support;
import de.dafuqs.starrysky.advancements.SpheroidAdvancementIdentifier;
import de.dafuqs.starrysky.dimension.SpheroidDecorator;
import de.dafuqs.starrysky.dimension.spheroid.SpheroidEntitySpawnDefinition;
import de.dafuqs.starrysky.dimension.spheroid.spheroids.Spheroid;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2919;

public class ShellSpheroid
extends Spheroid {
    protected class_2680 coreBlock;
    protected class_2680 shellBlock;
    protected int shellRadius;
    private final LinkedHashMap<class_2680, Float> shellSpeckleBlockStates;

    public ShellSpheroid(class_2919 random, SpheroidAdvancementIdentifier spheroidAdvancementIdentifier, int radius, ArrayList<SpheroidDecorator> spheroidDecorators, ArrayList<SpheroidEntitySpawnDefinition> entityTypesToSpawn, class_2680 coreBlock, class_2680 shellBlock, int shellRadius, LinkedHashMap<class_2680, Float> shellSpeckleBlockStates) {
        super(spheroidAdvancementIdentifier, random, spheroidDecorators, radius, entityTypesToSpawn);
        this.radius = radius;
        this.coreBlock = coreBlock;
        this.shellBlock = shellBlock;
        this.shellRadius = shellRadius;
        this.shellSpeckleBlockStates = shellSpeckleBlockStates;
    }

    @Override
    public String getDescription() {
        return "+++ ShellSpheroid +++\nPosition: x=" + this.getPosition().method_10263() + " y=" + this.getPosition().method_10264() + " z=" + this.getPosition().method_10260() + "\nRadius: " + this.radius + "\nShell: " + this.shellBlock.toString() + " (Radius: " + this.shellRadius + ")\nCore: " + this.coreBlock.toString();
    }

    @Override
    public void generate(class_2791 chunk) {
        int chunkX = chunk.method_12004().field_9181;
        int chunkZ = chunk.method_12004().field_9180;
        int x = this.getPosition().method_10263();
        int y = this.getPosition().method_10264();
        int z = this.getPosition().method_10260();
        boolean hasSpeckles = this.hasSpeckles();
        this.random.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        for (int x2 = Math.max(chunkX * 16, x - this.radius); x2 <= Math.min(chunkX * 16 + 15, x + this.radius); ++x2) {
            for (int y2 = y - this.radius; y2 <= y + this.radius; ++y2) {
                for (int z2 = Math.max(chunkZ * 16, z - this.radius); z2 <= Math.min(chunkZ * 16 + 15, z + this.radius); ++z2) {
                    class_2338 currBlockPos = new class_2338(x2, y2, z2);
                    long d = Math.round(Support.getDistance(x, y, z, x2, y2, z2));
                    if (d <= (long)(this.radius - this.shellRadius)) {
                        chunk.method_12010(currBlockPos, this.coreBlock, false);
                        continue;
                    }
                    if (d > (long)this.radius) continue;
                    if (hasSpeckles) {
                        class_2680 finalBlockState = this.shellBlock;
                        for (Map.Entry<class_2680, Float> shellSpeckleBlockState : this.shellSpeckleBlockStates.entrySet()) {
                            if (!(this.random.nextFloat() < shellSpeckleBlockState.getValue().floatValue())) continue;
                            finalBlockState = shellSpeckleBlockState.getKey();
                            break;
                        }
                        chunk.method_12010(currBlockPos, finalBlockState, false);
                        continue;
                    }
                    chunk.method_12010(currBlockPos, this.shellBlock, false);
                }
            }
        }
    }

    private boolean hasSpeckles() {
        return this.shellSpeckleBlockStates.size() > 0;
    }
}

