/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky.dimension.spheroid.spheroids;

import de.dafuqs.starrysky.StarrySkyCommon;
import de.dafuqs.starrysky.Support;
import de.dafuqs.starrysky.advancements.SpheroidAdvancementIdentifier;
import de.dafuqs.starrysky.dimension.SpheroidDecorator;
import de.dafuqs.starrysky.dimension.spheroid.SpheroidEntitySpawnDefinition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2621;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3233;
import net.minecraft.class_3730;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import org.apache.logging.log4j.Level;

public abstract class Spheroid
implements Serializable {
    protected SpheroidAdvancementIdentifier spheroidAdvancementIdentifier;
    protected ArrayList<SpheroidEntitySpawnDefinition> entityTypesToSpawn;
    protected class_2338 position;
    protected int radius;
    protected class_2919 random;
    private final HashSet<class_1923> chunksOfSpheroid = new HashSet();
    private final ArrayList<SpheroidDecorator> spheroidDecorators;

    public Spheroid(SpheroidAdvancementIdentifier spheroidAdvancementIdentifier, class_2919 random, ArrayList<SpheroidDecorator> spheroidDecorators, int radius, ArrayList<SpheroidEntitySpawnDefinition> entityTypesToSpawn) {
        this.spheroidAdvancementIdentifier = spheroidAdvancementIdentifier;
        this.random = random;
        this.spheroidDecorators = spheroidDecorators;
        this.radius = radius;
        this.entityTypesToSpawn = entityTypesToSpawn;
    }

    public abstract void generate(class_2791 var1);

    public class_2338 getPosition() {
        return this.position;
    }

    public void setPositionAndCalculateChunks(class_2338 blockPos) {
        this.position = blockPos;
        for (int currXPos = blockPos.method_10263() - this.radius; currXPos <= blockPos.method_10263() + this.radius; ++currXPos) {
            for (int currZPos = blockPos.method_10260() - this.radius; currZPos <= blockPos.method_10260() + this.radius; ++currZPos) {
                int cx = (int)Math.floor((double)currXPos / 16.0);
                int cz = (int)Math.floor((double)currZPos / 16.0);
                this.chunksOfSpheroid.add(new class_1923(cx, cz));
            }
        }
    }

    public SpheroidAdvancementIdentifier getSpheroidAdvancementIdentifier() {
        return this.spheroidAdvancementIdentifier;
    }

    public int getRadius() {
        return this.radius;
    }

    public abstract String getDescription();

    public boolean isInChunk(class_1923 chunkPos) {
        return this.chunksOfSpheroid.contains(chunkPos);
    }

    public boolean hasDecorators() {
        return this.spheroidDecorators.size() > 0;
    }

    public void decorate(class_5281 world, Random random, class_2338 origin) {
        for (SpheroidDecorator decorator : this.spheroidDecorators) {
            StarrySkyCommon.log(Level.DEBUG, "Decorator: " + decorator.getClass());
            try {
                decorator.decorateSpheroid(world, this, origin, random);
            }
            catch (RuntimeException runtimeException) {}
        }
    }

    protected boolean isTopBlock(long d, double x, double y, double z) {
        if (d == (long)this.radius) {
            long dist2 = Math.round(Support.getDistance(this.getPosition().method_10263(), this.getPosition().method_10264(), this.getPosition().method_10260(), x, y + 1.0, z));
            return dist2 > (long)this.radius;
        }
        return false;
    }

    protected boolean isBottomBlock(long d, double x, double y, double z) {
        if (d == (long)this.radius) {
            long dist2 = Math.round(Support.getDistance(this.getPosition().method_10263(), this.getPosition().method_10264(), this.getPosition().method_10260(), x, y - 1.0, z));
            return dist2 > (long)this.radius;
        }
        return false;
    }

    protected boolean isAboveCaveFloorBlock(long d, double x, double y, double z, int shellRadius) {
        if (d == (long)(this.radius - shellRadius)) {
            int distance1 = (int)Math.round(Support.getDistance(this.getPosition().method_10263(), this.getPosition().method_10264(), this.getPosition().method_10260(), x, y - 1.0, z));
            return distance1 > this.radius - shellRadius;
        }
        return false;
    }

    protected void placeCenterChestWithLootTable(class_2791 chunk, class_2338 blockPos, class_2960 lootTable, Random random, boolean waterLogged) {
        class_2680 chestBlockState = waterLogged ? (class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10772, (Comparable)Boolean.valueOf(true)) : class_2246.field_10034.method_9564();
        chunk.method_12010(blockPos, chestBlockState, false);
        chunk.method_12007((class_2586)new class_2595(blockPos, chestBlockState));
        class_2621.method_11287((class_1922)chunk, (Random)random, (class_2338)blockPos, (class_2960)lootTable);
    }

    public boolean shouldPopulateEntities(class_1923 chunkPos) {
        return this.isCenterInChunk(chunkPos);
    }

    public boolean isCenterInChunk(class_1923 chunkPos) {
        return this.getPosition().method_10263() >= chunkPos.method_8326() && this.getPosition().method_10263() <= chunkPos.method_8326() + 15 && this.getPosition().method_10260() >= chunkPos.method_8328() && this.getPosition().method_10260() <= chunkPos.method_8328() + 15;
    }

    public boolean isCenterInChunkBlockPos(class_2338 blockPos) {
        return this.getPosition().method_10263() >= blockPos.method_10263() && this.getPosition().method_10263() <= blockPos.method_10263() + 15 && this.getPosition().method_10260() >= blockPos.method_10260() && this.getPosition().method_10260() <= blockPos.method_10260() + 15;
    }

    public void populateEntities(class_1923 chunkPos, class_3233 chunkRegion, class_2919 chunkRandom) {
        if (this.shouldPopulateEntities(chunkPos)) {
            StarrySkyCommon.log(Level.DEBUG, "Populating entities for spheroid in chunk x:" + chunkPos.field_9181 + " z:" + chunkPos.field_9180 + " (StartX:" + chunkPos.method_8326() + " StartZ:" + chunkPos.method_8328() + ") " + this.getDescription());
            for (SpheroidEntitySpawnDefinition entityTypeToSpawn : this.entityTypesToSpawn) {
                int xCord = chunkPos.method_8326();
                int zCord = chunkPos.method_8328();
                class_2919 sharedSeedRandom = new class_2919();
                sharedSeedRandom.method_12661(chunkRegion.method_8412(), xCord, zCord);
                int randomAmount = Support.getRandomBetween((Random)this.random, entityTypeToSpawn.minAmount, entityTypeToSpawn.maxAmount);
                for (int i = 0; i < randomAmount; ++i) {
                    class_2338 spheroidTopPosition = this.getPosition().method_10086(this.getRadius() + 1);
                    int height = chunkRegion.method_22347(spheroidTopPosition) ? Support.getLowerGroundBlock((class_1936)chunkRegion, spheroidTopPosition, chunkRegion.method_32819()) : Support.getUpperGroundBlock((class_1936)chunkRegion, spheroidTopPosition, chunkRegion.method_32819());
                    class_1297 entity = entityTypeToSpawn.entityType.method_5883((class_1937)chunkRegion.method_8410());
                    if (entity == null) continue;
                    try {
                        class_1308 mobentity;
                        entity.method_5808((double)spheroidTopPosition.method_10263() + 0.5, (double)height, (double)spheroidTopPosition.method_10260() + 0.5, sharedSeedRandom.nextFloat() * 360.0f, 0.0f);
                        if (!(entity instanceof class_1308) || !(mobentity = (class_1308)entity).method_5979((class_1936)chunkRegion, class_3730.field_16472)) continue;
                        mobentity.method_5943((class_5425)chunkRegion, chunkRegion.method_8404(new class_2338(mobentity.method_19538())), class_3730.field_16472, null, null);
                        chunkRegion.method_8649((class_1297)mobentity);
                        continue;
                    }
                    catch (Exception exception) {
                        StarrySkyCommon.log(Level.WARN, "Failed to spawn mob on sphere" + this.getDescription() + "\nException: " + exception.getMessage());
                    }
                }
            }
            StarrySkyCommon.log(Level.DEBUG, "Finished populating");
        }
    }

    public boolean shouldDecorate(class_2338 blockPos) {
        return this.chunksOfSpheroid.contains(new class_1923(blockPos.method_10263() / 16, blockPos.method_10260() / 16));
    }

    protected void placeSpawner(class_1936 worldAccess, class_2338 blockPos, class_1299 entityType) {
        worldAccess.method_8652(blockPos, class_2246.field_10260.method_9564(), 3);
        class_2586 blockEntity = worldAccess.method_8321(blockPos);
        if (blockEntity instanceof class_2636) {
            ((class_2636)blockEntity).method_11390().method_8274(entityType);
        }
    }
}

