/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky.dimension.spheroid.spheroids.unique;

import de.dafuqs.starrysky.Support;
import de.dafuqs.starrysky.advancements.SpheroidAdvancementIdentifier;
import de.dafuqs.starrysky.dimension.SpheroidDecorator;
import de.dafuqs.starrysky.dimension.spheroid.SpheroidEntitySpawnDefinition;
import de.dafuqs.starrysky.dimension.spheroid.spheroids.Spheroid;
import java.util.ArrayList;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2919;

public class GeodeSpheroid
extends Spheroid {
    private final class_2680 innerBlockState;
    private final class_2680 innerSpecklesBlockState;
    private final float speckleChance;
    private final class_2680 middleBlockSate;
    private final class_2680 outerBlockState;

    public GeodeSpheroid(class_2919 random, SpheroidAdvancementIdentifier spheroidAdvancementIdentifier, int radius, ArrayList<SpheroidDecorator> spheroidDecorators, ArrayList<SpheroidEntitySpawnDefinition> entityTypesToSpawn, class_2680 innerBlockState, class_2680 innerSpecklesBlockState, float speckleChance, class_2680 middleBlockSate, class_2680 outerBlockState) {
        super(spheroidAdvancementIdentifier, random, spheroidDecorators, radius, entityTypesToSpawn);
        this.innerBlockState = innerBlockState;
        this.innerSpecklesBlockState = innerSpecklesBlockState;
        this.speckleChance = speckleChance;
        this.middleBlockSate = middleBlockSate;
        this.outerBlockState = outerBlockState;
    }

    @Override
    public void generate(class_2791 chunk) {
        int chunkX = chunk.method_12004().field_9181;
        int chunkZ = chunk.method_12004().field_9180;
        int x = this.getPosition().method_10263();
        int y = this.getPosition().method_10264();
        int z = this.getPosition().method_10260();
        this.random.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        for (int x2 = Math.max(chunkX * 16, x - this.radius); x2 <= Math.min(chunkX * 16 + 15, x + this.radius); ++x2) {
            for (int y2 = y - this.radius; y2 <= y + this.radius; ++y2) {
                for (int z2 = Math.max(chunkZ * 16, z - this.radius); z2 <= Math.min(chunkZ * 16 + 15, z + this.radius); ++z2) {
                    class_2338 currBlockPos = new class_2338(x2, y2, z2);
                    float d = Math.round(Support.getDistance(x, y, z, x2, y2, z2));
                    if (d < (float)(this.radius - 4)) continue;
                    if (d < (float)(this.radius - 3)) {
                        if (this.random.nextFloat() < this.speckleChance) {
                            chunk.method_12010(currBlockPos, this.innerSpecklesBlockState, false);
                            continue;
                        }
                        chunk.method_12010(currBlockPos, this.innerBlockState, false);
                        continue;
                    }
                    if (d < (float)(this.radius - 2)) {
                        chunk.method_12010(currBlockPos, this.middleBlockSate, false);
                        continue;
                    }
                    if (!(d < (float)(this.radius - 1))) continue;
                    chunk.method_12010(currBlockPos, this.outerBlockState, false);
                }
            }
        }
    }

    @Override
    public String getDescription() {
        return "+++ GeodeSpheroid +++\nPosition: x=" + this.getPosition().method_10263() + " y=" + this.getPosition().method_10264() + " z=" + this.getPosition().method_10260() + "\nRadius: " + this.radius + "\nInnerBlock: " + this.innerBlockState + "\nInnerSpecklesBlock: " + this.innerSpecklesBlockState + "\nSpeckleChance: " + this.speckleChance + "\nMiddleBlock: " + this.middleBlockSate + "\nOuterBlock: " + this.outerBlockState;
    }
}

