/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky.dimension.spheroid.spheroids.unique;

import de.dafuqs.starrysky.Support;
import de.dafuqs.starrysky.advancements.SpheroidAdvancementIdentifier;
import de.dafuqs.starrysky.dimension.SpheroidDecorator;
import de.dafuqs.starrysky.dimension.spheroid.SpheroidEntitySpawnDefinition;
import de.dafuqs.starrysky.dimension.spheroid.spheroids.Spheroid;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.class_1299;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2421;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_39;
import net.minecraft.class_5281;

public class NetherFortressSpheroid
extends Spheroid {
    private final int shellRadius;
    private final ArrayList<class_2338> interiorDecoratorPositions = new ArrayList();
    private final class_2960 NETHER_BRIDGE_CHEST = class_39.field_615;
    private final class_2680 NETHER_BRICKS = class_2246.field_10266.method_9564();
    private final class_2680 AIR = class_2246.field_10124.method_9564();
    private final class_2680 NETHER_WART = class_2246.field_9974.method_9564();
    private final class_2680 SOUL_SAND = class_2246.field_10114.method_9564();
    private final class_2680 NETHER_BRICK_FENCE = class_2246.field_10364.method_9564();
    private final class_2680 LAVA = class_2246.field_10164.method_9564();

    public NetherFortressSpheroid(class_2919 random, SpheroidAdvancementIdentifier spheroidAdvancementIdentifier, int radius, ArrayList<SpheroidDecorator> spheroidDecorators, ArrayList<SpheroidEntitySpawnDefinition> entityTypesToSpawn, int shellRadius) {
        super(spheroidAdvancementIdentifier, random, spheroidDecorators, radius, entityTypesToSpawn);
        this.shellRadius = shellRadius;
    }

    @Override
    public String getDescription() {
        return "+++ NetherFortressSpheroid +++\nPosition: x=" + this.getPosition().method_10263() + " y=" + this.getPosition().method_10264() + " z=" + this.getPosition().method_10260() + "\nRadius: " + this.radius + "\nShellRadius: " + this.shellRadius;
    }

    @Override
    public void generate(class_2791 chunk) {
        int chunkX = chunk.method_12004().field_9181;
        int chunkZ = chunk.method_12004().field_9180;
        int x = this.getPosition().method_10263();
        int y = this.getPosition().method_10264();
        int z = this.getPosition().method_10260();
        int shellDistance = this.radius - this.shellRadius;
        this.random.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        for (int x2 = Math.max(chunkX * 16, x - this.radius); x2 <= Math.min(chunkX * 16 + 15, x + this.radius); ++x2) {
            for (int y2 = y - this.radius; y2 <= y + this.radius; ++y2) {
                for (int z2 = Math.max(chunkZ * 16, z - this.radius); z2 <= Math.min(chunkZ * 16 + 15, z + this.radius); ++z2) {
                    class_2338 currBlockPos = new class_2338(x2, y2, z2);
                    long d = Math.round(Support.getDistance(x, y, z, x2, y2, z2));
                    if (d <= (long)shellDistance) {
                        chunk.method_12010(currBlockPos, this.NETHER_BRICKS, false);
                    }
                    if (d >= (long)(this.getRadius() - 9) || y2 % 10 != (this.position.method_10264() + 9) % 10 || x2 % 10 != this.position.method_10263() % 10 || z2 % 10 != this.position.method_10260() % 10) continue;
                    this.interiorDecoratorPositions.add(currBlockPos);
                }
            }
        }
    }

    @Override
    public void decorate(class_5281 world, Random random, class_2338 origin) {
        block8: for (class_2338 interiorDecoratorPosition : this.interiorDecoratorPositions) {
            if (!Support.inSameChunk(origin, interiorDecoratorPosition)) continue;
            int randomStructure = random.nextInt(7);
            switch (randomStructure) {
                case 0: {
                    this.placeBlazeSpawnerRoom((class_1936)world, interiorDecoratorPosition);
                    continue block8;
                }
                case 1: {
                    this.placeWitherSkeletonRoom((class_1936)world, interiorDecoratorPosition);
                    continue block8;
                }
                case 2: {
                    this.placeNetherWartRoom((class_1936)world, interiorDecoratorPosition);
                    continue block8;
                }
                case 3: {
                    this.placeSolid((class_1936)world, interiorDecoratorPosition);
                    continue block8;
                }
                case 4: {
                    this.placeEmpty((class_1936)world, interiorDecoratorPosition);
                    continue block8;
                }
                case 5: {
                    this.placeLava((class_1936)world, interiorDecoratorPosition);
                    continue block8;
                }
            }
            this.placeChestRoom((class_1936)world, interiorDecoratorPosition);
        }
    }

    private void placeSolid(class_1936 worldAccess, class_2338 blockPos) {
        for (int x2 = -4; x2 < 5; ++x2) {
            for (int y2 = 0; y2 < 9; ++y2) {
                for (int z2 = -4; z2 < 5; ++z2) {
                    class_2338 destinationBlockPos = blockPos.method_10069(x2, y2, z2);
                    worldAccess.method_8652(destinationBlockPos, this.NETHER_BRICKS, 3);
                }
            }
        }
    }

    private void placeEmpty(class_1936 worldAccess, class_2338 blockPos) {
        for (int x2 = -4; x2 < 5; ++x2) {
            for (int y2 = 0; y2 < 9; ++y2) {
                for (int z2 = -4; z2 < 5; ++z2) {
                    class_2338 destinationBlockPos = blockPos.method_10069(x2, y2, z2);
                    worldAccess.method_8652(destinationBlockPos, this.AIR, 3);
                }
            }
        }
    }

    private void placeLava(class_1936 worldAccess, class_2338 blockPos) {
        for (int x2 = -4; x2 < 5; ++x2) {
            for (int y2 = 0; y2 < 9; ++y2) {
                for (int z2 = -4; z2 < 5; ++z2) {
                    class_2338 destinationBlockPos = blockPos.method_10069(x2, y2, z2);
                    worldAccess.method_8652(destinationBlockPos, this.LAVA, 3);
                }
            }
        }
    }

    private void placeChestRoom(class_1936 worldAccess, class_2338 blockPos) {
        for (int x2 = -4; x2 < 5; ++x2) {
            for (int y2 = 0; y2 < 9; ++y2) {
                for (int z2 = -4; z2 < 5; ++z2) {
                    class_2338 destinationBlockPos = blockPos.method_10069(x2, y2, z2);
                    worldAccess.method_8652(destinationBlockPos, this.AIR, 3);
                }
            }
        }
        this.placeCenterChestWithLootTable(worldAccess.method_22350(blockPos), blockPos, this.NETHER_BRIDGE_CHEST, (Random)this.random, false);
    }

    private void placeBlazeSpawnerRoom(class_1936 worldAccess, class_2338 blockPos) {
        for (int x2 = -4; x2 < 5; ++x2) {
            for (int y2 = 0; y2 < 9; ++y2) {
                for (int z2 = -4; z2 < 5; ++z2) {
                    class_2338 destinationBlockPos = blockPos.method_10069(x2, y2, z2);
                    worldAccess.method_8652(destinationBlockPos, this.AIR, 3);
                }
            }
        }
        class_2338 spawnerPos = blockPos.method_10086(4);
        for (int x2 = -1; x2 < 2; ++x2) {
            for (int y2 = -1; y2 < 2; ++y2) {
                for (int z2 = -1; z2 < 2; ++z2) {
                    class_2338 destinationBlockPos = spawnerPos.method_10069(x2, y2, z2);
                    worldAccess.method_8652(destinationBlockPos, this.NETHER_BRICK_FENCE, 3);
                }
            }
        }
        worldAccess.method_8652(spawnerPos.method_10086(2), this.NETHER_BRICK_FENCE, 3);
        worldAccess.method_8652(spawnerPos.method_10086(3), this.NETHER_BRICK_FENCE, 3);
        worldAccess.method_8652(spawnerPos.method_10086(4), this.NETHER_BRICK_FENCE, 3);
        this.placeSpawner(worldAccess, spawnerPos, class_1299.field_6099);
    }

    private void placeWitherSkeletonRoom(class_1936 worldAccess, class_2338 blockPos) {
        for (int x2 = -4; x2 < 5; ++x2) {
            for (int y2 = 0; y2 < 9; ++y2) {
                for (int z2 = -4; z2 < 5; ++z2) {
                    class_2338 destinationBlockPos = blockPos.method_10069(x2, y2, z2);
                    worldAccess.method_8652(destinationBlockPos, this.AIR, 3);
                }
            }
        }
        class_2338 spawnerPos = blockPos.method_10086(4);
        for (int x2 = -1; x2 < 2; ++x2) {
            for (int y2 = -1; y2 < 2; ++y2) {
                for (int z2 = -1; z2 < 2; ++z2) {
                    class_2338 destinationBlockPos = spawnerPos.method_10069(x2, y2, z2);
                    worldAccess.method_8652(destinationBlockPos, this.NETHER_BRICK_FENCE, 3);
                }
            }
        }
        worldAccess.method_8652(spawnerPos.method_10086(2), this.NETHER_BRICK_FENCE, 3);
        worldAccess.method_8652(spawnerPos.method_10086(3), this.NETHER_BRICK_FENCE, 3);
        worldAccess.method_8652(spawnerPos.method_10086(4), this.NETHER_BRICK_FENCE, 3);
        this.placeSpawner(worldAccess, spawnerPos, class_1299.field_6076);
    }

    private void placeNetherWartRoom(class_1936 worldAccess, class_2338 blockPos) {
        int x2;
        for (x2 = -4; x2 < 5; ++x2) {
            for (int y2 = 0; y2 < 9; ++y2) {
                for (int z2 = -4; z2 < 5; ++z2) {
                    class_2338 destinationBlockPos = blockPos.method_10069(x2, y2, z2);
                    worldAccess.method_8652(destinationBlockPos, this.AIR, 3);
                }
            }
        }
        for (x2 = -4; x2 < 5; ++x2) {
            for (int z2 = -4; z2 < 5; ++z2) {
                class_2338 destinationBlockPos = blockPos.method_10069(x2, 0, z2);
                if (Math.abs(x2) < 3 && Math.abs(z2) < 3) {
                    worldAccess.method_8652(destinationBlockPos, this.SOUL_SAND, 3);
                    int randomAge = this.random.nextInt(3);
                    worldAccess.method_8652(destinationBlockPos.method_10084(), (class_2680)this.NETHER_WART.method_11657((class_2769)class_2421.field_11306, (Comparable)Integer.valueOf(randomAge)), 3);
                    continue;
                }
                worldAccess.method_8652(destinationBlockPos, this.NETHER_BRICKS, 3);
            }
        }
    }
}

