/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky.dimension.spheroid.spheroids.unique;

import de.dafuqs.starrysky.StarrySkyCommon;
import de.dafuqs.starrysky.Support;
import de.dafuqs.starrysky.advancements.SpheroidAdvancementIdentifier;
import de.dafuqs.starrysky.dimension.SpheroidDecorator;
import de.dafuqs.starrysky.dimension.spheroid.SpheroidEntitySpawnDefinition;
import de.dafuqs.starrysky.dimension.spheroid.spheroids.Spheroid;
import java.util.ArrayList;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2919;
import net.minecraft.class_3233;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5425;
import org.apache.logging.log4j.Level;

public class OceanMonumentSpheroid
extends Spheroid {
    private final class_2680 water = class_2246.field_10382.method_9564();
    private final class_2680 prismarine = class_2246.field_10135.method_9564();
    private final class_2680 prismarine_bricks = class_2246.field_10006.method_9564();
    private final class_2680 dark_prismarine = class_2246.field_10297.method_9564();
    private final class_2680 sea_lantern = class_2246.field_10174.method_9564();
    private final class_2680 treasure = class_2246.field_10562.method_9564();
    private final int treasureRadius;
    private final int shellRadius;
    private final ArrayList<class_2338> guardianPositions = new ArrayList();

    public OceanMonumentSpheroid(class_2919 random, SpheroidAdvancementIdentifier spheroidAdvancementIdentifier, int radius, ArrayList<SpheroidDecorator> spheroidDecorators, ArrayList<SpheroidEntitySpawnDefinition> entityTypesToSpawn, int treasureRadius, int shellRadius) {
        super(spheroidAdvancementIdentifier, random, spheroidDecorators, radius, entityTypesToSpawn);
        this.treasureRadius = treasureRadius;
        this.shellRadius = shellRadius;
    }

    @Override
    public String getDescription() {
        return "+++ OceanMonumentSpheroid +++\nPosition: x=" + this.getPosition().method_10263() + " y=" + this.getPosition().method_10264() + " z=" + this.getPosition().method_10260() + "\nRadius: " + this.radius + "\nTreasure: " + this.treasure.toString() + " (Radius: " + this.treasureRadius + ")";
    }

    @Override
    public void generate(class_2791 chunk) {
        int chunkX = chunk.method_12004().field_9181;
        int chunkZ = chunk.method_12004().field_9180;
        int x = this.getPosition().method_10263();
        int y = this.getPosition().method_10264();
        int z = this.getPosition().method_10260();
        int shellDistance = this.radius - this.shellRadius;
        this.random.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        for (int x2 = Math.max(chunkX * 16, x - this.radius); x2 <= Math.min(chunkX * 16 + 15, x + this.radius); ++x2) {
            for (int y2 = y - this.radius; y2 <= y + this.radius; ++y2) {
                for (int z2 = Math.max(chunkZ * 16, z - this.radius); z2 <= Math.min(chunkZ * 16 + 15, z + this.radius); ++z2) {
                    class_2338 currBlockPos = new class_2338(x2, y2, z2);
                    long d = Math.round(Support.getDistance(x, y, z, x2, y2, z2));
                    if (d <= (long)this.treasureRadius) {
                        chunk.method_12010(currBlockPos, this.treasure, false);
                        continue;
                    }
                    if (d < (long)(this.treasureRadius + 3)) {
                        chunk.method_12010(currBlockPos, this.water, false);
                        continue;
                    }
                    if (d == (long)(this.treasureRadius + 3)) {
                        if (Math.abs(x2 - x) < 2 || Math.abs(z2 - z) < 2) {
                            chunk.method_12010(currBlockPos, this.water, false);
                            continue;
                        }
                        chunk.method_12010(currBlockPos, this.dark_prismarine, false);
                        continue;
                    }
                    if (d <= (long)shellDistance) {
                        if (y2 % 10 == 0 || x2 % 10 == 0 || z2 % 10 == 0) {
                            if ((y2 - y) % 6 == 0 && ((x2 - x) % 4 == 2 || (z2 - z) % 4 == 0)) {
                                chunk.method_12010(currBlockPos, this.sea_lantern, false);
                                continue;
                            }
                            chunk.method_12010(currBlockPos, this.prismarine_bricks, false);
                            continue;
                        }
                        if (y2 % 10 == 5 && x2 % 10 == 5 && z2 % 10 == 5) {
                            this.guardianPositions.add(currBlockPos);
                        }
                        chunk.method_12010(currBlockPos, this.water, false);
                        continue;
                    }
                    if (d > (long)this.radius) continue;
                    if (y2 % 2 == 0) {
                        chunk.method_12010(currBlockPos, this.prismarine, false);
                        continue;
                    }
                    chunk.method_12010(currBlockPos, this.prismarine_bricks, false);
                }
            }
        }
    }

    @Override
    public boolean shouldPopulateEntities(class_1923 chunkPos) {
        return this.isInChunk(chunkPos);
    }

    @Override
    public void populateEntities(class_1923 chunkPos, class_3233 chunkRegion, class_2919 chunkRandom) {
        if (this.isCenterInChunk(chunkPos)) {
            for (class_2338 guardianPosition : this.guardianPositions) {
                if (!Support.isBlockPosInChunkPos(chunkPos, guardianPosition)) continue;
                int xCord = chunkPos.field_9181;
                int zCord = chunkPos.field_9180;
                class_2919 sharedSeedRandom = new class_2919();
                sharedSeedRandom.method_12661(chunkRegion.method_8412(), xCord, zCord);
                class_1308 mobentity = (double)this.random.nextFloat() < 0.08 ? (class_1308)class_1299.field_6086.method_5883((class_1937)chunkRegion.method_8410()) : (class_1308)class_1299.field_6118.method_5883((class_1937)chunkRegion.method_8410());
                if (mobentity == null) continue;
                float width = mobentity.method_17681();
                double xLength = class_3532.method_15350((double)guardianPosition.method_10263(), (double)((double)chunkPos.method_8326() + (double)width), (double)((double)chunkPos.method_8326() + 16.0 - (double)width));
                double zLength = class_3532.method_15350((double)guardianPosition.method_10260(), (double)((double)chunkPos.method_8328() + (double)width), (double)((double)chunkPos.method_8328() + 16.0 - (double)width));
                try {
                    mobentity.method_5808(xLength, (double)guardianPosition.method_10264(), zLength, sharedSeedRandom.nextFloat() * 360.0f, 0.0f);
                    mobentity.method_5971();
                    if (!mobentity.method_5979((class_1936)chunkRegion, class_3730.field_16472) || !mobentity.method_5957((class_4538)chunkRegion)) continue;
                    mobentity.method_5943((class_5425)chunkRegion, chunkRegion.method_8404(new class_2338(mobentity.method_19538())), class_3730.field_16472, null, null);
                    boolean success = chunkRegion.method_8649((class_1297)mobentity);
                    if (success) continue;
                    return;
                }
                catch (Exception exception) {
                    StarrySkyCommon.log(Level.WARN, "Failed to spawn mob on sphere" + this.getDescription() + "\nException: " + exception);
                }
            }
        }
    }
}

