/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky.dimension.spheroid.spheroids.unique;

import de.dafuqs.starrysky.StarrySkyCommon;
import de.dafuqs.starrysky.Support;
import de.dafuqs.starrysky.advancements.SpheroidAdvancementIdentifier;
import de.dafuqs.starrysky.dimension.SpheroidDecorator;
import de.dafuqs.starrysky.dimension.spheroid.SpheroidEntitySpawnDefinition;
import de.dafuqs.starrysky.dimension.spheroid.spheroids.Spheroid;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.class_1299;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2333;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2389;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_39;
import net.minecraft.class_5281;
import org.apache.logging.log4j.Level;

public class StrongholdSpheroid
extends Spheroid {
    private final class_2680 STONE_BRICKS = class_2246.field_10056.method_9564();
    private final class_2680 INFESTED_STONE_BRICKS = class_2246.field_10387.method_9564();
    private final class_2680 MOSSY_STONE_BRICKS = class_2246.field_10065.method_9564();
    private final class_2680 OAK_PLANKS = class_2246.field_10161.method_9564();
    private final class_2680 END_PORTAL_FRAME = class_2246.field_10398.method_9564();
    private final class_2680 SPAWNER = class_2246.field_10260.method_9564();
    private final class_2680 LAVA = class_2246.field_10164.method_9564();
    private final class_2680 IRON_BARS = class_2246.field_10576.method_9564();
    private final class_2680 BOOKSHELF = class_2246.field_10504.method_9564();
    private final class_2680 AIR = class_2246.field_10124.method_9564();
    private final class_2960 CORRIDOR_CHEST = class_39.field_842;
    private final class_2960 CROSSING_CHEST = class_39.field_800;
    private final class_2960 LIBRARY_CHEST = class_39.field_683;
    private final int shellRadius;
    private class_2338 portalPosition;
    private final ArrayList<class_2338> interiorDecoratorPositions = new ArrayList();

    public StrongholdSpheroid(class_2919 random, SpheroidAdvancementIdentifier spheroidAdvancementIdentifier, int radius, ArrayList<SpheroidDecorator> spheroidDecorators, ArrayList<SpheroidEntitySpawnDefinition> entityTypesToSpawn, int shellRadius) {
        super(spheroidAdvancementIdentifier, random, spheroidDecorators, radius, entityTypesToSpawn);
        this.shellRadius = shellRadius;
    }

    @Override
    public String getDescription() {
        return "+++ StrongholdSpheroid +++\nPosition: x=" + this.getPosition().method_10263() + " y=" + this.getPosition().method_10264() + " z=" + this.getPosition().method_10260() + "\nRadius: " + this.radius + "\nShellRadius: " + this.shellRadius;
    }

    @Override
    public void generate(class_2791 chunk) {
        int chunkX = chunk.method_12004().field_9181;
        int chunkZ = chunk.method_12004().field_9180;
        int x = this.getPosition().method_10263();
        int y = this.getPosition().method_10264();
        int z = this.getPosition().method_10260();
        int shellDistance = this.radius - this.shellRadius;
        this.random.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        for (int x2 = Math.max(chunkX * 16, x - this.radius); x2 <= Math.min(chunkX * 16 + 15, x + this.radius); ++x2) {
            for (int y2 = y - this.radius; y2 <= y + this.radius; ++y2) {
                for (int z2 = Math.max(chunkZ * 16, z - this.radius); z2 <= Math.min(chunkZ * 16 + 15, z + this.radius); ++z2) {
                    class_2338 currBlockPos = new class_2338(x2, y2, z2);
                    long d = Math.round(Support.getDistance(x, y, z, x2, y2, z2));
                    if (d <= (long)shellDistance) {
                        if (y2 % 10 == (this.position.method_10264() + 8) % 10 || x2 % 10 == (this.position.method_10263() + 5) % 10 || z2 % 10 == (this.position.method_10260() + 5) % 10) {
                            if ((y2 - y) % 6 == 0 && ((x2 - x) % 4 == 2 || (z2 - z) % 4 == 0)) {
                                chunk.method_12010(currBlockPos, this.MOSSY_STONE_BRICKS, false);
                            } else {
                                chunk.method_12010(currBlockPos, this.STONE_BRICKS, false);
                            }
                        }
                    } else if (d <= (long)this.radius) {
                        if (y2 % 2 == 0) {
                            if (x2 % 5 == 0) {
                                chunk.method_12010(currBlockPos, this.INFESTED_STONE_BRICKS, false);
                            } else {
                                chunk.method_12010(currBlockPos, this.STONE_BRICKS, false);
                            }
                        } else if (x2 % 2 == 0 && z2 % 2 == 0) {
                            chunk.method_12010(currBlockPos, this.MOSSY_STONE_BRICKS, false);
                        } else {
                            chunk.method_12010(currBlockPos, this.STONE_BRICKS, false);
                        }
                    }
                    if (d >= (long)(this.getRadius() - 9) || y2 % 10 != (this.position.method_10264() + 9) % 10 || x2 % 10 != this.position.method_10263() % 10 || z2 % 10 != this.position.method_10260() % 10) continue;
                    if (d == 1L) {
                        this.portalPosition = currBlockPos;
                        continue;
                    }
                    this.interiorDecoratorPositions.add(currBlockPos);
                }
            }
        }
    }

    @Override
    public void decorate(class_5281 world, Random random, class_2338 origin) {
        if (this.portalPosition != null) {
            if (Support.inSameChunk(origin, this.portalPosition)) {
                this.placeEndPortal((class_1936)world, this.portalPosition.method_10084());
            }
        } else {
            StarrySkyCommon.log(Level.WARN, "Generating a Stronghold Spheroid at " + this.position.method_10263() + " " + this.position.method_10264() + " " + this.position.method_10260() + " without an end portal?");
        }
        block6: for (class_2338 interiorDecoratorPosition : this.interiorDecoratorPositions) {
            if (!Support.inSameChunk(origin, interiorDecoratorPosition)) continue;
            int randomStructure = random.nextInt(5);
            switch (randomStructure) {
                case 0: {
                    this.placeLibrary((class_1936)world, interiorDecoratorPosition);
                    continue block6;
                }
                case 1: {
                    this.placeCorridor((class_1936)world, interiorDecoratorPosition);
                    continue block6;
                }
                case 2: {
                    this.placeCrossing((class_1936)world, interiorDecoratorPosition);
                    continue block6;
                }
                case 3: {
                    this.placePrison((class_1936)world, interiorDecoratorPosition);
                    continue block6;
                }
            }
            this.placeFullCube((class_1936)world, interiorDecoratorPosition);
        }
    }

    private void placeEndPortal(class_1936 worldAccess, class_2338 blockPos) {
        for (int x2 = -3; x2 <= 3; ++x2) {
            for (int z2 = -3; z2 <= 3; ++z2) {
                class_2338 destinationBlockPos = blockPos.method_10069(x2, 0, z2);
                if (Math.abs(x2) == 3 || Math.abs(z2) == 3) {
                    if (Math.abs(x2) == 3 && Math.abs(z2) == 3) continue;
                    worldAccess.method_8652(destinationBlockPos.method_10074(), this.STONE_BRICKS, 3);
                    continue;
                }
                if (Math.abs(x2) != 2 || Math.abs(z2) != 2) {
                    if (Math.abs(x2) == 2 || Math.abs(z2) == 2) {
                        class_2350 direction = x2 == -2 ? class_2350.field_11034 : (x2 == 2 ? class_2350.field_11039 : (z2 == -2 ? class_2350.field_11035 : class_2350.field_11043));
                        if (this.random.nextBoolean()) {
                            worldAccess.method_8652(destinationBlockPos, (class_2680)this.END_PORTAL_FRAME.method_11657((class_2769)class_2333.field_10954, (Comparable)direction), 3);
                        } else {
                            worldAccess.method_8652(destinationBlockPos, (class_2680)((class_2680)this.END_PORTAL_FRAME.method_11657((class_2769)class_2333.field_10954, (Comparable)direction)).method_11657((class_2769)class_2333.field_10958, (Comparable)Boolean.valueOf(true)), 3);
                        }
                        worldAccess.method_8652(destinationBlockPos.method_10074(), this.STONE_BRICKS, 3);
                        worldAccess.method_8652(destinationBlockPos.method_10087(2), this.STONE_BRICKS, 3);
                    } else {
                        worldAccess.method_8652(destinationBlockPos, this.AIR, 3);
                        worldAccess.method_8652(destinationBlockPos.method_10074(), this.AIR, 3);
                        worldAccess.method_8652(destinationBlockPos.method_10087(2), this.LAVA, 3);
                        worldAccess.method_8652(destinationBlockPos.method_10087(3), this.STONE_BRICKS, 3);
                    }
                    worldAccess.method_8652(destinationBlockPos.method_10084(), this.AIR, 3);
                    worldAccess.method_8652(destinationBlockPos.method_10086(2), this.AIR, 3);
                    worldAccess.method_8652(destinationBlockPos.method_10086(3), this.AIR, 3);
                    continue;
                }
                this.placeSpawner(worldAccess, destinationBlockPos.method_10087(2), class_1299.field_6125);
            }
        }
    }

    private void placeFullCube(class_1936 worldAccess, class_2338 blockPos) {
        for (int x2 = -4; x2 < 5; ++x2) {
            for (int y2 = 0; y2 < 9; ++y2) {
                for (int z2 = -4; z2 < 5; ++z2) {
                    class_2338 destinationBlockPos = blockPos.method_10069(x2, y2, z2);
                    worldAccess.method_8652(destinationBlockPos, this.INFESTED_STONE_BRICKS, 3);
                }
            }
        }
    }

    private void placeLibrary(class_1936 worldAccess, class_2338 blockPos) {
        for (int x2 = -4; x2 < 5; ++x2) {
            for (int y2 = 0; y2 < 4; ++y2) {
                for (int z2 = -4; z2 < 5; ++z2) {
                    if (Math.abs(x2) != 4 && Math.abs(z2) != 4 && (Math.abs(x2 % 2) != 1 || Math.abs(z2 % 2) != 1)) continue;
                    class_2338 destinationBlockPos = blockPos.method_10069(x2, y2, z2);
                    if (y2 == 3) {
                        worldAccess.method_8652(destinationBlockPos, this.OAK_PLANKS, 3);
                        continue;
                    }
                    worldAccess.method_8652(destinationBlockPos, this.BOOKSHELF, 3);
                }
            }
        }
        this.placeCenterChestWithLootTable(worldAccess.method_22350(blockPos), blockPos, this.LIBRARY_CHEST, (Random)this.random, false);
    }

    private void placePrison(class_1936 worldAccess, class_2338 blockPos) {
        int y2;
        class_2338 destinationBlockPos;
        for (int x2 = -4; x2 < 5; ++x2) {
            for (int y22 = 0; y22 < 9; ++y22) {
                destinationBlockPos = blockPos.method_10069(x2, y22, 0);
                worldAccess.method_8652(destinationBlockPos, (class_2680)((class_2680)this.IRON_BARS.method_11657((class_2769)class_2389.field_10907, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2389.field_10903, (Comparable)Boolean.valueOf(true)), 3);
            }
        }
        for (y2 = 0; y2 < 9; ++y2) {
            for (int z2 = -4; z2 < 5; ++z2) {
                destinationBlockPos = blockPos.method_10069(0, y2, z2);
                worldAccess.method_8652(destinationBlockPos, (class_2680)((class_2680)this.IRON_BARS.method_11657((class_2769)class_2389.field_10905, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2389.field_10904, (Comparable)Boolean.valueOf(true)), 3);
            }
        }
        for (y2 = 0; y2 < 9; ++y2) {
            class_2338 destinationBlockPos2 = blockPos.method_10069(0, y2, 0);
            worldAccess.method_8652(destinationBlockPos2, (class_2680)((class_2680)((class_2680)((class_2680)this.IRON_BARS.method_11657((class_2769)class_2389.field_10907, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2389.field_10903, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2389.field_10905, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2389.field_10904, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    private void placeCrossing(class_1936 worldAccess, class_2338 blockPos) {
        for (int x2 = -1; x2 < 2; ++x2) {
            for (int y2 = 0; y2 < 3; ++y2) {
                for (int z2 = -1; z2 < 2; ++z2) {
                    class_2338 destinationBlockPos = blockPos.method_10069(x2, y2, z2);
                    worldAccess.method_8652(destinationBlockPos, this.MOSSY_STONE_BRICKS, 3);
                }
            }
        }
        this.placeCenterChestWithLootTable(worldAccess.method_22350(blockPos), blockPos, this.CROSSING_CHEST, (Random)this.random, false);
    }

    private void placeCorridor(class_1936 worldAccess, class_2338 blockPos) {
        for (int x2 = -1; x2 < 2; ++x2) {
            for (int y2 = 0; y2 < 9; ++y2) {
                for (int z2 = -1; z2 < 2; ++z2) {
                    class_2338 destinationBlockPos = blockPos.method_10069(x2, y2, z2);
                    class_2680 blockState = y2 == 0 || Math.abs(x2) == 1 && Math.abs(z2) == 1 ? this.STONE_BRICKS : (y2 < 4 ? (x2 == -1 || x2 == 1 ? (class_2680)((class_2680)this.IRON_BARS.method_11657((class_2769)class_2389.field_10904, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2389.field_10905, (Comparable)Boolean.valueOf(true)) : (z2 == -1 || z2 == 1 ? (class_2680)((class_2680)this.IRON_BARS.method_11657((class_2769)class_2389.field_10903, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2389.field_10907, (Comparable)Boolean.valueOf(true)) : this.AIR)) : this.STONE_BRICKS);
                    worldAccess.method_8652(destinationBlockPos, blockState, 3);
                }
            }
        }
        this.placeCenterChestWithLootTable(worldAccess.method_22350(blockPos), blockPos.method_10084(), this.CORRIDOR_CHEST, (Random)this.random, false);
    }
}

