/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky.dimension.spheroid.types;

import de.dafuqs.starrysky.StarrySkyCommon;
import de.dafuqs.starrysky.Support;
import de.dafuqs.starrysky.advancements.SpheroidAdvancementIdentifier;
import de.dafuqs.starrysky.dimension.SpheroidDecorator;
import de.dafuqs.starrysky.dimension.spheroid.SpheroidEntitySpawnDefinition;
import de.dafuqs.starrysky.dimension.spheroid.spheroids.CoralSpheroid;
import de.dafuqs.starrysky.dimension.spheroid.types.SpheroidType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Random;
import net.minecraft.class_2680;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import org.apache.logging.log4j.Level;

public class CoralSpheroidType
extends SpheroidType {
    private final LinkedHashMap<class_2680, Float> validShellBlocks;
    private final int minShellRadius;
    private final int maxShellRadius;
    private class_2960 lootTable;
    float lootTableChance;

    public CoralSpheroidType(SpheroidAdvancementIdentifier spheroidAdvancementIdentifier, int minRadius, int maxRadius, LinkedHashMap<class_2680, Float> validShellBlocks, int minShellRadius, int maxShellRadius) {
        super(spheroidAdvancementIdentifier, minRadius, maxRadius);
        if (validShellBlocks == null || validShellBlocks.size() == 0) {
            StarrySkyCommon.log(Level.ERROR, "CoralSpheroidType: Registered a SpheroidType with empty validShellBlocks!");
        }
        this.validShellBlocks = validShellBlocks;
        this.minShellRadius = minShellRadius;
        this.maxShellRadius = maxShellRadius;
    }

    public CoralSpheroidType addChestWithLootTable(class_2960 lootTable, float chance) {
        this.lootTable = lootTable;
        this.lootTableChance = chance;
        return this;
    }

    @Override
    public String getDescription() {
        return "CoralSpheroid";
    }

    @Override
    public CoralSpheroid getRandomSpheroid(class_2919 chunkRandom) {
        int radius = this.getRandomRadius(chunkRandom);
        int shellRadius = Support.getRandomBetween((Random)chunkRandom, this.minShellRadius, this.maxShellRadius);
        ArrayList<SpheroidDecorator> spheroidDecorators = this.getSpheroidDecoratorsWithChance(chunkRandom);
        ArrayList<SpheroidEntitySpawnDefinition> entityTypesToSpawn = this.getRandomEntityTypesToSpawn(chunkRandom);
        class_2680 shellBlockState = Support.getWeightedRandom(this.validShellBlocks, (Random)chunkRandom);
        class_2960 lootTable = null;
        if (chunkRandom.nextFloat() < this.lootTableChance) {
            lootTable = this.lootTable;
        }
        return new CoralSpheroid(chunkRandom, this.spheroidAdvancementIdentifier, radius, spheroidDecorators, entityTypesToSpawn, shellBlockState, shellRadius, lootTable);
    }
}

