/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.structures;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3111;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3485;
import net.minecraft.class_3778;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_3812;
import net.minecraft.class_4183;
import net.minecraft.class_5314;
import net.minecraft.class_5455;

public class TGBaseStructure
extends class_3195<class_3111> {
    private final int SUNKEN_IN;
    private final double SIZE;
    private final String NAME;
    private int averageHeight;
    private final int MAX_WATER_HITS = 8;
    private final int MAX_TERRAIN_DIFFERENCE_BASE = 2;
    private final int MAX_TERRAIN_DIFFERENCE_LG = 5;
    private final int OFFSET_WATER_CHECK_LG = 25;

    public TGBaseStructure(Codec<class_3111> codec, String name, double size, int sunkenIn) {
        super(codec);
        this.SUNKEN_IN = sunkenIn;
        this.SIZE = size;
        this.NAME = name;
    }

    public class_3195.class_3774<class_3111> method_14016() {
        return Start::new;
    }

    protected boolean shouldStartAt(class_2794 chunkGenerator, class_1966 biomeSource, long seed, class_2919 chunkRandom, int chunkX, int chunkZ, class_1959 biome, class_1923 chunkPos, class_3111 featureConfig) {
        class_2338 centerOfChunk = new class_2338(chunkPos.field_9181 * 16, 0, chunkPos.field_9180 * 16);
        if (!this.isTerrainFlat(chunkGenerator, centerOfChunk.method_10263(), centerOfChunk.method_10260())) {
            return false;
        }
        if (!this.isWater(chunkGenerator, centerOfChunk.method_10263(), centerOfChunk.method_10260(), centerOfChunk)) {
            return false;
        }
        return this.checkForOtherStructures(chunkGenerator, seed, chunkRandom, centerOfChunk.method_10263(), centerOfChunk.method_10260());
    }

    protected boolean isWater(class_2794 generator, int chunkX, int chunkZ, class_2338 centerOfChunk) {
        int offset = (int)this.SIZE * 8;
        if (this.SIZE > 2.0) {
            offset += 25;
            Set biomesInAreaOne = generator.method_12098().method_8763(chunkX, 0, chunkZ, 156);
            Set biomesInAreaTwo = generator.method_12098().method_8763(chunkX, 0, chunkZ, 28);
            for (class_1959 biome : biomesInAreaOne) {
                if (biome.method_8688() != class_1959.class_1961.field_9367) continue;
                return false;
            }
            for (class_1959 biome : biomesInAreaTwo) {
                if (biome.method_8688() != class_1959.class_1961.field_9369) continue;
                return false;
            }
        }
        int i1 = generator.method_18028(chunkX, chunkZ, class_2902.class_2903.field_13194);
        int j1 = generator.method_18028(chunkX, chunkZ + offset, class_2902.class_2903.field_13194);
        int k1 = generator.method_18028(chunkX + offset, chunkZ, class_2902.class_2903.field_13194);
        int l1 = generator.method_18028(chunkX + offset, chunkZ + offset, class_2902.class_2903.field_13194);
        int m1 = generator.method_18028(chunkX - offset, chunkZ + offset, class_2902.class_2903.field_13194);
        int n1 = generator.method_18028(chunkX + offset, chunkZ - offset, class_2902.class_2903.field_13194);
        int o1 = generator.method_18028(chunkX, chunkZ - offset, class_2902.class_2903.field_13194);
        int p1 = generator.method_18028(chunkX - offset, chunkZ, class_2902.class_2903.field_13194);
        int q1 = generator.method_18028(chunkX - offset, chunkZ - offset, class_2902.class_2903.field_13194);
        class_1922 vi1 = generator.method_26261(chunkX, chunkZ);
        class_1922 vj1 = generator.method_26261(chunkX, chunkZ + offset);
        class_1922 vk1 = generator.method_26261(chunkX + offset, chunkZ);
        class_1922 vl1 = generator.method_26261(chunkX + offset, chunkZ + offset);
        class_1922 vm1 = generator.method_26261(chunkX - offset, chunkZ + offset);
        class_1922 vn1 = generator.method_26261(chunkX + offset, chunkZ - offset);
        class_1922 vo1 = generator.method_26261(chunkX, chunkZ - offset);
        class_1922 vp1 = generator.method_26261(chunkX - offset, chunkZ);
        class_1922 vq1 = generator.method_26261(chunkX - offset, chunkZ - offset);
        class_2680 bi1 = vi1.method_8320(centerOfChunk.method_10086(i1));
        class_2680 bj1 = vj1.method_8320(centerOfChunk.method_10086(j1));
        class_2680 bk1 = vk1.method_8320(centerOfChunk.method_10086(k1));
        class_2680 bl1 = vl1.method_8320(centerOfChunk.method_10086(l1));
        class_2680 bm1 = vm1.method_8320(centerOfChunk.method_10086(m1));
        class_2680 bn1 = vn1.method_8320(centerOfChunk.method_10086(n1));
        class_2680 bo1 = vo1.method_8320(centerOfChunk.method_10086(o1));
        class_2680 bp1 = vp1.method_8320(centerOfChunk.method_10086(p1));
        class_2680 bq1 = vq1.method_8320(centerOfChunk.method_10086(q1));
        return this.countWaterMatches(bi1, bj1, bk1, bl1, bm1, bn1, bo1, bq1, bp1);
    }

    private boolean countWaterMatches(class_2680 ... blockStates) {
        int count = 0;
        for (class_2680 blockState : blockStates) {
            count += blockState.method_26227().method_15769() ? 1 : 0;
        }
        return count >= 8;
    }

    protected boolean isTerrainFlat(class_2794 generator, int chunkX, int chunkZ) {
        int offset = (int)this.SIZE * 8;
        int i1 = generator.method_16397(chunkX, chunkZ, class_2902.class_2903.field_13194);
        int j1 = generator.method_16397(chunkX, chunkZ + offset, class_2902.class_2903.field_13194);
        int k1 = generator.method_16397(chunkX + offset, chunkZ, class_2902.class_2903.field_13194);
        int l1 = generator.method_16397(chunkX + offset, chunkZ + offset, class_2902.class_2903.field_13194);
        int m1 = generator.method_16397(chunkX - offset, chunkZ + offset, class_2902.class_2903.field_13194);
        int n1 = generator.method_16397(chunkX + offset, chunkZ - offset, class_2902.class_2903.field_13194);
        int o1 = generator.method_16397(chunkX, chunkZ - offset, class_2902.class_2903.field_13194);
        int p1 = generator.method_16397(chunkX - offset, chunkZ, class_2902.class_2903.field_13194);
        int q1 = generator.method_16397(chunkX - offset, chunkZ - offset, class_2902.class_2903.field_13194);
        int minCorners = Math.min(Math.min(n1, m1), Math.min(q1, l1));
        int minSides = Math.min(Math.min(j1, p1), Math.min(o1, k1));
        int minHeight = Math.min(Math.min(minCorners, minSides), i1);
        int maxCorners = Math.max(Math.max(n1, m1), Math.max(q1, l1));
        int maxSides = Math.max(Math.max(j1, p1), Math.max(o1, k1));
        int maxHeight = Math.max(Math.max(maxCorners, maxSides), i1);
        this.averageHeight = Math.abs((maxHeight + minHeight) / 2);
        if (this.SIZE > 2.0) {
            return Math.abs(maxHeight - minHeight) <= 5;
        }
        return Math.abs(maxHeight - minHeight) <= 2;
    }

    public boolean checkForOtherStructures(class_2794 generator, long seed, class_2919 rand, int chunkX, int chunkZ) {
        class_5314 structureConfig = generator.method_12109().method_28600(class_3195.field_24858);
        if (structureConfig == null) {
            return false;
        }
        if (this.SIZE <= 2.0) {
            return true;
        }
        int blocksAwayToCheck = 15;
        for (int k = chunkX - blocksAwayToCheck; k <= chunkX + blocksAwayToCheck; ++k) {
            for (int l = chunkZ - blocksAwayToCheck; l <= chunkZ + blocksAwayToCheck; ++l) {
                class_1923 chunkPos = class_3195.field_24858.method_27218(structureConfig, seed, rand, k, l);
                if (k != chunkPos.field_9181 || l != chunkPos.field_9180) continue;
                return false;
            }
        }
        return true;
    }

    private int getSunkenIn() {
        return this.SUNKEN_IN;
    }

    private double getSize() {
        return this.SIZE;
    }

    private String getStructureName() {
        return this.NAME;
    }

    private int getAverageHeight() {
        return this.averageHeight;
    }

    public static class Start
    extends class_4183<class_3111> {
        private final int SUNKEN_IN;
        private final double SIZE;
        private final String NAME;
        private int averageHeight;

        public Start(class_3195<class_3111> structureIn, int chunkX, int chunkZ, class_3341 blockBox, int referenceIn, long seedIn, String name, double size, int sunkenIn, int averageHeight) {
            super(structureIn, chunkX, chunkZ, blockBox, referenceIn, seedIn);
            this.SIZE = size;
            this.SUNKEN_IN = sunkenIn;
            this.NAME = name;
            this.averageHeight = averageHeight;
        }

        public Start(class_3195<class_3111> structureIn, int chunkX, int chunkZ, class_3341 blockBox, int referenceIn, long seed) {
            this(structureIn, chunkX, chunkZ, blockBox, referenceIn, seed, ((TGBaseStructure)structureIn).getStructureName(), ((TGBaseStructure)structureIn).getSize(), ((TGBaseStructure)structureIn).getSunkenIn(), ((TGBaseStructure)structureIn).getAverageHeight());
        }

        public void init(class_5455 dynamicRegistryManager, class_2794 chunkGenerator, class_3485 structureManager, int chunkX, int chunkZ, class_1959 biome, class_3111 defaultFeatureConfig) {
            int x = chunkX * 16;
            int z = chunkZ * 16;
            class_2338.class_2339 centerPos = new class_2338.class_2339(x, this.averageHeight, z);
            class_3778.method_30419((class_5455)dynamicRegistryManager, (class_3812)new class_3812(() -> (class_3785)dynamicRegistryManager.method_30530(class_2378.field_25917).method_10223(new class_2960("graveyard", this.NAME + "/start_pool")), 10), class_3790::new, (class_2794)chunkGenerator, (class_3485)structureManager, (class_2338)centerPos, (List)this.field_15325, (Random)this.field_16715, (boolean)false, (boolean)false);
            this.field_15325.forEach(piece -> piece.method_14922(0, 1, 0));
            this.field_15325.forEach(piece -> piece.method_14935().method_14661(0, this.SUNKEN_IN, 0));
            class_2382 structureCenter = ((class_3443)this.field_15325.get(0)).method_14935().method_22874();
            int xOffset = centerPos.method_10263() - structureCenter.method_10263();
            int zOffset = centerPos.method_10260() - structureCenter.method_10260();
            for (class_3443 structurePiece : this.field_15325) {
                structurePiece.method_14922(xOffset, 0, zOffset);
            }
            this.method_14969();
        }
    }
}

