/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.blockentities;

import com.finallion.graveyard.init.TGBlocks;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.UUID;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

public class GravestoneBlockEntity
extends class_2586 {
    private static final String[] TEXT_KEYS = new String[]{"Text1", "Text2", "Text3", "Text4"};
    private static final String[] FILTERED_TEXT_KEYS = new String[]{"FilteredText1", "FilteredText2", "FilteredText3", "FilteredText4"};
    private final class_2561[] texts = new class_2561[]{class_2585.field_24366, class_2585.field_24366, class_2585.field_24366, class_2585.field_24366};
    private final class_2561[] filteredTexts = new class_2561[]{class_2585.field_24366, class_2585.field_24366, class_2585.field_24366, class_2585.field_24366};
    private boolean editable = true;
    @Nullable
    private UUID editor;
    @Nullable
    private class_5481[] textsBeingEdited = null;
    private boolean filterText;
    private class_1767 textColor = class_1767.field_7963;
    private boolean glowingText = false;

    public GravestoneBlockEntity(class_2338 pos, class_2680 state) {
        super(TGBlocks.GRAVESTONE_BLOCK_ENTITY, pos, state);
    }

    public class_2487 method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        for (int i = 0; i < 4; ++i) {
            class_2561 text = this.texts[i];
            String string = class_2561.class_2562.method_10867((class_2561)text);
            nbt.method_10582(TEXT_KEYS[i], string);
            class_2561 text2 = this.filteredTexts[i];
            if (text2.equals(text)) continue;
            nbt.method_10582(FILTERED_TEXT_KEYS[i], class_2561.class_2562.method_10867((class_2561)text2));
        }
        nbt.method_10582("Color", this.textColor.method_7792());
        nbt.method_10556("GlowingText", this.glowingText);
        return nbt;
    }

    public void method_11014(class_2487 nbt) {
        this.editable = false;
        super.method_11014(nbt);
        this.textColor = class_1767.method_7793((String)nbt.method_10558("Color"), (class_1767)class_1767.field_7963);
        for (int i = 0; i < 4; ++i) {
            class_2561 text;
            String string = nbt.method_10558(TEXT_KEYS[i]);
            this.texts[i] = text = this.parseTextFromJson(string);
            String string2 = FILTERED_TEXT_KEYS[i];
            this.filteredTexts[i] = nbt.method_10573(string2, 8) ? this.parseTextFromJson(nbt.method_10558(string2)) : text;
        }
        this.textsBeingEdited = null;
        this.glowingText = nbt.method_10577("GlowingText");
    }

    private class_2561 parseTextFromJson(String json) {
        class_2561 text = this.unparsedTextFromJson(json);
        if (this.field_11863 instanceof class_3218) {
            try {
                return class_2564.method_10881((class_2168)this.getCommandSource(null), (class_2561)text, (class_1297)null, (int)0);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        return text;
    }

    private class_2561 unparsedTextFromJson(String json) {
        try {
            class_5250 text = class_2561.class_2562.method_10877((String)json);
            if (text != null) {
                return text;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return class_2585.field_24366;
    }

    public class_2561 getTextOnRow(int row, boolean filtered) {
        return this.getTexts(filtered)[row];
    }

    public void setTextOnRow(int row, class_2561 text) {
        this.setTextOnRow(row, text, text);
    }

    public void setTextOnRow(int row, class_2561 text, class_2561 filteredText) {
        this.texts[row] = text;
        this.filteredTexts[row] = filteredText;
        this.textsBeingEdited = null;
    }

    public class_5481[] updateSign(boolean filterText, Function<class_2561, class_5481> textOrderingFunction) {
        if (this.textsBeingEdited == null || this.filterText != filterText) {
            this.filterText = filterText;
            this.textsBeingEdited = new class_5481[4];
            for (int i = 0; i < 4; ++i) {
                this.textsBeingEdited[i] = textOrderingFunction.apply(this.getTextOnRow(i, filterText));
            }
        }
        return this.textsBeingEdited;
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    public class_5481 getTextBeingEditedOnRow(int row, Function<class_2561, class_5481> function) {
        System.out.println("getTextBeingEditedOnRow");
        if (this.textsBeingEdited[row] == null && this.texts[row] != null) {
            this.textsBeingEdited[row] = function.apply(this.texts[row]);
        }
        return this.textsBeingEdited[row];
    }

    private class_2561[] getTexts(boolean filtered) {
        return filtered ? this.filteredTexts : this.texts;
    }

    @Nullable
    public class_2622 method_16886() {
        return new class_2622(this.field_11867, 9, this.method_16887());
    }

    public class_2487 method_16887() {
        return this.method_11007(new class_2487());
    }

    public boolean method_11011() {
        return true;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        if (!editable) {
            this.editor = null;
        }
    }

    public void setEditor(UUID editor) {
        this.editor = editor;
    }

    @Nullable
    public UUID getEditor() {
        return this.editor;
    }

    public boolean onActivate(class_3222 player) {
        for (class_2561 text : this.getTexts(player.method_33793())) {
            class_2583 style = text.method_10866();
            class_2558 clickEvent = style.method_10970();
            if (clickEvent == null || clickEvent.method_10845() != class_2558.class_2559.field_11750) continue;
            player.method_5682().method_3734().method_9249(this.getCommandSource(player), clickEvent.method_10844());
        }
        return true;
    }

    public class_2168 getCommandSource(@Nullable class_3222 player) {
        String string = player == null ? "Sign" : player.method_5477().getString();
        class_2585 text = player == null ? new class_2585("Sign") : player.method_5476();
        return new class_2168(class_2165.field_17395, class_243.method_24953((class_2382)this.field_11867), class_241.field_1340, (class_3218)this.field_11863, 2, string, (class_2561)text, this.field_11863.method_8503(), (class_1297)player);
    }

    public class_1767 getTextColor() {
        return this.textColor;
    }

    public boolean setTextColor(class_1767 value) {
        if (value != this.getTextColor()) {
            this.textColor = value;
            this.updateListeners();
            return true;
        }
        return false;
    }

    public boolean isGlowingText() {
        return this.glowingText;
    }

    public boolean setGlowingText(boolean glowingText) {
        if (this.glowingText != glowingText) {
            this.glowingText = glowingText;
            this.updateListeners();
            return true;
        }
        return false;
    }

    private void updateListeners() {
        System.out.println("UPDATED");
        this.method_5431();
        this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
    }
}

