/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.config;

import com.finallion.graveyard.config.ConfigFogParticleEntry;
import com.finallion.graveyard.config.ConfigStructureEntry;
import draylar.omegaconfig.api.Comment;
import draylar.omegaconfig.api.Config;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;

public class TheGraveyardConfig
implements Config {
    @Comment(value=" Welcome to The Graveyard Config!\n //\n // Here, you can disable structures to spawn, change their chance of spawning, change their separation and also change their salt.\n // Additionally, you can turn the graveyard fog particles on and set the chance of spawning them (higher numbers = lower chance of spawning).\n // Graveyard fog particles spawn in graveyards and add an atmospheric and spooky element while exploring.\n //\n // To disable a structure to spawn, simply go to the corresponding entry and set `enabled` to false.\n //\n // The Graveyard uses the vanilla structure spawning system. That is -\n // - Separation is the minimum chunks between structures\n // - Spacing is the average chunks between structures (Spacing value needs to be higher than Separation value!)\n // - Salt is a special field that gives structures unique spawning positions. (Only change if you know what you are doing!)\n //\n // Notice: reducing the generation settings will increase the risk of structures overlapping. Especially jigsaw structures are unpredictable!\n")
    public final Map<String, ConfigStructureEntry> structureConfigEntries = new HashMap<String, ConfigStructureEntry>(8);
    public final Map<String, ConfigFogParticleEntry> particleConfigEntries = new HashMap<String, ConfigFogParticleEntry>(1);

    public String getName() {
        return "the-graveyard-config";
    }

    public String getExtension() {
        return "json5";
    }

    public boolean fogSpawn(class_2960 id) {
        return this.getParticle((class_2960)id).canGenerate;
    }

    public boolean enabled(class_2960 id) {
        return this.get((class_2960)id).enabled;
    }

    public ConfigStructureEntry get(class_2960 id) {
        for (Map.Entry<String, ConfigStructureEntry> entry : this.structureConfigEntries.entrySet()) {
            if (!entry.getKey().equals(id.method_12832())) continue;
            return entry.getValue();
        }
        throw new NullPointerException("Tried StructureConfigEntry with id: " + id + ", but it was null!");
    }

    public ConfigFogParticleEntry getParticle(class_2960 id) {
        for (Map.Entry<String, ConfigFogParticleEntry> entry : this.particleConfigEntries.entrySet()) {
            if (!entry.getKey().equals(id.method_12832())) continue;
            return entry.getValue();
        }
        throw new NullPointerException("Tried FogParticleConfigEntry with id: " + id + ", but it was null!");
    }

    public void save() {
        this.particleConfigEntries.putIfAbsent("graveyard_fog_particle", ConfigFogParticleEntry.of(50));
        this.structureConfigEntries.putIfAbsent("large_birch_tree", ConfigStructureEntry.of(14, 12, 304812394));
        this.structureConfigEntries.putIfAbsent("medium_walled_graveyard", ConfigStructureEntry.of(16, 14, 379123039));
        this.structureConfigEntries.putIfAbsent("mushroom_grave", ConfigStructureEntry.of(24, 18, 598017285));
        this.structureConfigEntries.putIfAbsent("small_grave", ConfigStructureEntry.of(12, 8, 240451934));
        this.structureConfigEntries.putIfAbsent("small_walled_graveyard", ConfigStructureEntry.of(20, 18, 1690192399));
        this.structureConfigEntries.putIfAbsent("small_walled_graveyard_desert", ConfigStructureEntry.of(32, 28, 661903018));
        this.structureConfigEntries.putIfAbsent("small_walled_graveyard_savanna", ConfigStructureEntry.of(14, 12, 451235912));
        this.structureConfigEntries.putIfAbsent("large_walled_graveyard", ConfigStructureEntry.of(11, 9, 739017628));
        super.save();
    }
}

