/*
 * Decompiled with CFR 0.152.
 */
package timber.event;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import timber.config.TimberConfig;

public class Timber {
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        World world = event.getPlayer().func_130014_f_();
        if (!world.field_72995_K && (world.func_180495_p(event.getPos().func_177977_b()).func_177230_c() == Blocks.field_196658_i || world.func_180495_p(event.getPos().func_177977_b()).func_177230_c() == Blocks.field_150346_d || world.func_180495_p(event.getPos().func_177977_b()).func_177230_c() == Blocks.field_196660_k || world.func_180495_p(event.getPos().func_177977_b()).func_177230_c() == Blocks.field_196661_l) && TimberConfig.reverseControl == event.getPlayer().func_213453_ef() && event.getPlayer().func_184586_b(event.getPlayer().func_184600_cs()).func_77973_b() instanceof AxeItem && Timber.checkLog(world.func_180495_p(event.getPos()))) {
            boolean isCreative = event.getPlayer().func_184812_l_();
            if (!isCreative) {
                event.getPlayer().func_71020_j(0.025f);
            }
            boolean drop = !isCreative || TimberConfig.dropsInCreative;
            Timber.chopLogs(world, event.getPos(), world.func_180495_p(event.getPos()).func_177230_c(), new ArrayList<BlockPos>(), drop, event.getPlayer());
        }
    }

    private static boolean checkLog(BlockState state) {
        if (state.func_177230_c() instanceof RotatedPillarBlock) {
            if (state.func_185904_a() == Material.field_237214_y_) {
                return true;
            }
            if (state.func_185904_a() == Material.field_151575_d && state.func_177229_b((Property)RotatedPillarBlock.field_176298_M) == Direction.Axis.Y) {
                return true;
            }
        }
        return false;
    }

    private static void chopLogs(World world, BlockPos pos, Block block, ArrayList<BlockPos> list, boolean drop, PlayerEntity player) {
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    BlockPos target = pos.func_177982_a(x, y, z);
                    if (world.func_180495_p(target).func_177230_c() == block) {
                        list.add(target);
                    }
                    if (!TimberConfig.breakLeaves || !(world.func_180495_p(target).func_177230_c() instanceof LeavesBlock)) continue;
                    list.add(target);
                }
            }
        }
        if (list.size() <= 0 || list == null) {
            list = null;
            return;
        }
        for (BlockPos target : list) {
            Timber.destroyBlock(world, target, pos, drop, player);
            Timber.chopLogs(world, target, block, new ArrayList<BlockPos>(), drop, player);
        }
    }

    public static boolean destroyBlock(World world, BlockPos pos, BlockPos posToDropItems, boolean drop, PlayerEntity player) {
        TileEntity tileentity;
        BlockState blockstate = world.func_180495_p(pos);
        if (blockstate.isAir((IBlockReader)world, pos)) {
            return false;
        }
        TileEntity tileEntity = tileentity = blockstate.hasTileEntity() ? world.func_175625_s(pos) : null;
        if (drop) {
            Block.func_220059_a((BlockState)blockstate, (IWorld)world, (BlockPos)posToDropItems, (TileEntity)tileentity);
        }
        if (TimberConfig.damageAxe && !player.func_184812_l_()) {
            player.func_184614_ca().func_96631_a(1, player.func_70681_au(), null);
        }
        return world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
    }
}

