/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.block.SoulType;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.capability.TBSoulConsumerProvider;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModSounds;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.tileentity.BlockEntityDecorativeGrave;

public class BlockDecorativeGrave
extends BlockGraveBase<BlockEntityDecorativeGrave> {
    public static final EnumProperty<SoulType> SOUL_TYPE = EnumProperty.m_61587_((String)"soul_type", SoulType.class);

    public BlockDecorativeGrave(GraveModel graveModel) {
        super(BlockDecorativeGrave.getBuilder(), graveModel);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(SOUL_TYPE, (Comparable)((Object)SoulType.NONE)));
    }

    public void m_49811_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        IntStream.rangeClosed(0, 1).mapToObj(textureId -> ItemBlockGrave.createDecorativeStack(this.graveModel, textureId)).forEach(arg_0 -> items.add(arg_0));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{SOUL_TYPE});
    }

    public float m_5880_(BlockState state, Player player, BlockGetter blockGetter, BlockPos pos) {
        return (Boolean)SharedConfigTombstone.decorative_grave.unbreakableDecorativeGrave.get() != false ? 0.0f : super.m_5880_(state, player, blockGetter, pos);
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter blockGetter, BlockPos pos, Entity entity) {
        return (Boolean)SharedConfigTombstone.decorative_grave.unbreakableDecorativeGrave.get() == false;
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter blockGetter, BlockPos pos, Player player) {
        return (Boolean)SharedConfigTombstone.decorative_grave.unbreakableDecorativeGrave.get() == false && super.canHarvestBlock(state, blockGetter, pos, player);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult hit) {
        LazyOptional soulConsumerHolder;
        if (!EntityHelper.isValidPlayer(playerIn)) {
            return InteractionResult.FAIL;
        }
        if (hand != InteractionHand.MAIN_HAND || playerIn.m_21205_().m_41619_()) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = playerIn.m_21205_();
        if (playerIn.f_19853_.m_5776_()) {
            return !EntityHelper.hasGlobalItemCooldown(playerIn, stack) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        ServerPlayer serverPlayer = (ServerPlayer)playerIn;
        boolean isSoulReceptacle = stack.m_150930_((Item)ModItems.soul_receptacle);
        LazyOptional lazyOptional = soulConsumerHolder = isSoulReceptacle ? LazyOptional.empty() : stack.getCapability(TBSoulConsumerProvider.CAP_SOUL_CONSUMER);
        if (!isSoulReceptacle && !soulConsumerHolder.isPresent()) {
            return super.m_6227_(state, level, pos, (Player)serverPlayer, hand, hit);
        }
        if (!EntityHelper.hasGlobalItemCooldown((Player)serverPlayer, stack)) {
            if (isSoulReceptacle) {
                EntityHelper.setGlobalItemCooldown((Player)serverPlayer, stack, 10);
                if (((SoulType)((Object)state.m_61143_(SOUL_TYPE))).hasSoul()) {
                    LangKey.MESSAGE_FREE_SOUL_FAILED.sendMessage((Player)serverPlayer, new Object[0]);
                    return InteractionResult.FAIL;
                }
                LightningBolt bolt = (LightningBolt)EntityType.f_20465_.m_20615_(level);
                if (bolt != null) {
                    bolt.m_20219_(Vec3.m_82539_((Vec3i)pos));
                    bolt.m_20874_(true);
                    level.m_7967_((Entity)bolt);
                }
                level.m_7731_(pos, (BlockState)state.m_61124_(SOUL_TYPE, (Comparable)((Object)SoulType.WEAK)), 3);
                LangKey.MESSAGE_FREE_SOUL_SUCCESS.sendMessage((Player)serverPlayer, new Object[0]);
                if (!serverPlayer.m_7500_()) {
                    serverPlayer.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                }
                serverPlayer.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.reward(serverPlayer, 10, (Integer)ConfigTombstone.alignment.pointsFreeSoulReceptacle.get()));
                ModTriggers.FREE_SOUL.trigger(serverPlayer);
                return InteractionResult.SUCCESS;
            }
            soulConsumerHolder.ifPresent(soulConsumer -> {
                if (soulConsumer.isEnchanted(stack)) {
                    LangKey.MESSAGE_ENCHANT_ITEM_ALREADY_ENCHANTED.sendMessage((Player)serverPlayer, new Object[0]);
                } else {
                    SoulType soulType = (SoulType)((Object)((Object)state.m_61143_(SOUL_TYPE)));
                    if (soulType.hasSoul()) {
                        int soulStrength = soulType.getSoulStrength();
                        if (soulConsumer.canEnchant(level, pos, (Player)serverPlayer, stack)) {
                            ISoulConsumer.ConsumeResult consumeResult = soulConsumer.setEnchant(level, pos, serverPlayer, stack, soulStrength);
                            if (consumeResult.result().success()) {
                                if (soulStrength == 2 && consumeResult.soulStrength() == 1) {
                                    ModTriggers.KNOWLEDGE_WASTED.trigger(serverPlayer);
                                }
                                level.m_7731_(pos, (BlockState)state.m_61124_(SOUL_TYPE, (Comparable)((Object)soulType.consume(consumeResult.soulStrength()))), 3);
                                BlockEntityDecorativeGrave tile = (BlockEntityDecorativeGrave)((Object)((Object)this.getTileEntity(level, pos)));
                                if (tile != null) {
                                    tile.resetCheckSoul();
                                }
                                ModSounds.playSoundAllAround(ModSounds.MAGIC_USE01, SoundSource.PLAYERS, level, serverPlayer.m_142538_(), 0.5f, 0.5f);
                                LangKey.sendMessage(consumeResult.message(), (Player)serverPlayer);
                                ModTriggers.CONSUME_SOUL.trigger(serverPlayer);
                                serverPlayer.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.reward(serverPlayer, soulConsumer.getKnowledge(), 0));
                            } else {
                                LangKey.sendMessage(consumeResult.message(), (Player)serverPlayer);
                            }
                        } else {
                            LangKey.MESSAGE_ENCHANT_ITEM_NOT_ALLOWED.sendMessage((Player)serverPlayer, new Object[0]);
                        }
                    } else {
                        LangKey.MESSAGE_ENCHANT_ITEM_NO_SOUL.sendMessage((Player)serverPlayer, new Object[0]);
                    }
                }
            });
            EntityHelper.setGlobalItemCooldown((Player)serverPlayer, stack, 10);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        ItemStack stack;
        if (entity.m_6144_() && entity.m_6084_() && TimeHelper.atInterval(entity, 20) && EntityHelper.isValidPlayer(entity) && !(stack = ((Player)entity).m_21205_()).m_41619_()) {
            stack.getCapability(TBSoulConsumerProvider.CAP_SOUL_CONSUMER).ifPresent(soulConsumer -> soulConsumer.onSneakGrave(level, pos, (Player)entity, stack));
        }
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        String string;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        int n = (Integer)state.m_61143_((Property)MODEL_TEXTURE);
        Object object = builder.m_78970_(LootContextParams.f_81462_);
        if (object instanceof BlockEntityDecorativeGrave) {
            BlockEntityDecorativeGrave decorativeGrave = (BlockEntityDecorativeGrave)((Object)object);
            string = decorativeGrave.getOwnerName();
        } else {
            string = "";
        }
        drops.add(ItemBlockGrave.createDecorativeStack(this.graveModel, n, string));
        return drops;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntityDecorativeGrave tile;
        String engraved_name;
        if (!level.m_5776_() && !(engraved_name = EngravableHelper.getEngravedName(stack)).isEmpty() && (tile = (BlockEntityDecorativeGrave)((Object)this.getTileEntity(level, pos))) != null) {
            tile.setOwner(engraved_name, TimeHelper.systemTime());
        }
    }

    private static BlockBehaviour.Properties getBuilder() {
        return BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(10.0f, 1.8E7f).m_60953_(s -> 3).m_60918_(SoundType.f_56742_);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BlockEntityDecorativeGrave(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> tile) {
        return BlockDecorativeGrave.createTickerHelper(tile, ModBlocks.tile_decorative_grave, level.m_5776_() ? BlockEntityDecorativeGrave::clientTick : BlockEntityDecorativeGrave::serverTick);
    }
}

