/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.compatibility;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModTabs;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CombineRecipeCategory
implements IRecipeCategory<CombineRecipe> {
    private static final ResourceLocation RECIPE_GUI_VANILLA = new ResourceLocation("jei", "textures/gui/gui_vanilla.png");
    private static final ResourceLocation TEXTURE = new ResourceLocation("textures/gui/toasts.png");
    static final ResourceLocation COMBINE_RL = new ResourceLocation("tombstone", "combine");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable mouseOn;
    private final IDrawable mouseOff;

    CombineRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(RECIPE_GUI_VANILLA, 0, 168, 124, 18).addPadding(0, 0, 20, 0).build();
        this.icon = guiHelper.createDrawableIngredient((Object)ModTabs.mainTab.m_40787_());
        this.mouseOn = guiHelper.drawableBuilder(TEXTURE, 234, 20, 20, 20).build();
        this.mouseOff = guiHelper.drawableBuilder(TEXTURE, 196, 0, 20, 20).build();
    }

    public ResourceLocation getUid() {
        return COMBINE_RL;
    }

    public Class<CombineRecipe> getRecipeClass() {
        return CombineRecipe.class;
    }

    public Component getTitle() {
        return LangKey.MESSAGE_COMBINE_IN_INVENTORY.getText(new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(CombineRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients((List)Lists.newArrayList((Object[])new Ingredient[]{recipe.combineOn(), recipe.combined()}));
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.result());
    }

    public void setRecipe(IRecipeLayout recipeLayout, CombineRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 20, 0);
        guiItemStacks.init(1, true, 69, 0);
        guiItemStacks.init(2, false, 127, 0);
        guiItemStacks.set(0, (List)Lists.newArrayList((Object[])recipe.combineOn().m_43908_()));
        guiItemStacks.set(1, (List)Lists.newArrayList((Object[])recipe.combined().m_43908_()));
        guiItemStacks.set(2, recipe.result());
    }

    public void draw(CombineRecipe recipe, PoseStack poseStack, double mouseX, double mouseY) {
        if (TimeHelper.inIntervalBefore(TimeHelper.systemTime(), 2000, 700)) {
            this.mouseOn.draw(poseStack, -3, -3);
        } else {
            this.mouseOff.draw(poseStack, -1, -3);
        }
    }

    record CombineRecipe(Ingredient combineOn, Ingredient combined, ItemStack result) {
    }
}

