/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.compatibility;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.compatibility.CombineRecipeCategory;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.TameableType;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTags;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@JeiPlugin
public class IntegrationJEI
implements IModPlugin {
    private static final ResourceLocation JEI_INTEGRATION_RL = new ResourceLocation("tombstone", "jei_integration");

    public ResourceLocation getPluginUid() {
        return JEI_INTEGRATION_RL;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new CombineRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        jeiRuntime.getIngredientManager().addIngredientsAtRuntime(VanillaTypes.ITEM, Collections.singletonList(new ItemStack((ItemLike)ModItems.grave_key)));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ImmutableList.Builder combineBuilder = ImmutableList.builder();
        String randomTameable = TameableType.getRandomTameableEntityTypeString();
        combineBuilder.add((Object)new CombineRecipeCategory.CombineRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{ModItems.bone_needle.impregnate(new ItemStack((ItemLike)ModItems.bone_needle), randomTameable)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.impregnated_diamond}), ModItems.impregnated_diamond.impregnate(new ItemStack((ItemLike)ModItems.impregnated_diamond), randomTameable)));
        combineBuilder.add((Object)new CombineRecipeCategory.CombineRecipe(Ingredient.m_43911_(ModTags.Items.enchanted_grave_key_ingredients), Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModItems.grave_key)}), NBTStackHelper.setBoolean(new ItemStack((ItemLike)ModItems.grave_key), "enchant", true)));
        ModBlocks.DECORATIVE_GRAVES.values().forEach(decorativeGrave -> {
            String name = Helper.getRandomThankName();
            combineBuilder.add((Object)new CombineRecipeCategory.CombineRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{EngravableHelper.setEngravedName(new ItemStack((ItemLike)ModItems.grave_plate), name)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{decorativeGrave}), EngravableHelper.setEngravedName(new ItemStack((ItemLike)decorativeGrave), name)));
            ItemStack whiteGrave = ItemBlockGrave.setModelTexture(new ItemStack((ItemLike)decorativeGrave), 1);
            combineBuilder.add((Object)new CombineRecipeCategory.CombineRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{EngravableHelper.setEngravedName(new ItemStack((ItemLike)ModItems.grave_plate), name)}), Ingredient.m_43927_((ItemStack[])new ItemStack[]{whiteGrave}), EngravableHelper.setEngravedName(whiteGrave.m_41777_(), name)));
        });
        registration.addRecipes((Collection)combineBuilder.build(), CombineRecipeCategory.COMBINE_RL);
        ImmutableList.Builder builder = ImmutableList.builder();
        IVanillaRecipeFactory factory = registration.getVanillaRecipeFactory();
        builder.add((Object)factory.createAnvilRecipe(new ItemStack((ItemLike)ModItems.grave_plate), Collections.singletonList(new ItemStack((ItemLike)Items.f_42416_)), Collections.singletonList(EngravableHelper.setEngravedName(new ItemStack((ItemLike)ModItems.grave_plate), Helper.getRandomThankName()))));
        ItemStack tablet = NBTStackHelper.setBoolean(new ItemStack((ItemLike)ModItems.tablet_of_assistance), "enchant", true);
        builder.add((Object)factory.createAnvilRecipe(tablet, Collections.singletonList(new ItemStack((ItemLike)ModItems.grave_dust)), Collections.singletonList(EngravableHelper.setEngravedName(tablet.m_41777_(), Helper.getRandomThankName()))));
        registration.addRecipes((Collection)builder.build(), VanillaRecipeCategoryUid.ANVIL);
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        for (Block block : ModBlocks.DECORATIVE_GRAVES.values()) {
            registration.registerSubtypeInterpreter(block.m_5456_(), (stack, ctx) -> String.valueOf(ItemBlockGrave.getModelTexture(stack)));
        }
        registration.registerSubtypeInterpreter((Item)ModItems.tablet_of_home, (stack, ctx) -> ModItems.tablet_of_home.isAncient((ItemStack)stack) ? "ancient" : "normal");
        registration.registerSubtypeInterpreter((Item)ModItems.tablet_of_recall, (stack, ctx) -> ModItems.tablet_of_recall.isAncient((ItemStack)stack) ? "ancient" : "normal");
        registration.registerSubtypeInterpreter((Item)ModItems.grave_key, (stack, ctx) -> ModItems.grave_key.isEnchanted((ItemStack)stack) ? "enchanted" : "normal");
    }
}

