/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.event;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.village.VillageSiege;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.PhantomSpawner;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.capability.IProtectedEntity;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.event.PhantomSpawnerEvent;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.capability.ProtectedEntityImpl;
import ovh.corail.tombstone.capability.ProtectedEntityProvider;
import ovh.corail.tombstone.capability.ProtectedGraveGuardianImpl;
import ovh.corail.tombstone.capability.TBCapabilityDefault;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.capability.TBSoulConsumerProvider;
import ovh.corail.tombstone.command.CommandTBAcceptTeleport;
import ovh.corail.tombstone.command.CommandTBRecovery;
import ovh.corail.tombstone.command.CommandTBTeleport;
import ovh.corail.tombstone.compatibility.CompatibilityCosmeticArmor;
import ovh.corail.tombstone.compatibility.CompatibilityFirstAid;
import ovh.corail.tombstone.compatibility.CompatibilityMinecolonies;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.entity.GraveGuardian;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.DamageType;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.DummyTargetEntity;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EnchantHelper;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.PlayerStatusHandler;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.SpawnProtectionHandler;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TameableType;
import ovh.corail.tombstone.helper.ThreadedBackup;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.network.EffectMessage;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SyncProtectionMessage;
import ovh.corail.tombstone.network.TombstoneActivatedMessage;
import ovh.corail.tombstone.network.UpdateClientMessage;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModDamages;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModSounds;
import ovh.corail.tombstone.registry.ModTags;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.spawner.CustomPhantomSpawner;
import ovh.corail.tombstone.spawner.CustomVillageSiege;
import ovh.corail.tombstone.tileentity.BlockEntityPlayerGrave;

@Mod.EventBusSubscriber(modid="tombstone", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EventHandler {
    private static final String END_CONQUERED_EFFECTS_NBT_LIST = "tb_end_conquered_effects";
    private static long LAST_BACKUP = -1L;
    private static final Field CAPABILITIES = ObfuscationReflectionHelper.findField(CapabilityProvider.class, (String)"capabilities");
    private static final String IS_DRINKING_POTION = "is_drinking_potion";

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onServerStarting(ServerStartingEvent event) {
        TimeHelper.init();
        if (SupportMods.COSMETIC_ARMOR.isLoaded()) {
            MinecraftForge.EVENT_BUS.register((Object)CompatibilityCosmeticArmor.instance);
        }
        if (SupportMods.FIRST_AID.isLoaded()) {
            MinecraftForge.EVENT_BUS.register((Object)CompatibilityFirstAid.instance);
        }
        ThreadedBackup.INSTANCE.startThread();
        TameableType.init(event.getServer());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onServerStoppingEvent(ServerStoppingEvent event) {
        CallbackHandler.flushTasks();
        PlayerPreference.clear();
        CooldownHandler.INSTANCE.clear();
        try {
            ThreadedBackup.INSTANCE.flush();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            ThreadedBackup.INSTANCE.stopThread();
        }
    }

    @SubscribeEvent
    public static void onPlayerLogued(PlayerEvent.PlayerLoggedInEvent event) {
        if (EntityHelper.isValidServerPlayer(event.getPlayer())) {
            MinecraftServer server = Objects.requireNonNull(event.getPlayer().m_20194_());
            ServerPlayer player = (ServerPlayer)event.getPlayer();
            PlayerStatusHandler.updateStatus(player);
            ModTriggers.PASS_APRIL_FOOL.trigger(player);
            ModTriggers.CHRISTMAS.trigger(player);
            if (TimeHelper.isDateAroundHalloween()) {
                ModTriggers.HALLOWEEN.trigger(player);
            }
            EntityHelper.syncTBCapability(player, true);
            PacketHandler.sendToPlayer(new UpdateClientMessage(server.m_129783_().m_8900_(), server.m_6982_() ? server.m_6396_() : 0, TimeHelper.getSpecialEvent()), player);
            PacketHandler.sendToPlayer(CooldownHandler.INSTANCE.getCooldownPacket(player), player);
        }
    }

    @SubscribeEvent
    public static void onRegisterCommand(RegisterCommandsEvent event) {
        Helper.initCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        MinecraftServer server = Helper.getServer();
        if (server == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            PlayerStatusHandler.updateAllStatus(server);
        } else {
            long systemTime;
            if (LAST_BACKUP < TimeHelper.SERVER_START_TIME) {
                LAST_BACKUP = TimeHelper.SERVER_START_TIME;
            } else if (((Boolean)ConfigTombstone.recovery.recoveryPlayerEnable.get()).booleanValue() && TimeUnit.MILLISECONDS.toMinutes((systemTime = TimeHelper.systemTime()) - LAST_BACKUP) > (long)((Integer)ConfigTombstone.recovery.recoveryPlayerTimer.get()).intValue()) {
                LAST_BACKUP = systemTime;
                CommandTBRecovery.saveAllPlayers(server, success -> ModTombstone.LOGGER.info((success ? LangKey.MESSAGE_RECOVERY_SAVE_ALL_PLAYERS_SUCCESS : LangKey.MESSAGE_RECOVERY_SAVE_ALL_PLAYERS_FAILED).asLog()));
            }
            CommandTBAcceptTeleport.cleanTickets();
            CallbackHandler.tick();
        }
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (event.getPlayer().m_19941_((Tag)FluidTags.f_13131_) && EffectHelper.isPotionActive((LivingEntity)event.getPlayer(), ModEffects.aquatic_life)) {
            event.setNewSpeed(event.getNewSpeed() * (EnchantmentHelper.m_44934_((LivingEntity)event.getPlayer()) ? 2.0f : 10.0f));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDetonate(ExplosionEvent.Detonate event) {
        event.getAffectedBlocks().removeIf(blockPos -> {
            BlockState state = event.getWorld().m_8055_(blockPos);
            return ModBlocks.isAnyGrave(state.m_60734_()) || state.m_60620_(ModTags.Blocks.grave_marbles);
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBreak(BlockEvent.BreakEvent event) {
        if (((Boolean)ConfigTombstone.player_death.nerfGhostlyShapeBreakBlock.get()).booleanValue() && EntityHelper.isValidServerPlayer(event.getPlayer()) && EffectHelper.isPotionActive((LivingEntity)event.getPlayer(), ModEffects.ghostly_shape)) {
            EffectHelper.clearEffect((LivingEntity)event.getPlayer(), ModEffects.ghostly_shape);
            ModTriggers.CANCEL_GHOSTLY_SHAPE.trigger((ServerPlayer)event.getPlayer());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().m_5776_()) {
            ServerLevel world = (ServerLevel)event.getWorld();
            ImmutableList.Builder builder = new ImmutableList.Builder();
            boolean valid = false;
            for (CustomSpawner spawner : world.f_8558_) {
                if (spawner instanceof PhantomSpawner && !(spawner instanceof CustomPhantomSpawner)) {
                    builder.add((Object)new CustomPhantomSpawner());
                    valid = true;
                    continue;
                }
                if (spawner instanceof VillageSiege && !(spawner instanceof CustomVillageSiege)) {
                    builder.add((Object)new CustomVillageSiege());
                    valid = true;
                    continue;
                }
                builder.add((Object)spawner);
            }
            if (valid) {
                world.f_8558_ = builder.build();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingHurt(LivingHurtEvent event) {
        boolean isPlayer;
        EntityDamageSource damageSource;
        DamageSource damageSource2;
        ServerPlayer player;
        if (EntityHelper.isValidServerPlayer((Entity)event.getEntityLiving()) && event.getEntityLiving().m_6084_() && (player = (ServerPlayer)event.getEntityLiving()).m_6117_() && player.m_21211_().m_41720_() instanceof ItemGraveMagic && EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.concentration) == 0) {
            EntityHelper.setGlobalItemCooldown((Player)player, player.m_21211_(), 40);
            player.m_5810_();
            LangKey.MESSAGE_SPELLCASTING_INTERRUPTED.sendMessage((Player)player, new Object[0]);
        }
        if (event.getEntityLiving() == null || event.getEntityLiving().f_19853_.m_5776_()) {
            return;
        }
        MobEffectInstance boneShieldEffect = event.getEntityLiving().m_21124_(ModEffects.bone_shield);
        if (boneShieldEffect != null && !event.getSource().m_19360_() && !event.getSource().m_19372_() && (damageSource2 = event.getSource()) instanceof EntityDamageSource && !((damageSource = (EntityDamageSource)damageSource2) instanceof IndirectEntityDamageSource)) {
            event.setCanceled(true);
            if (!damageSource.m_19403_()) {
                Optional.ofNullable(event.getSource().m_7639_()).filter(Entity::m_6084_).ifPresent(s -> {
                    float reflectedDamages = event.getAmount() * ((float)Mth.m_14045_((int)boneShieldEffect.f_19504_, (int)1, (int)10) / 10.0f);
                    if (reflectedDamages >= 1.0f) {
                        ModSounds.playSoundAllAround(SoundEvents.f_12511_, SoundSource.NEUTRAL, s.f_19853_, s.m_142538_(), 0.5f, (Helper.random.nextFloat() - Helper.random.nextFloat()) * 0.2f + 1.0f);
                        s.m_6469_(DamageSource.m_19335_((Entity)event.getEntityLiving()), reflectedDamages);
                    }
                });
            }
            return;
        }
        if (EffectHelper.isUnstableIntangibilityActive(event.getEntityLiving())) {
            event.setCanceled(true);
            return;
        }
        if (DamageType.LIGHTNING.is(event.getSource()) && EffectHelper.isPotionActive(event.getEntityLiving(), ModEffects.lightning_resistance)) {
            event.setAmount(event.getAmount() / 4.0f);
        }
        if (DamageType.COLD.is(event.getSource()) && EffectHelper.isPotionActive(event.getEntityLiving(), ModEffects.frost_resistance)) {
            event.setAmount(event.getAmount() / 4.0f);
        }
        if (isPlayer = EntityHelper.isValidServerPlayer((Entity)event.getEntityLiving())) {
            if (event.getSource() == ModDamages.BEYOND_THE_GRAVE) {
                if (((Boolean)ConfigTombstone.general.allowBeyondTheGraveDamage.get()).booleanValue()) {
                    event.getEntityLiving().getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> {
                        int knowledgeLevel = cap.getTotalPerkPoints();
                        if (knowledgeLevel > 0) {
                            event.setAmount(event.getAmount() * (1.0f - (float)Math.min(20, knowledgeLevel) * 0.05f));
                        }
                    });
                }
            } else {
                Entity entity;
                int alignmentLevel = event.getEntityLiving().getCapability(TBCapabilityProvider.TB_CAPABILITY).map(ITBCapability::getAlignmentLevel).orElse(0);
                if (alignmentLevel != 0 && (entity = event.getSource().m_7639_()) instanceof LivingEntity) {
                    boolean valid;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    boolean bl = EntityHelper.isUndead(livingEntity) ? alignmentLevel > 0 : (valid = alignmentLevel < 0);
                    if (valid) {
                        float amount = event.getAmount() * (1.0f - 0.1f * (float)Math.abs(alignmentLevel));
                        if (amount < 0.5f) {
                            event.setCanceled(true);
                        } else {
                            event.setAmount(amount);
                        }
                    }
                }
            }
            if (EffectHelper.isPotionActive(event.getEntityLiving(), ModEffects.ghostly_shape, 5) && Helper.isValidPos(event.getEntityLiving().f_19853_, event.getEntityLiving().m_142538_())) {
                event.setCanceled(true);
                return;
            }
        }
        if (EntityHelper.isValidPlayer(event.getSource().m_7639_())) {
            Player player2 = (Player)event.getSource().m_7639_();
            if (!event.getEntityLiving().equals((Object)player2)) {
                if (EffectHelper.isPotionActive((LivingEntity)player2, ModEffects.ghostly_shape)) {
                    EffectHelper.clearEffect((LivingEntity)player2, ModEffects.ghostly_shape);
                    ModTriggers.CANCEL_GHOSTLY_SHAPE.trigger((ServerPlayer)player2);
                }
                if (EffectHelper.isPotionActive((LivingEntity)player2, ModEffects.diversion)) {
                    EffectHelper.clearEffect((LivingEntity)player2, ModEffects.diversion);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPreventDeath(LivingDamageEvent event) {
        if (event.getEntityLiving() != null && event.getEntityLiving().m_6084_() && event.getEntityLiving().m_21223_() <= event.getAmount() && !event.getEntityLiving().f_19853_.m_5776_()) {
            Location location = event.getEntityLiving().getCapability(ProtectedEntityProvider.PROTECTED_ENTITY_CAPABILITY).map(cap -> {
                if (cap.isActive()) {
                    cap.apply(event.getEntityLiving(), false);
                    return new Location(cap.getSafeLocation(event.getEntityLiving()));
                }
                return Location.ORIGIN;
            }).orElse(Location.ORIGIN);
            if (!location.isOrigin()) {
                Location spawn;
                ServerLevel level;
                event.getEntityLiving().m_21153_(event.getEntityLiving().m_21233_());
                event.getEntityLiving().f_19789_ = 0.0f;
                EffectHelper.clearBadEffects(event.getEntityLiving());
                EffectHelper.addEffect(event.getEntityLiving(), MobEffects.f_19605_, 600, 9, new boolean[0]);
                if (((Boolean)ConfigTombstone.village_siege.glowingCreatureTest.get()).booleanValue()) {
                    EffectHelper.addEffect(event.getEntityLiving(), MobEffects.f_19619_, 600);
                }
                EffectHelper.addEffect(event.getEntityLiving(), ModEffects.diversion, 600);
                MinecraftServer server = event.getEntityLiving().m_20194_();
                ServerLevel serverLevel = level = server != null ? server.m_129880_(location.dim) : null;
                if (level != null && !(spawn = new SpawnHelper(level, location.getPos()).findSpawnPlace()).isOrigin()) {
                    Helper.teleport(event.getEntityLiving(), spawn, level);
                }
                EntityHelper.applyKillResult(event.getSource(), event.getEntityLiving());
                event.setCanceled(true);
                return;
            }
            if (EntityHelper.isValidServerPlayer((Entity)event.getEntityLiving())) {
                if (EventHandler.handlePlayerDamage((ServerPlayer)event.getEntityLiving(), event.getSource())) {
                    event.setCanceled(true);
                }
            } else if (ModItems.familiar_receptacle.captureSoul(event.getEntityLiving())) {
                event.setCanceled(true);
                event.getEntityLiving().m_146870_();
            }
        }
    }

    public static boolean handlePlayerDamage(ServerPlayer player, DamageSource source) {
        ItemStack soul;
        if (ModItems.voodoo_poppet.preventDeath(player, source)) {
            return true;
        }
        ServerLevel targetWorld = player.m_183503_();
        BlockPos playerPos = player.m_142538_();
        boolean requirePrevention = (Boolean)ConfigTombstone.player_death.preventDeathOutsideWorldBorder.get() != false && Helper.isOutsideWorldBorders((Level)targetWorld, playerPos) || (Boolean)ConfigTombstone.player_death.preventDeathOutsideBuildHeight.get() != false && Helper.isOutsideBuildHeight((Level)targetWorld, playerPos);
        ItemStack itemStack = soul = !requirePrevention ? InventoryHelper.findItemInMainInventory((Player)player, p -> p.m_150930_((Item)ModItems.soul_receptacle)) : ItemStack.f_41583_;
        if (requirePrevention || !soul.m_41619_()) {
            Location spawnPos = new SpawnHelper(targetWorld, Helper.getCloserValidPos((Level)targetWorld, playerPos)).findSpawnPlace();
            if (spawnPos.isOrigin() && targetWorld.m_6042_().m_63906_(DimensionType.f_63850_)) {
                spawnPos = new SpawnHelper(targetWorld, new BlockPos(0, 70, 0)).findSpawnPlace();
            }
            if (spawnPos.isOrigin()) {
                assert (player.m_20194_() != null);
                Pair<ServerLevel, BlockPos> respawnPoint = CommandTBTeleport.getRespawnPoint(player.m_20194_(), player);
                spawnPos = new SpawnHelper((ServerLevel)respawnPoint.getLeft(), (BlockPos)respawnPoint.getRight()).findSpawnPlace();
            }
            if (!spawnPos.isOrigin()) {
                if (!requirePrevention) {
                    soul.m_41774_(1);
                }
                player.m_21153_(player.m_21233_());
                EffectHelper.clearBadEffects((LivingEntity)player);
                EffectHelper.addEffect((LivingEntity)player, MobEffects.f_19618_, 1200, 9, new boolean[0]);
                EffectHelper.addEffect((LivingEntity)player, MobEffects.f_19605_, 1200, 9, new boolean[0]);
                EffectHelper.addEffect((LivingEntity)player, ModEffects.diversion, 1200);
                (requirePrevention ? LangKey.MESSAGE_CONFIG_PREVENT_DEATH : LangKey.MESSAGE_SOUL_PREVENT_DEATH).sendMessage((Player)player, new Object[0]);
                Helper.teleport(player, spawnPos, targetWorld);
                player.f_19789_ = 0.0f;
                return true;
            }
        }
        if (((Boolean)ConfigTombstone.recovery.backupOnDeath.get()).booleanValue() && !player.m_5833_()) {
            CommandTBRecovery.savePlayer(player, success -> ModTombstone.LOGGER.info((success ? LangKey.MESSAGE_RECOVERY_SAVE_PLAYER_SUCCESS : LangKey.MESSAGE_RECOVERY_SAVE_PLAYER_FAILED).getText(player.m_7755_()).getString()));
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onCheckAttack(LivingAttackEvent event) {
        if (Helper.isAprilFoolsDaySnowball(event.getEntityLiving(), event.getSource())) {
            EffectHelper.addEffect(event.getEntityLiving(), MobEffects.f_19597_, 200);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onCheckHidden(LivingEvent.LivingVisibilityEvent event) {
        Optional.ofNullable(PlayerStatusHandler.getPlayerStatus((Entity)event.getEntityLiving())).ifPresent(playerStatus -> event.modifyVisibility(playerStatus.visibleFactorLowPriority()));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onCheckDiscretion(LivingEvent.LivingVisibilityEvent event) {
        Optional.ofNullable(PlayerStatusHandler.getPlayerStatus((Entity)event.getEntityLiving())).ifPresent(playerStatus -> event.modifyVisibility(playerStatus.visibleFactorHighPriority()));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onCheckAttackTarget(LivingSetAttackTargetEvent event) {
        if (!EntityHelper.isValidPlayer((Entity)event.getEntityLiving()) && event.getTarget() != null) {
            LivingEntity attacker = event.getEntityLiving();
            if (EffectHelper.isPotionActive(event.getTarget(), ModEffects.ghostly_shape) || EffectHelper.isPotionActive(event.getTarget(), ModEffects.diversion)) {
                NeutralMob angerable;
                UUID angerAt;
                ((Mob)attacker).f_21362_ = null;
                if (event.getTarget().equals((Object)attacker.f_20949_)) {
                    attacker.f_20949_ = new DummyTargetEntity(attacker.f_19853_);
                }
                if (attacker instanceof NeutralMob && (angerAt = (angerable = (NeutralMob)attacker).m_6120_()) != null && angerAt.equals(event.getTarget().m_142081_())) {
                    angerable.m_6925_(null);
                    angerable.m_7870_(0);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!EntityHelper.isValidServerPlayer(event.getPlayer()) || event.getPlayer().m_5833_()) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getPlayer();
        EntityHelper.syncTBCapability(player, false);
        DeathHandler deathHandler = DeathHandler.INSTANCE;
        deathHandler.restoreSoulbounds(player);
        if (deathHandler.isPlayerDead((Player)player)) {
            if (PlayerPreference.get(player).getAutoEquipRule().equiOnRespawn()) {
                ListIterator it = player.m_150109_().f_35974_.listIterator();
                while (it.hasNext()) {
                    if (!InventoryHelper.autoequip((ItemStack)it.next(), (Player)player)) continue;
                    it.set(ItemStack.f_41583_);
                }
            }
            deathHandler.restorePlayerDead(player);
        }
        player.f_36095_.m_38946_();
        List<MobEffectInstance> list = NBTStackHelper.getEffectList(EntityHelper.getPersistentTag((Player)player), END_CONQUERED_EFFECTS_NBT_LIST, e -> true);
        if (!list.isEmpty()) {
            list.forEach(arg_0 -> ((ServerPlayer)player).m_7292_(arg_0));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onClone(PlayerEvent.Clone event) {
        Map originalEffects;
        if (!EntityHelper.isValidServerPlayer(event.getOriginal()) || !EntityHelper.isValidServerPlayer(event.getPlayer())) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getPlayer();
        ServerPlayer original = (ServerPlayer)event.getOriginal();
        try {
            ((CapabilityDispatcher)CAPABILITIES.get(original)).getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(originalCap -> player.getCapability(TBCapabilityProvider.TB_CAPABILITY).resolve().ifPresent(playerCap -> playerCap.deserializeNBT((net.minecraft.nbt.Tag)((CompoundTag)originalCap.serializeNBT()))));
        }
        catch (Throwable e) {
            LangKey.sendMessage((Component)new TextComponent("Your Knowledge of Death failed to restore"), (Player)player);
        }
        if (((Boolean)ConfigTombstone.compatibility.preserveEffectsOnReturnEndConquered.get()).booleanValue() && !event.isWasDeath() && original.m_183503_().m_46472_() == Level.f_46430_ && player.m_21221_().isEmpty() && !(originalEffects = original.m_21221_()).isEmpty()) {
            NBTStackHelper.setEffectlist(EntityHelper.getPersistentTag(event.getPlayer()), END_CONQUERED_EFFECTS_NBT_LIST, originalEffects.values().stream());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onPlayerDeath(LivingDeathEvent event) {
        if (!EntityHelper.isValidServerPlayer((Entity)event.getEntityLiving())) {
            if (!event.isCanceled() && event.getEntityLiving() != null) {
                EntityHelper.applyKillResult(event.getSource(), event.getEntityLiving());
            }
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntityLiving();
        if (event.isCanceled()) {
            if (((Boolean)ConfigTombstone.player_death.handlePlayerDeath.get()).booleanValue()) {
                ModTombstone.LOGGER.warn("The death event of the player " + player.m_7755_() + " was canceled by another mod");
            }
        } else {
            boolean isBeyondTheGraveDamage = (Boolean)ConfigTombstone.general.allowBeyondTheGraveDamage.get() != false && event.getSource() == ModDamages.BEYOND_THE_GRAVE;
            int knowledgeLoss = (Integer)ConfigTombstone.player_death.knowledgeLoss.get() + (isBeyondTheGraveDamage ? 10 : 0);
            if (knowledgeLoss > 0) {
                player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.loseKnowledge(player, knowledgeLoss));
                if (isBeyondTheGraveDamage) {
                    ModTriggers.LOST_KNOWLEDGE.trigger(player);
                }
            }
            DeathHandler.INSTANCE.addPlayerDead(player, event.getSource());
        }
    }

    private static void collectKeyAndSoulbound(Iterator<ItemEntity> it, List<ItemStack> keys, List<ItemStack> soulbounds) {
        while (it.hasNext()) {
            ItemEntity entityItem = it.next();
            if (entityItem == null) {
                it.remove();
                continue;
            }
            ItemStack stack = entityItem.m_32055_();
            if (stack.m_41619_()) {
                it.remove();
                continue;
            }
            if (stack.m_150930_((Item)ModItems.grave_key)) {
                keys.add(stack.m_41777_());
                entityItem.m_32045_(ItemStack.f_41583_);
                it.remove();
                continue;
            }
            if (EnchantHelper.getEnchantmentLevel(ModEnchantments.soulbound, stack) <= 0 && !ModItems.fishing_rod_of_misadventure.isAncient(stack) && !ModItems.enchanted_bundle.isEnchanted(stack)) continue;
            soulbounds.add(stack.m_41777_());
            entityItem.m_32045_(ItemStack.f_41583_);
            it.remove();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW, receiveCanceled=true)
    public static void onDrops(LivingDropsEvent event) {
        ItemStack key;
        BlockState state;
        boolean hasGrave;
        BlockEntityPlayerGrave grave;
        BlockEntity tile2;
        boolean hasDrop;
        if (!EntityHelper.isValidServerPlayer((Entity)event.getEntityLiving())) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntityLiving();
        if (Helper.isRuleKeepInventory((Player)player)) {
            return;
        }
        if (event.isCanceled()) {
            ModTombstone.LOGGER.warn("The drop event of the player " + player.m_36316_().getName() + " was canceled by another mod");
            return;
        }
        ArrayList<ItemStack> keys = new ArrayList<ItemStack>();
        ArrayList<ItemStack> soulbounds = new ArrayList<ItemStack>();
        EventHandler.collectKeyAndSoulbound(event.getDrops().iterator(), keys, soulbounds);
        double range = ((Integer)ConfigTombstone.player_death.snifferRange.get()).intValue();
        List itemList = player.f_19853_.m_6443_(ItemEntity.class, Helper.createBounds(player.m_142538_(), range), e -> e != null && (e.m_32056_() == null || player.m_142081_().equals(e.m_32056_())));
        EventHandler.collectKeyAndSoulbound(itemList.iterator(), keys, soulbounds);
        PlayerPreference playerPreference = PlayerPreference.get(player.m_142081_());
        DeathHandler deathHandler = DeathHandler.INSTANCE;
        if (playerPreference.denyGraveOnDeath()) {
            LangKey.MESSAGE_CHOOSE_NO_GRAVE.sendMessage((Player)player, StyleType.MESSAGE_SPECIAL, new Object[0]);
            deathHandler.storeSoulboundsOnBody(player, keys, soulbounds);
            return;
        }
        int countDrop = event.getDrops().size() + itemList.size();
        boolean bl = hasDrop = countDrop > 0;
        if (!((Boolean)ConfigTombstone.player_death.handlePlayerDeath.get()).booleanValue() || !hasDrop) {
            if (!hasDrop) {
                keys.stream().filter(p -> !ModItems.grave_key.isEnchanted((ItemStack)p)).findFirst().ifPresent(k -> ModItems.grave_key.reenchantOnDeath((Player)player, (ItemStack)k));
                LangKey.MESSAGE_NO_LOOT_FOR_GRAVE.sendMessage((Player)player, StyleType.MESSAGE_SPECIAL, new Object[0]);
            }
            deathHandler.storeSoulboundsOnBody(player, keys, soulbounds);
            return;
        }
        if (deathHandler.isNoGraveLocation(new Location((Entity)player))) {
            LangKey.MESSAGE_NO_GRAVE_LOCATION.sendMessage((Player)player, StyleType.MESSAGE_SPECIAL, new Object[0]);
            deathHandler.storeSoulboundsOnBody(player, keys, soulbounds);
            return;
        }
        MinecraftServer server = player.m_20194_();
        assert (server != null);
        ServerLevel level = player.m_183503_();
        BlockPos initPos = Helper.getCloserValidPos((Level)level, player.m_142538_());
        Location spawnPos = Location.ORIGIN;
        if (((Boolean)ConfigTombstone.player_death.allowToFillExistingGrave.get()).booleanValue()) {
            Location lastGrave;
            BlockEntityPlayerGrave tileGrave = level.m_46745_(initPos).m_62954_().values().stream().filter(BlockEntityPlayerGrave.class::isInstance).map(BlockEntityPlayerGrave.class::cast).filter(tile -> tile.getOwnerName().equals(player.m_36316_().getName()) && InventoryHelper.hasEnoughSlots(tile.getInventory(), countDrop)).findFirst().orElse(null);
            if (tileGrave != null) {
                spawnPos = new Location(tileGrave.m_58899_(), (Level)level);
            }
            if (spawnPos.isOrigin() && !(lastGrave = deathHandler.getLastGrave(server, player)).isOrigin() && lastGrave.isSameDimension((Level)level) && Helper.getDistanceSq((Vec3i)lastGrave.getPos(), (Vec3i)initPos) <= 400.0 && (tile2 = level.m_7702_(lastGrave.getPos())) instanceof BlockEntityPlayerGrave && InventoryHelper.hasEnoughSlots((grave = (BlockEntityPlayerGrave)tile2).getInventory(), countDrop)) {
                spawnPos = lastGrave;
            }
        }
        boolean bl2 = hasGrave = !spawnPos.isOrigin();
        if (!hasGrave) {
            Pair<ServerLevel, BlockPos> respawnPoint;
            Pair<Location, SpawnHelper.SpawnResult> res = new SpawnHelper(level, initPos).withPlayerPreference(playerPreference).findGravePlaceWithResult();
            spawnPos = (Location)res.getLeft();
            if (level.m_6042_().m_63906_(DimensionType.f_63850_) && (spawnPos.isOrigin() || !SpawnHelper.SpawnResult.NORMAL.hasPattern((SpawnHelper.SpawnResult)((Object)res.getRight()))) && !((Location)(res = new SpawnHelper(level, new BlockPos(0, 70, 0)).withPlayerPreference(playerPreference).findGravePlaceWithResult()).getLeft()).isOrigin() && SpawnHelper.SpawnResult.NORMAL.hasPattern((SpawnHelper.SpawnResult)((Object)res.getRight()))) {
                spawnPos = (Location)res.getLeft();
            }
            if (spawnPos.isOrigin() && (spawnPos = new SpawnHelper((ServerLevel)(respawnPoint = CommandTBTeleport.getRespawnPoint(server, player)).getLeft(), (BlockPos)respawnPoint.getRight()).withPlayerPreference(playerPreference).findGravePlace()).isOrigin()) {
                deathHandler.storeSoulboundsOnBody(player, keys, soulbounds);
                LangKey.MESSAGE_NO_PLACE_FOR_GRAVE.sendMessage((Player)player, StyleType.MESSAGE_SPECIAL, new Object[0]);
                ModTombstone.LOGGER.info("There was nowhere to place the grave!");
                return;
            }
        }
        if (!hasGrave) {
            deathHandler.logLastGrave((Player)player, spawnPos);
            Direction facing = player.m_6350_().m_122424_();
            Block graveBlock = ModBlocks.PLAYER_GRAVES.get((Object)playerPreference.getFavoriteGrave());
            state = (BlockState)((BlockState)((BlockState)graveBlock.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing)).m_61124_((Property)BlockGraveBase.IS_ENGRAVED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BlockGraveBase.MODEL_TEXTURE, (Comparable)Integer.valueOf(playerPreference.getMarbleType().ordinal()));
            level.m_46597_(spawnPos.getPos(), state);
        } else {
            state = level.m_8055_(spawnPos.getPos());
        }
        tile2 = level.m_7702_(spawnPos.getPos());
        if (!(tile2 instanceof BlockEntityPlayerGrave)) {
            deathHandler.storeSoulboundsOnBody(player, keys, soulbounds);
            LangKey.MESSAGE_FAIL_TO_PLACE_GRAVE.sendMessage((Player)player, StyleType.MESSAGE_SPECIAL, new Object[0]);
            ModTombstone.LOGGER.info((Object)LangKey.MESSAGE_FAIL_TO_PLACE_GRAVE.getText(new Object[0]));
            return;
        }
        grave = (BlockEntityPlayerGrave)tile2;
        deathHandler.setLastDeathLocation((Player)player, new Location(spawnPos.x, spawnPos.y + 1, spawnPos.z, spawnPos.dim));
        if (hasGrave) {
            grave.resetDeathTime();
        }
        boolean needAccess = (Integer)SharedConfigTombstone.player_death.decayTime.get() != 0 && (!server.m_129799_() || (Boolean)ConfigTombstone.player_death.pvpUnlockGrave.get() == false || !EntityHelper.isKilledByOtherPlayer((Player)player, event.getSource()));
        MutableComponent locked = new TextComponent("[").m_7220_((Component)(needAccess ? LangKey.MESSAGE_LOCKED.getText(new Object[0]).m_130946_((String)((Integer)SharedConfigTombstone.player_death.decayTime.get() > 0 ? " " + SharedConfigTombstone.player_death.decayTime.get() + " min" : "")) : LangKey.MESSAGE_UNLOCKED.getText(new Object[0]))).m_130946_("]").m_6270_(needAccess ? StyleType.COLOR_OFF : StyleType.COLOR_ON);
        player.m_6352_((Component)(hasGrave ? LangKey.MESSAGE_EXISTING_GRAVE : LangKey.MESSAGE_NEW_GRAVE).getText(StyleType.MESSAGE_SPECIAL, new Object[0]).m_130946_(" ").m_7220_((Component)locked), Util.f_137441_);
        player.m_6352_((Component)new TextComponent("[x: ").m_130946_(String.valueOf(spawnPos.x)).m_130946_(", y: ").m_130946_(String.valueOf(spawnPos.y)).m_130946_(", z: ").m_130946_(String.valueOf(spawnPos.z)).m_130946_("]").m_7220_((Component)new TextComponent(" in ").m_130946_(spawnPos.getDimString())), Util.f_137441_);
        Location finalSpawnPos = spawnPos;
        ItemStack itemStack = key = hasGrave ? keys.stream().filter(k -> ModItems.grave_key.getTombPos((ItemStack)k).equals(finalSpawnPos)).findFirst().orElse(ItemStack.f_41583_) : ItemStack.f_41583_;
        if (key.m_41619_() && ModItems.grave_key.isEnabled()) {
            key = ModItems.grave_key.createWithInfo((Player)player, spawnPos);
            keys.add(0, key);
        }
        ModItems.grave_key.reenchantOnDeath((Player)player, key);
        deathHandler.storeSoulboundsOnBody(player, keys, soulbounds);
        grave.setOwner((Player)player, TimeHelper.systemTime(), needAccess);
        IItemHandler itemHandler = grave.getInventory();
        event.getDrops().forEach(e -> e.m_32045_(ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)e.m_32055_().m_41777_(), (boolean)false)));
        itemList.forEach(e -> e.m_32045_(ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)e.m_32055_().m_41777_(), (boolean)false)));
        grave.m_6596_();
        level.m_7260_(spawnPos.getPos(), Blocks.f_50016_.m_49966_(), state, 2);
        ModTriggers.FIRST_GRAVE.trigger(player);
        if (event.getDrops().size() <= itemHandler.getSlots()) {
            try {
                event.getDrops().clear();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        boolean valid;
        if (event.getLeft().m_41619_() || event.getRight().m_41619_()) {
            return;
        }
        String newName = Optional.ofNullable(event.getName()).map(String::trim).orElse("");
        boolean bl = valid = event.getLeft().m_150930_((Item)ModItems.grave_plate) && event.getRight().m_150922_((Tag)Tags.Items.INGOTS_IRON) || ModItems.tablet_of_assistance.isEnchanted(event.getLeft()) && !ModItems.tablet_of_assistance.isAncient(event.getLeft()) && event.getRight().m_150930_((Item)ModItems.grave_dust);
        if (valid) {
            event.setOutput(EngravableHelper.setEngravedName(event.getLeft().m_41777_(), newName));
            event.setCost(1);
            event.setMaterialCost(1);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onAnvilRepair(AnvilRepairEvent event) {
        if (EntityHelper.isValidServerPlayer(event.getPlayer()) && event.getItemInput().m_150930_((Item)ModItems.grave_plate) && event.getIngredientInput().m_150922_((Tag)Tags.Items.INGOTS_IRON) && EngravableHelper.isEngraved(event.getItemResult())) {
            ModTriggers.ENGRAVE_GRAVE_PLATE.trigger((ServerPlayer)event.getPlayer());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Block block;
        if (!event.isCanceled() && EntityHelper.isValidServerPlayer(event.getPlayer()) && event.getHand() == InteractionHand.MAIN_HAND) {
            BlockEntity tile;
            boolean hasShadowStep;
            boolean requireNerfGhostlyShape = (Boolean)ConfigTombstone.player_death.nerfGhostlyShapeOpenChest.get() != false && EffectHelper.isPotionActive((LivingEntity)event.getPlayer(), ModEffects.ghostly_shape);
            boolean bl = hasShadowStep = (Boolean)ConfigTombstone.enchantments.nerfShadowStepOpenChest.get() != false && EntityHelper.getShadowStepLevel(event.getPlayer()) > 0;
            if ((requireNerfGhostlyShape || hasShadowStep) && (tile = event.getWorld().m_7702_(event.getPos())) != null && tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).isPresent()) {
                if (requireNerfGhostlyShape) {
                    EffectHelper.clearEffect((LivingEntity)event.getPlayer(), ModEffects.ghostly_shape);
                    ModTriggers.CANCEL_GHOSTLY_SHAPE.trigger((ServerPlayer)event.getPlayer());
                }
                if (hasShadowStep) {
                    EntityHelper.setShadowStepCooldown(event.getPlayer());
                }
            }
        }
        if (ModBlocks.isPlayerGrave(block = event.getWorld().m_8055_(event.getPos()).m_60734_())) {
            if (event.isCanceled()) {
                event.setCanceled(false);
                event.setUseBlock(Event.Result.DEFAULT);
                event.setUseItem(Event.Result.DEFAULT);
            }
            if (event.getWorld().m_5776_() && SpawnProtectionHandler.INSTANCE.isBlockProtected((ResourceKey<Level>)event.getWorld().m_46472_(), event.getPos())) {
                PacketHandler.sendToServer(new TombstoneActivatedMessage(event.getPos()));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() != null && event.getEntityLiving().f_19853_.m_5776_() && TimeHelper.atInterval(event.getEntityLiving().f_19853_, 20)) {
            if (((Boolean)ConfigTombstone.client.showShadowStep.get()).booleanValue() && EntityHelper.isValidPlayer((Entity)event.getEntityLiving()) && EntityHelper.getShadowStepLevel((Player)event.getEntityLiving()) > 0) {
                ModTombstone.PROXY.produceShadowStep(event.getEntityLiving());
            }
            if (((Boolean)ConfigTombstone.client.showShieldParticle.get()).booleanValue() && event.getEntityLiving().getCapability(ProtectedEntityProvider.PROTECTED_ENTITY_CAPABILITY).map(IProtectedEntity::isActive).orElse(false).booleanValue()) {
                ModTombstone.PROXY.produceShield(event.getEntityLiving());
            }
        }
    }

    @SubscribeEvent
    public static void onTrackingStart(PlayerEvent.StartTracking event) {
        if (EntityHelper.isValidServerPlayer(event.getPlayer()) && event.getTarget() != null) {
            MobEffectInstance effect;
            ServerPlayer player = (ServerPlayer)event.getPlayer();
            if (event.getTarget().getCapability(ProtectedEntityProvider.PROTECTED_ENTITY_CAPABILITY).map(IProtectedEntity::isActive).orElse(false).booleanValue()) {
                PacketHandler.sendToPlayer(new SyncProtectionMessage(event.getTarget().m_142049_(), true), player);
            }
            if (event.getTarget() instanceof LivingEntity && (effect = ((LivingEntity)event.getTarget()).m_21124_(ModEffects.bone_shield)) != null) {
                PacketHandler.sendToPlayer(new EffectMessage(event.getTarget().m_142049_(), effect), player);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemUseStart(LivingEntityUseItemEvent.Start event) {
        if (event.getItem().m_150930_(Items.f_42589_) && EntityHelper.isValidServerPlayer((Entity)event.getEntityLiving()) && PotionUtils.m_43547_((ItemStack)event.getItem()).size() > 0) {
            event.getEntityLiving().getPersistentData().m_128379_(IS_DRINKING_POTION, true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemUseStop(LivingEntityUseItemEvent.Stop event) {
        if (EventHandler.isDrinking(event.getEntityLiving())) {
            EventHandler.resetDrinking(event.getEntityLiving());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        if (EventHandler.isDrinking(event.getEntityLiving())) {
            EventHandler.resetDrinking(event.getEntityLiving());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPotionAdded(PotionEvent.PotionAddedEvent event) {
        if (EntityHelper.isValidPlayer((Entity)event.getEntityLiving()) && EventHandler.isDrinking(event.getEntityLiving()) && event.getPotionEffect().f_19503_ >= 1200 && EffectHelper.isAllowedEffect(event.getPotionEffect().m_19544_())) {
            float bonus = 1.0f + (float)EntityHelper.getPerkLevelWithBonus((Player)event.getEntityLiving(), ModPerks.alchemist) * 0.1f;
            EffectHelper.modifyEffectDuration(event.getPotionEffect(), e -> Mth.m_14143_((float)((float)e.f_19503_ * bonus)));
        }
    }

    private static boolean isDrinking(LivingEntity entityLiving) {
        return entityLiving.getPersistentData().m_128425_(IS_DRINKING_POTION, 1);
    }

    private static void resetDrinking(LivingEntity entityLiving) {
        entityLiving.getPersistentData().m_128473_(IS_DRINKING_POTION);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPotionAdded(PotionEvent.PotionApplicableEvent event) {
        Optional.ofNullable(event.getEntityLiving()).map(Entity::m_6095_).ifPresent(type -> {
            MobEffect effect = event.getPotionEffect().m_19544_();
            if (effect == ModEffects.exorcism) {
                event.setResult(type == EntityType.f_20530_ ? Event.Result.ALLOW : Event.Result.DENY);
            } else if (effect == ModEffects.ghostly_shape || effect == ModEffects.preservation || effect == ModEffects.true_sight || effect == ModEffects.bait) {
                event.setResult(EntityHelper.isValidPlayer((Entity)event.getEntityLiving()) ? Event.Result.ALLOW : Event.Result.DENY);
            } else if (EffectHelper.isBadEffect(effect) && EffectHelper.isPotionActive(event.getEntityLiving(), ModEffects.purification)) {
                event.setResult(Event.Result.DENY);
            }
        });
    }

    @SubscribeEvent
    public static void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(TBCapabilityProvider.RL, (ICapabilityProvider)new TBCapabilityProvider((NonNullSupplier<ITBCapability>)((NonNullSupplier)TBCapabilityDefault::new)));
        } else if (event.getObject() instanceof AbstractVillager) {
            event.addCapability(ProtectedEntityProvider.RL, (ICapabilityProvider)new ProtectedEntityProvider((NonNullSupplier<IProtectedEntity>)((NonNullSupplier)() -> new ProtectedEntityImpl(EntityHelper::getHomeLocation))));
        } else if (CompatibilityMinecolonies.instance.isCitizen((Entity)event.getObject())) {
            event.addCapability(ProtectedEntityProvider.RL, (ICapabilityProvider)new ProtectedEntityProvider((NonNullSupplier<IProtectedEntity>)((NonNullSupplier)() -> new ProtectedEntityImpl(CompatibilityMinecolonies.instance::getHomePos))));
        } else if (event.getObject() instanceof GraveGuardian) {
            event.addCapability(ProtectedEntityProvider.RL, (ICapabilityProvider)new ProtectedEntityProvider((NonNullSupplier<IProtectedEntity>)((NonNullSupplier)ProtectedGraveGuardianImpl::new)));
        }
    }

    @SubscribeEvent
    public static void onAttachItemCapability(AttachCapabilitiesEvent<ItemStack> event) {
        if (((ItemStack)event.getObject()).m_150930_(Items.f_151058_)) {
            event.addCapability(TBSoulConsumerProvider.RL, (ICapabilityProvider)new TBSoulConsumerProvider(ModItems.enchanted_bundle));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onSyncOnChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (EntityHelper.isValidServerPlayer(event.getPlayer())) {
            ServerPlayer player = (ServerPlayer)event.getPlayer();
            MinecraftServer server = event.getPlayer().m_20194_();
            if (server == null) {
                return;
            }
            EntityHelper.syncTBCapability(player, false);
            Optional.ofNullable(server.m_129880_(event.getFrom())).ifPresent(fromDim -> Optional.ofNullable(server.m_129880_(event.getTo())).ifPresent(toDim -> {
                long dif = TimeHelper.worldTicks((Level)toDim) - TimeHelper.worldTicks((Level)fromDim);
                if (dif != 0L) {
                    CooldownHandler.INSTANCE.updateWorldTime(player, dif);
                    IItemHandler itemHandler = InventoryHelper.getItemHandler((Entity)player);
                    IntStream.range(0, itemHandler.getSlots()).mapToObj(arg_0 -> ((IItemHandler)itemHandler).getStackInSlot(arg_0)).filter(stack -> stack.m_150930_((Item)ModItems.lost_tablet)).forEach(stack -> ModItems.lost_tablet.setCooldown((Level)toDim, (ItemStack)stack, Math.min(ModItems.lost_tablet.getCooldown((Level)fromDim, (ItemStack)stack), TimeHelper.tickFromMinute(10))));
                }
            }));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerInteractEntity(PlayerInteractEvent.EntityInteract event) {
        ItemStack heldStack;
        ItemStack itemStack = heldStack = event.getPlayer() != null ? event.getPlayer().m_21120_(event.getHand()) : ItemStack.f_41583_;
        if (event.getHand() == InteractionHand.MAIN_HAND && heldStack.m_150930_((Item)ModItems.bone_needle) && event.getTarget() instanceof LivingEntity && heldStack.m_41647_(event.getPlayer(), (LivingEntity)event.getTarget(), event.getHand()).m_19080_()) {
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
            return;
        }
        if (!EntityHelper.isValidPlayer(event.getPlayer())) {
            return;
        }
        if (heldStack.m_150930_((Item)ModItems.dust_of_vanishing) || heldStack.m_150930_((Item)ModItems.dust_of_frost) || heldStack.m_41720_() instanceof ItemGraveMagic) {
            event.setCancellationResult(InteractionResult.PASS);
            event.setCanceled(true);
            return;
        }
        if (event.getHand() == InteractionHand.MAIN_HAND && heldStack.m_150930_((Item)ModItems.ankh_of_pray) && event.getTarget() instanceof LivingEntity && heldStack.m_41647_(event.getPlayer(), (LivingEntity)event.getTarget(), event.getHand()).m_19080_()) {
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingConversionTop(LivingConversionEvent.Pre event) {
        if ((event.getOutcome() == EntityType.f_20492_ || event.getOutcome() == EntityType.f_20530_) && event.getEntityLiving().getPersistentData().m_128471_("tb_converting")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onLivingConversion(LivingConversionEvent.Pre event) {
        if ((event.getOutcome() == EntityType.f_20492_ || event.getOutcome() == EntityType.f_20530_) && event.getEntityLiving().getPersistentData().m_128471_("tb_converting")) {
            event.getEntityLiving().getPersistentData().m_128473_("tb_converting");
            event.setCanceled(false);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPhantomTime(PhantomSpawnerEvent.TimeForCheck event) {
        if (((Boolean)ConfigTombstone.general.knowledgeReducePhantomSpawn.get()).booleanValue()) {
            event.getPlayer().getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> event.modifyTimeForCheck((int)((float)event.getTimeForCheck() * (1.0f + (float)cap.getTotalPerkPoints() * 0.1f))));
        }
    }
}

