/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Option;
import net.minecraft.client.ProgressOption;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.SliderButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.gui.ColorOptionSlider;
import ovh.corail.tombstone.gui.ColorSliderHandler;
import ovh.corail.tombstone.gui.CustomButton;
import ovh.corail.tombstone.gui.CustomOptionsRowList;
import ovh.corail.tombstone.gui.CycleConfigOption;
import ovh.corail.tombstone.gui.TBScreen;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.registry.ModBlocks;

@OnlyIn(value=Dist.CLIENT)
public class GuiConfig
extends TBScreen {
    private static final ResourceLocation tablet = new ResourceLocation("tombstone", "textures/item/grave_plate.png");
    private TabConfig tab = TabConfig.GRAVE;
    private final String nameToDisplay;
    private final PlayerPreference playerPreference = PlayerPreference.fromClientConfig();
    private boolean enhanced_tooltips;
    private boolean skipRespawnScreen;
    private boolean dateInMCTime;
    private boolean showInfoOnEnchantment;
    private boolean highlightGrave;
    private boolean showShadowStep;
    private boolean showShieldParticle;
    private boolean allowHalloweenGhost;
    private boolean showMagicCircle;
    private CustomOptionsRowList miscList;
    private CustomOptionsRowList effectList;
    private ConfigTombstone.Client.GraveSkinRule graveSkinRule;
    private ConfigTombstone.Client.FogDensity fogDensity;
    private ConfigTombstone.Client.MarkerType markerType;
    private final ColorSliderHandler colorSliderHandler0;
    private final ColorSliderHandler colorSliderHandler1;
    private final ColorSliderHandler colorSliderHandler2;
    private final ColorSliderHandler colorSliderHandler3;
    private final ColorSliderHandler colorSliderHandler4;
    private boolean saveButtonHighlight;
    private boolean isDirty;
    private final Option[] miscOptions;
    private final Option[] effectOptions;
    private final List<Predicate<Boolean>> config_changed_predics;

    public GuiConfig() {
        super((Component)new TextComponent("Tombstone Config"));
        this.enhanced_tooltips = (Boolean)ConfigTombstone.client.showEnhancedTooltips.get();
        this.skipRespawnScreen = (Boolean)ConfigTombstone.client.skipRespawnScreen.get();
        this.dateInMCTime = (Boolean)ConfigTombstone.client.dateInMCTime.get();
        this.showInfoOnEnchantment = (Boolean)ConfigTombstone.client.showInfoOnEnchantment.get();
        this.highlightGrave = (Boolean)ConfigTombstone.client.highlight.get();
        this.showShadowStep = (Boolean)ConfigTombstone.client.showShadowStep.get();
        this.showShieldParticle = (Boolean)ConfigTombstone.client.showShieldParticle.get();
        this.allowHalloweenGhost = (Boolean)ConfigTombstone.client.allowHalloweenGhost.get();
        this.showMagicCircle = (Boolean)ConfigTombstone.client.showMagicCircle.get();
        this.graveSkinRule = (ConfigTombstone.Client.GraveSkinRule)((Object)ConfigTombstone.client.graveSkinRule.get());
        this.fogDensity = (ConfigTombstone.Client.FogDensity)((Object)ConfigTombstone.client.fogDensity.get());
        this.markerType = (ConfigTombstone.Client.MarkerType)((Object)ConfigTombstone.client.markerType.get());
        this.colorSliderHandler0 = new ColorSliderHandler("particle_casting_color", (Integer)ConfigTombstone.client.particleCastingColor.get(), d -> {
            this.isDirty = d;
        });
        this.colorSliderHandler1 = new ColorSliderHandler("text_color_rip", (Integer)ConfigTombstone.client.textColorRIP.get(), d -> {
            this.isDirty = d;
        });
        this.colorSliderHandler2 = new ColorSliderHandler("text_color_owner", (Integer)ConfigTombstone.client.textColorOwner.get(), d -> {
            this.isDirty = d;
        });
        this.colorSliderHandler3 = new ColorSliderHandler("text_color_death_date", (Integer)ConfigTombstone.client.textColorDeathDate.get(), d -> {
            this.isDirty = d;
        });
        this.colorSliderHandler4 = new ColorSliderHandler("fog_color", (Integer)ConfigTombstone.client.fogColor.get(), d -> {
            this.isDirty = d;
        });
        this.isDirty = true;
        Option[] optionArray = new Option[14];
        optionArray[0] = CycleConfigOption.createOnOff("show_enhanced_tooltips", () -> this.enhanced_tooltips, d -> {
            this.enhanced_tooltips = d;
        }, d -> {
            this.isDirty = d;
        });
        optionArray[1] = CycleConfigOption.createOnOff("skip_respawn_screen", () -> this.skipRespawnScreen, d -> {
            this.skipRespawnScreen = d;
        }, d -> {
            this.isDirty = d;
        });
        optionArray[2] = CycleConfigOption.createOnOff("date_in_mc_time", () -> this.dateInMCTime, d -> {
            this.dateInMCTime = d;
        }, d -> {
            this.isDirty = d;
        });
        optionArray[3] = CycleConfigOption.createOnOff("display_knowledge_message", this.playerPreference::displayKnowledgeMessage, this.playerPreference::setDisplayKnowledgeMessage, d -> {
            this.isDirty = d;
        });
        optionArray[4] = CycleConfigOption.createOnOff("equip_elytra_in_priority", this.playerPreference::equipElytraInPriority, this.playerPreference::setEquipElytraInPriority, d -> {
            this.isDirty = d;
        });
        optionArray[5] = CycleConfigOption.createOnOff("show_info_on_enchantment", () -> this.showInfoOnEnchantment, b -> {
            this.showInfoOnEnchantment = b;
        }, d -> {
            this.isDirty = d;
        });
        optionArray[6] = CycleConfigOption.create("grave_skin_rule", ConfigTombstone.Client.GraveSkinRule.values(), t -> new TextComponent(t.getTranslation()), () -> this.graveSkinRule, b -> {
            this.graveSkinRule = b;
        }, d -> {
            this.isDirty = d;
        });
        optionArray[7] = CycleConfigOption.create("fog_density", ConfigTombstone.Client.FogDensity.values(), t -> new TextComponent(t.getTranslation()), () -> this.fogDensity, b -> {
            this.fogDensity = b;
        }, d -> {
            this.isDirty = d;
        });
        optionArray[8] = CycleConfigOption.createOnOff("priorize_tool_on_hotbar", this.playerPreference::priorizeToolOnHotbar, this.playerPreference::setPriorizeToolOnHotbar, d -> {
            this.isDirty = d;
        });
        optionArray[9] = CycleConfigOption.createOnOff("activate_grave_by_sneaking", this.playerPreference::activateGraveBySneaking, this.playerPreference::setActivateGraveBySneaking, d -> {
            this.isDirty = d;
        });
        optionArray[10] = CycleConfigOption.createOnOff("deny_grave_on_death", this.playerPreference::denyGraveOnDeath, this.playerPreference::setDenyGraveOnDeath, d -> {
            this.isDirty = d;
        });
        optionArray[11] = CycleConfigOption.createOnOff("allow_grave_in_water", this.playerPreference::allowGraveInWater, this.playerPreference::setAllowGraveInWater, d -> {
            this.isDirty = d;
        });
        optionArray[12] = CycleConfigOption.create("grave_spawn_rule", ConfigTombstone.Client.GraveSpawnRule.values(), t -> new TextComponent(t.getTranslation()), this.playerPreference::getGraveSpawnRule, this.playerPreference::setGraveSpawnRule, d -> {
            this.isDirty = d;
        });
        optionArray[13] = CycleConfigOption.create("auto_equip_rule", ConfigTombstone.Client.AutoEquipRule.values(), t -> new TextComponent(t.getTranslation()), this.playerPreference::getAutoEquipRule, this.playerPreference::setAutoEquipRule, d -> {
            this.isDirty = d;
        });
        this.miscOptions = optionArray;
        this.effectOptions = new Option[]{CycleConfigOption.create("marker_type", ConfigTombstone.Client.MarkerType.values(), t -> new TextComponent(t.getTranslation()), () -> this.markerType, b -> {
            this.markerType = b;
        }, d -> {
            this.isDirty = d;
        }), CycleConfigOption.createOnOff("highlight", () -> this.highlightGrave, b -> {
            this.highlightGrave = b;
        }, d -> {
            this.isDirty = d;
        }), CycleConfigOption.createOnOff("show_shadow_step", () -> this.showShadowStep, b -> {
            this.showShadowStep = b;
        }, d -> {
            this.isDirty = d;
        }), CycleConfigOption.createOnOff("show_shield_particle", () -> this.showShieldParticle, b -> {
            this.showShieldParticle = b;
        }, d -> {
            this.isDirty = d;
        }), CycleConfigOption.createOnOff("allow_halloween_ghost", () -> this.allowHalloweenGhost, b -> {
            this.allowHalloweenGhost = b;
        }, d -> {
            this.isDirty = d;
        }), CycleConfigOption.createOnOff("show_magic_circle", () -> this.showMagicCircle, b -> {
            this.showMagicCircle = b;
        }, d -> {
            this.isDirty = d;
        })};
        this.config_changed_predics = new ArrayList<Predicate<Boolean>>(){
            {
                this.add(u -> GuiConfig.this.checkConfig(ConfigTombstone.client.textColorRIP, GuiConfig.this.colorSliderHandler1.getColor(), (boolean)u));
                this.add(u -> GuiConfig.this.checkConfig(ConfigTombstone.client.textColorOwner, GuiConfig.this.colorSliderHandler2.getColor(), (boolean)u));
                this.add(u -> GuiConfig.this.checkConfig(ConfigTombstone.client.textColorDeathDate, GuiConfig.this.colorSliderHandler3.getColor(), (boolean)u));
                this.add(u -> GuiConfig.this.checkConfig(ConfigTombstone.client.showEnhancedTooltips, GuiConfig.this.enhanced_tooltips, (boolean)u));
                this.add(u -> GuiConfig.this.checkConfig(ConfigTombstone.client.highlight, GuiConfig.this.highlightGrave, (boolean)u));
                this.add(u -> GuiConfig.this.checkConfig(ConfigTombstone.client.skipRespawnScreen, GuiConfig.this.skipRespawnScreen, (boolean)u));
                this.add(u -> GuiConfig.this.checkConfig(ConfigTombstone.client.showShadowStep, GuiConfig.this.showShadowStep, (boolean)u));
                this.add(u -> GuiConfig.this.checkConfig(ConfigTombstone.client.showShieldParticle, GuiConfig.this.showShieldParticle, (boolean)u));
                this.add(u -> GuiConfig.this.checkConfig(ConfigTombstone.client.allowHalloweenGhost, GuiConfig.this.allowHalloweenGhost, (boolean)u));
                this.add(u -> GuiConfig.this.checkConfig(ConfigTombstone.client.dateInMCTime, GuiConfig.this.dateInMCTime, (boolean)u));
                this.add(u -> GuiConfig.this.checkConfig(ConfigTombstone.client.showInfoOnEnchantment, GuiConfig.this.showInfoOnEnchantment, (boolean)u));
                this.add(u -> GuiConfig.this.checkConfig(ConfigTombstone.client.graveSkinRule, GuiConfig.this.graveSkinRule, (boolean)u));
                this.add(u -> GuiConfig.this.checkConfig(ConfigTombstone.client.fogDensity, GuiConfig.this.fogDensity, (boolean)u));
                this.add(u -> GuiConfig.this.checkConfig(ConfigTombstone.client.showMagicCircle, GuiConfig.this.showMagicCircle, (boolean)u));
                this.add(u -> GuiConfig.this.checkConfig(ConfigTombstone.client.markerType, GuiConfig.this.markerType, (boolean)u));
                this.add(u -> GuiConfig.this.checkConfig(ConfigTombstone.client.particleCastingColor, GuiConfig.this.colorSliderHandler0.getColor(), (boolean)u));
                this.add(u -> GuiConfig.this.checkConfig(ConfigTombstone.client.fogColor, GuiConfig.this.colorSliderHandler4.getColor(), (boolean)u));
            }
        };
        this.nameToDisplay = Optional.ofNullable(Minecraft.m_91087_().f_91074_).map(p -> p.m_7755_().getString()).orElse(Helper.getRandomThankName());
    }

    public GuiConfig(Minecraft minecraft, Screen screen) {
        this();
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        int posY = 0;
        for (TabConfig currentTab : TabConfig.values()) {
            this.m_142416_((GuiEventListener)new CustomButton(this.guiLeft - 50, this.guiTop + posY, 40, 20, (Component)new TextComponent(currentTab.name()), pressable -> this.switchTab(currentTab)));
            posY += 20;
        }
        this.m_142416_((GuiEventListener)new CustomButton(this.guiLeft - 50, this.guiTop + posY, 40, 20, (Component)new TextComponent("SAVE"), pressable -> this.saveConfig(), () -> this.saveButtonHighlight));
        TabConfig.clear();
        this.miscList = new CustomOptionsRowList(this.guiLeft + 13, this.guiTop + 50, 190, 133, 14, this.miscOptions);
        this.m_7787_((GuiEventListener)this.miscList);
        TabConfig.MISC.attach(this.miscList);
        this.effectList = new CustomOptionsRowList(this.guiLeft + 13, this.guiTop + 50, 190, 77, 14, this.effectOptions);
        this.m_7787_((GuiEventListener)this.effectList);
        this.colorSliderHandler0.createWidget(this.getMinecraft().f_91066_, x$0 -> {
            ColorOptionSlider cfr_ignored_0 = (ColorOptionSlider)this.m_142416_((GuiEventListener)x$0);
        }, this.guiLeft + 100, this.guiTop + 145, 80, 4);
        this.colorSliderHandler4.createWidget(this.getMinecraft().f_91066_, x$0 -> {
            ColorOptionSlider cfr_ignored_0 = (ColorOptionSlider)this.m_142416_((GuiEventListener)x$0);
        }, this.guiLeft + 100, this.guiTop + 170, 80, 4);
        TabConfig.EFFECT.attach(this.effectList, this.colorSliderHandler0, this.colorSliderHandler4);
        TabConfig.GRAVE.attach((AbstractWidget)this.m_142416_((GuiEventListener)new SliderButton(this.getMinecraft().f_91066_, this.guiRight - 10 - 30, this.guiTop + 40, 30, 20, new ProgressOption("texture", 0.0, 1.0, 1.0f, settings -> this.playerPreference.getMarbleType().ordinal(), (settings, d) -> this.playerPreference.setMarbleType(BlockGraveMarble.MarbleType.byId(d.intValue())), (settings, progressOption) -> new TranslatableComponent(this.playerPreference.getMarbleType().m_7912_()), mc -> List.of()), Collections.emptyList()){

            protected void m_5697_() {
                super.m_5697_();
                GuiConfig.this.isDirty = true;
            }
        }));
        TabConfig.GRAVE.attach((AbstractWidget)this.m_142416_((GuiEventListener)new PageButton(this.halfWidth - 23 - 65, this.guiBottom - 25, false, pressable -> {
            this.playerPreference.setFavoriteGrave(this.playerPreference.getFavoriteGrave().getPrevious());
            this.isDirty = true;
        }, true)));
        TabConfig.GRAVE.attach((AbstractWidget)this.m_142416_((GuiEventListener)new PageButton(this.halfWidth + 65, this.guiBottom - 25, true, pressable -> {
            this.playerPreference.setFavoriteGrave(this.playerPreference.getFavoriteGrave().getNext());
            this.isDirty = true;
        }, true)));
        this.colorSliderHandler1.createWidget(this.getMinecraft().f_91066_, x$0 -> {
            ColorOptionSlider cfr_ignored_0 = (ColorOptionSlider)this.m_142416_((GuiEventListener)x$0);
        }, this.guiLeft + 10, this.guiTop + 67, 40, 4);
        this.colorSliderHandler2.createWidget(this.getMinecraft().f_91066_, x$0 -> {
            ColorOptionSlider cfr_ignored_0 = (ColorOptionSlider)this.m_142416_((GuiEventListener)x$0);
        }, this.guiLeft + 10, this.guiTop + 97, 40, 4);
        this.colorSliderHandler3.createWidget(this.getMinecraft().f_91066_, x$0 -> {
            ColorOptionSlider cfr_ignored_0 = (ColorOptionSlider)this.m_142416_((GuiEventListener)x$0);
        }, this.guiLeft + 10, this.guiTop + 131, 40, 4);
        TabConfig.PLATE.attach(this.colorSliderHandler1, this.colorSliderHandler2, this.colorSliderHandler3);
        TabConfig.hideAll();
        this.tab.show();
    }

    private void switchTab(TabConfig tab) {
        if (this.tab != tab) {
            this.tab.hide();
            this.tab = tab;
            this.tab.show();
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.isDirty) {
            this.isDirty = false;
            this.saveButtonHighlight = this.getConfigState(false).isChanged();
        }
        this.m_7333_(poseStack);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Objects.requireNonNull(this.f_96547_);
        GuiConfig.m_93172_((PoseStack)poseStack, (int)(this.guiLeft + 5), (int)(this.guiTop + 5), (int)(this.guiRight - 5), (int)(this.guiTop + 20 + 9), (int)0x55000000);
        Objects.requireNonNull(this);
        GuiConfig.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)this.halfWidth, (int)(this.guiTop + 14), (int)-1);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        switch (this.tab) {
            case GRAVE: {
                ItemStack stack = new ItemStack((ItemLike)ModBlocks.DECORATIVE_GRAVES.get((Object)this.playerPreference.getFavoriteGrave()));
                ItemBlockGrave.setModelTexture(stack, this.playerPreference.getMarbleType().ordinal());
                Component displayName = stack.m_41611_();
                EngravableHelper.setEngravedName(stack, this.nameToDisplay);
                Objects.requireNonNull(this);
                GuiConfig.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)displayName, (int)this.halfWidth, (int)(this.guiBottom - 55), (int)-1);
                GuiConfig.m_93172_((PoseStack)poseStack, (int)(this.guiLeft + 5), (int)(this.guiTop + 35), (int)(this.guiRight - 5), (int)(this.guiBottom - 42), (int)0x50000000);
                Helper.renderStackInGui(stack, this.guiLeft + 40, this.guiTop + 32, 6.0f, true);
                break;
            }
            case PLATE: {
                RenderSystem.m_157456_((int)0, (ResourceLocation)tablet);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GuiConfig.m_93133_((PoseStack)poseStack, (int)(this.guiLeft + 46), (int)(this.guiTop + 36), (float)0.0f, (float)0.0f, (int)154, (int)154, (int)154, (int)154);
                int textPos = this.halfWidth + 24;
                GuiConfig.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)new TextComponent("R.I.P.").m_130940_(ChatFormatting.BOLD), (int)textPos, (int)(this.guiTop + 70), (int)this.colorSliderHandler1.getColor());
                GuiConfig.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)new TextComponent(this.nameToDisplay).m_130940_(ChatFormatting.BOLD), (int)textPos, (int)(this.guiTop + 100), (int)this.colorSliderHandler2.getColor());
                GuiConfig.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)new TextComponent("Hasn't died yet").m_130940_(ChatFormatting.ITALIC), (int)textPos, (int)(this.guiTop + 130), (int)this.colorSliderHandler3.getColor());
                GuiConfig.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)new TextComponent("but will soon").m_130940_(ChatFormatting.ITALIC), (int)textPos, (int)(this.guiTop + 140), (int)this.colorSliderHandler3.getColor());
                break;
            }
            case MISC: {
                Objects.requireNonNull(this);
                GuiConfig.m_93172_((PoseStack)poseStack, (int)(this.guiLeft + 5), (int)(this.guiTop + 35), (int)(this.guiLeft + 200 - 5), (int)(this.guiTop + 194), (int)0x55000000);
                this.miscList.m_6305_(poseStack, mouseX, mouseY, partialTicks);
                break;
            }
            case EFFECT: {
                Objects.requireNonNull(this);
                GuiConfig.m_93172_((PoseStack)poseStack, (int)(this.guiLeft + 5), (int)(this.guiTop + 35), (int)(this.guiLeft + 200 - 5), (int)(this.guiTop + 194), (int)0x55000000);
                this.effectList.m_6305_(poseStack, mouseX, mouseY, partialTicks);
                GuiConfig.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.colorSliderHandler0.getTitle(), (int)(this.guiLeft + 20), (int)(this.guiTop + 149), (int)this.colorSliderHandler0.getColor());
                GuiConfig.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.colorSliderHandler4.getTitle(), (int)(this.guiLeft + 20), (int)(this.guiTop + 174), (int)this.colorSliderHandler4.getColor());
            }
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    private ConfigState getConfigState(boolean update) {
        if (!update) {
            return this.playerPreference.hasChangedFromConfig() || this.config_changed_predics.stream().anyMatch(p -> p.test(false)) ? ConfigState.CHANGED : ConfigState.UNCHANGED;
        }
        long countChanged = this.config_changed_predics.stream().filter(p -> p.test(true)).count();
        boolean requirePacket = this.playerPreference.hasChangedFromConfig();
        if (requirePacket) {
            this.playerPreference.updateClientConfig();
        }
        return requirePacket ? ConfigState.REQUIRED_PACKET : (countChanged > 0L ? ConfigState.CHANGED : ConfigState.UNCHANGED);
    }

    private void saveConfig() {
        ConfigState result;
        if (this.saveButtonHighlight && (result = this.getConfigState(true)).isChanged()) {
            ConfigTombstone.CLIENT_SPEC.save();
            if (result.requirePacket()) {
                ModTombstone.PROXY.markConfigDirty();
            }
        }
        this.m_7379_();
    }

    private <T> boolean checkConfig(ForgeConfigSpec.ConfigValue<T> config, T newValue, boolean update) {
        if (!newValue.equals(config.get())) {
            if (update) {
                config.set(newValue);
            }
            return true;
        }
        return false;
    }

    static enum TabConfig implements IHideable
    {
        GRAVE,
        PLATE,
        MISC,
        EFFECT;

        final List<IHideable> hideables = new ArrayList<IHideable>();

        void attach(IHideable ... theHideables) {
            this.hideables.addAll(Arrays.asList(theHideables));
        }

        void attach(final AbstractWidget button) {
            this.hideables.add(new IHideable(){

                @Override
                public void show() {
                    button.f_93624_ = true;
                    button.f_93623_ = true;
                }

                @Override
                public void hide() {
                    button.f_93624_ = false;
                    button.f_93623_ = false;
                }
            });
        }

        @Override
        public void show() {
            for (IHideable hideable : this.hideables) {
                hideable.show();
            }
        }

        @Override
        public void hide() {
            for (IHideable hideable : this.hideables) {
                hideable.hide();
            }
        }

        static void hideAll() {
            for (TabConfig tab : TabConfig.values()) {
                tab.hide();
            }
        }

        static void clear() {
            for (TabConfig tab : TabConfig.values()) {
                tab.hideables.clear();
            }
        }
    }

    public static interface IHideable {
        public void show();

        public void hide();
    }

    static enum ConfigState {
        UNCHANGED,
        CHANGED,
        REQUIRED_PACKET;


        boolean isChanged() {
            return this != UNCHANGED;
        }

        boolean requirePacket() {
            return this == REQUIRED_PACKET;
        }
    }
}

