/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.gui.CustomButton;
import ovh.corail.tombstone.gui.TBScreen;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.item.ItemAdvancement;
import ovh.corail.tombstone.item.ItemScrollBuff;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModItems;

@OnlyIn(value=Dist.CLIENT)
public class GuiInfo
extends TBScreen {
    private static final Component DEFAULT_TITLE = new TranslatableComponent("tombstone.compendium.main.title");
    private static final Component DEFAULT_DESCRIPTION = new TranslatableComponent("tombstone.compendium.main.desc");
    private Info currentInfo;
    private Info lastInfo;
    private Info hoveredInfo = null;
    private int linesByPage;
    private int pageCount;
    private int currentPage;
    private final List<FormattedCharSequence> contentLines = new ArrayList<FormattedCharSequence>();
    private final List<InfoLink> infoLinks = new ArrayList<InfoLink>();
    private ItemStack icon;
    private Button pageLeft;
    private Button pageRight;

    GuiInfo(@Nullable Info currentInfo) {
        super(DEFAULT_TITLE);
        this.currentInfo = this.lastInfo = currentInfo;
        this.currentPage = 0;
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (super.m_6375_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (mouseButton == 0 && this.hoveredInfo != null) {
            this.currentInfo = this.hoveredInfo;
            return true;
        }
        return false;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new CustomButton(this.halfWidth - 35, this.guiBottom - 25, 70, 15, (Component)LangKey.MESSAGE_BACK.getText(new Object[0]), pressable -> {
            if (this.currentInfo == null) {
                this.getThePlayer().m_6915_();
            } else {
                this.currentInfo = null;
            }
        }));
        this.pageLeft = new PageButton(this.halfWidth - 23 - 65, this.guiBottom - 25, false, pressable -> {
            --this.currentPage;
            this.updateButtons();
        }, true);
        this.m_142416_((GuiEventListener)this.pageLeft);
        this.pageRight = new PageButton(this.halfWidth + 65, this.guiBottom - 25, true, pressable -> {
            ++this.currentPage;
            this.updateButtons();
        }, true);
        this.m_142416_((GuiEventListener)this.pageRight);
        this.updatePage(this.currentInfo);
    }

    private void updateContent(@Nullable Info currentInfo) {
        List<Info> infos;
        this.contentLines.clear();
        this.infoLinks.clear();
        this.icon = currentInfo == null ? new ItemStack((ItemLike)ModBlocks.DECORATIVE_GRAVES.get((Object)GraveModel.TOMBSTONE)) : currentInfo.icon.get();
        Component content = Optional.ofNullable(currentInfo).map(Info::getContent).orElse(DEFAULT_DESCRIPTION);
        Objects.requireNonNull(this);
        this.contentLines.addAll(this.f_96547_.m_92923_((FormattedText)content, 200 - 15));
        Objects.requireNonNull(this);
        int x = this.guiLeft + 200 + 5;
        int y = this.guiTop + 10;
        if (currentInfo == null) {
            infos = Arrays.stream(Info.values()).filter(p -> p.isMainEntry).collect(Collectors.toList());
        } else {
            infos = Info.getRelated(currentInfo);
            infos.sort(Comparator.comparing(p -> Normalizer.normalize(p.getTitle().getString(), Normalizer.Form.NFD)));
        }
        for (Info info : infos) {
            this.infoLinks.add(new InfoLink(info, x, y));
            Objects.requireNonNull(this.f_96547_);
            y += 9 + 1;
        }
    }

    private void updatePage(@Nullable Info currentInfo) {
        if (this.lastInfo != currentInfo) {
            this.currentPage = 0;
        }
        this.lastInfo = currentInfo;
        this.updateContent(currentInfo);
        this.linesByPage = 12;
        this.pageCount = Mth.m_14167_((float)((float)this.contentLines.size() / (float)this.linesByPage));
        this.updateButtons();
    }

    private void updateButtons() {
        this.pageLeft.f_93624_ = this.currentPage > 0;
        this.pageLeft.f_93623_ = this.pageLeft.f_93624_;
        this.pageRight.f_93624_ = this.currentPage < this.pageCount - 1;
        this.pageRight.f_93623_ = this.pageRight.f_93624_;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        this.hoveredInfo = null;
        if (this.currentInfo != this.lastInfo) {
            this.updatePage(this.currentInfo);
        }
        Objects.requireNonNull(this);
        Objects.requireNonNull(this.f_96547_);
        GuiInfo.m_93172_((PoseStack)poseStack, (int)(this.guiLeft + 5), (int)(this.guiTop + 5), (int)(this.guiLeft + 200 - 5), (int)(this.guiTop + 20 + 9), (int)0x55000000);
        float f = this.guiLeft + 30;
        float f2 = this.guiTop + 15;
        Objects.requireNonNull(this);
        this.f_96547_.m_92889_(poseStack, Optional.ofNullable(this.currentInfo).map(Info::getTitle).orElse(DEFAULT_TITLE), f, f2, -1);
        if (this.currentInfo != null) {
            String string = this.currentPage + 1 + "/" + this.pageCount;
            Objects.requireNonNull(this);
            float f3 = this.guiLeft + 200 - 30;
            float f4 = this.guiTop + 6;
            Objects.requireNonNull(this);
            this.f_96547_.m_92883_(poseStack, string, f3, f4, -1);
        }
        if (!this.icon.m_41619_()) {
            Objects.requireNonNull(this.f_96547_);
            Objects.requireNonNull(this.f_96547_);
            GuiInfo.m_93172_((PoseStack)poseStack, (int)(this.guiLeft + 6), (int)(this.guiTop + 6), (int)(this.guiLeft + 19 + 9), (int)(this.guiTop + 19 + 9), (int)-16760736);
            Objects.requireNonNull(this.f_96547_);
            Objects.requireNonNull(this.f_96547_);
            GuiInfo.m_93172_((PoseStack)poseStack, (int)(this.guiLeft + 7), (int)(this.guiTop + 7), (int)(this.guiLeft + 18 + 9), (int)(this.guiTop + 18 + 9), (int)-2130706433);
            this.f_96542_.m_115203_(this.icon, this.guiLeft + 9, this.guiTop + 9);
        }
        int indexStart = Math.min(this.currentPage * this.linesByPage, this.contentLines.size() - 1);
        int indexEnd = Math.min(indexStart + this.linesByPage - 1, this.contentLines.size() - 1);
        if (indexStart >= 0) {
            Objects.requireNonNull(this);
            Objects.requireNonNull(this.f_96547_);
            GuiInfo.m_93172_((PoseStack)poseStack, (int)(this.guiLeft + 5), (int)(this.guiTop + 34), (int)(this.guiLeft + 200 - 5), (int)(this.guiTop + 44 + (9 + 1) * (indexEnd - indexStart + 1)), (int)0x55000000);
            int count = 0;
            for (int i = indexStart; i <= indexEnd; ++i) {
                FormattedCharSequence line = this.contentLines.get(i);
                float f5 = this.guiLeft + 10;
                Objects.requireNonNull(this.f_96547_);
                float f6 = this.guiTop + 39 + count * (9 + 1);
                Objects.requireNonNull(this);
                this.f_96547_.m_92744_(poseStack, line, f5, f6, -1);
                ++count;
            }
        }
        for (InfoLink link : this.infoLinks) {
            if (this.hoveredInfo == null && link.isHovered(mouseX, mouseY)) {
                this.hoveredInfo = link.info;
                this.f_96547_.m_92889_(poseStack, link.info.getTitle(), (float)link.x, (float)link.y, -1875);
                continue;
            }
            Component component = link.info.getTitle();
            float f7 = link.x;
            float f8 = link.y;
            Objects.requireNonNull(this);
            this.f_96547_.m_92889_(poseStack, component, f7, f8, -1);
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    static enum Info {
        DEATH(ItemAdvancement.IconType.FIRST_KNOWLEDGE::getItemStack, true),
        DECORATIVE_GRAVE(() -> new ItemStack((ItemLike)ModBlocks.DECORATIVE_GRAVES.get((Object)GraveModel.GRAVE_SIMPLE)), true, "tombstone.config_cat.decorative_grave"),
        MAGIC_ITEMS(ItemAdvancement.IconType.TELEPORT_TO_GRAVE::getItemStack, true),
        ENCHANTMENTS(() -> new ItemStack((ItemLike)Items.f_42690_), true),
        KNOWLEDGE_OF_DEATH(() -> new ItemStack((ItemLike)ModItems.ankh_of_pray), true, "tombstone.message.knowledge_of_death"),
        SPECIAL_BONUS(() -> ItemStack.f_41583_, true),
        SHADOW_STEP(() -> new ItemStack((ItemLike)Items.f_42690_), false),
        SOULBOUND(() -> new ItemStack((ItemLike)Items.f_42690_), false),
        MAGIC_SIPHON(() -> new ItemStack((ItemLike)Items.f_42690_), false),
        PLAGUE_BRINGER(() -> new ItemStack((ItemLike)Items.f_42690_), false),
        CURSE_OF_BONES(() -> new ItemStack((ItemLike)Items.f_42690_), false),
        BLESSING(() -> new ItemStack((ItemLike)Items.f_42690_), false),
        FROSTBITE(() -> new ItemStack((ItemLike)Items.f_42690_), false),
        ALIGNMENT(ItemAdvancement.IconType.REVIVE::getItemStack, false),
        ANKH_OF_PRAY(() -> new ItemStack((ItemLike)ModItems.ankh_of_pray), false, "tombstone.item.ankh_of_pray"),
        BONE_NEEDLE(() -> new ItemStack((ItemLike)ModItems.bone_needle), false, "tombstone.item.bone_needle"),
        BOOK_OF_DISENCHANTMENT(() -> new ItemStack((ItemLike)ModItems.book_of_disenchantment), false, "tombstone.item.book_of_disenchantment"),
        BOOK_OF_RECYCLING(() -> new ItemStack((ItemLike)ModItems.book_of_recycling), false, "tombstone.item.book_of_recycling"),
        BOOK_OF_REPAIRING(() -> new ItemStack((ItemLike)ModItems.book_of_repairing), false, "tombstone.item.book_of_repairing"),
        BOOK_OF_MAGIC_IMPREGNATION(() -> new ItemStack((ItemLike)ModItems.book_of_magic_impregnation), false, "tombstone.item.book_of_magic_impregnation"),
        ENCHANTED_BUNDLE(() -> new ItemStack((ItemLike)ModItems.enchanted_bundle), false, "tombstone.item.enchanted_bundle"),
        GRAVE_MARBLE(() -> new ItemStack((ItemLike)ModBlocks.dark_marble), false, "tombstone.block.dark_marble"),
        DUST_OF_VANISHING(() -> new ItemStack((ItemLike)ModItems.dust_of_vanishing), false, "tombstone.item.dust_of_vanishing"),
        DUST_OF_FROST(() -> new ItemStack((ItemLike)ModItems.dust_of_frost), false, "tombstone.item.dust_of_frost"),
        ESSENCE_OF_UNDEATH(() -> new ItemStack((ItemLike)ModItems.essence_of_undeath), false, "tombstone.item.essence_of_undeath"),
        FAMILIAR_RECEPTACLE(() -> new ItemStack((ItemLike)ModItems.familiar_receptacle), false, "tombstone.item.familiar_receptacle"),
        FISHING_ROD_OF_MISADVENTURE(() -> new ItemStack((ItemLike)ModItems.fishing_rod_of_misadventure), false, "tombstone.item.fishing_rod_of_misadventure"),
        GHOSTLY_SHAPE(ItemAdvancement.IconType.CANCEL_GHOSTLY_SHAPE::getItemStack, false, "effect.tombstone.ghostly_shape"),
        GRAVE_DUST(() -> new ItemStack((ItemLike)ModItems.grave_dust), false, "tombstone.item.grave_dust"),
        GRAVE_KEY(() -> new ItemStack((ItemLike)ModItems.grave_key), false, "tombstone.item.grave_key"),
        GRAVE_PLATE(() -> EngravableHelper.setEngravedName(new ItemStack((ItemLike)ModItems.grave_plate), "named"), false, "tombstone.item.grave_plate"),
        HALLOWEEN(ItemAdvancement.IconType.GHOST::getItemStack, false),
        IMPREGNATED_DIAMOND(() -> new ItemStack((ItemLike)ModItems.impregnated_diamond), false, "tombstone.item.impregnated_diamond"),
        LOLLIPOP(() -> new ItemStack((ItemLike)ModItems.lollipop), false, "tombstone.item.lollipop"),
        LOST_TABLET(() -> new ItemStack((ItemLike)ModItems.lost_tablet), false, "tombstone.item.lost_tablet"),
        PERK(() -> ItemStack.f_41583_, false),
        SCROLL_OF_FEATHER_FALL(() -> new ItemStack((ItemLike)ItemScrollBuff.SpellBuff.FEATHER_FALL.getItem()), false, "tombstone.item.scroll_of_feather_fall"),
        SCROLL_OF_KNOWLEDGE(() -> new ItemStack((ItemLike)ModItems.scroll_of_knowledge), false, "tombstone.item.scroll_of_knowledge"),
        SCROLL_OF_PRESERVATION(() -> new ItemStack((ItemLike)ItemScrollBuff.SpellBuff.PRESERVATION.getItem()), false, "tombstone.item.scroll_of_preservation"),
        SCROLL_OF_PURIFICATION(() -> new ItemStack((ItemLike)ItemScrollBuff.SpellBuff.PURIFICATION.getItem()), false, "tombstone.item.scroll_of_purification"),
        SCROLL_OF_TRUE_SIGHT(() -> new ItemStack((ItemLike)ItemScrollBuff.SpellBuff.TRUE_SIGHT.getItem()), false, "tombstone.item.scroll_of_true_sight"),
        SCROLL_OF_UNSTABLE_INTANGIBILITY(() -> new ItemStack((ItemLike)ItemScrollBuff.SpellBuff.UNSTABLE_INTANGIBILITY.getItem()), false, "tombstone.item.scroll_of_unstable_intangibility"),
        SCROLL_OF_REACH(() -> new ItemStack((ItemLike)ItemScrollBuff.SpellBuff.REACH.getItem()), false, "tombstone.item.scroll_of_reach"),
        SCROLL_OF_LIGHTNING_RESISTANCE(() -> new ItemStack((ItemLike)ItemScrollBuff.SpellBuff.LIGHTNING_RESISTANCE.getItem()), false, "tombstone.item.scroll_of_lightning_resistance"),
        SCROLL_OF_FROST_RESISTANCE(() -> new ItemStack((ItemLike)ItemScrollBuff.SpellBuff.FROST_RESISTANCE.getItem()), false, "tombstone.item.scroll_of_frost_resistance"),
        SCROLL_OF_AQUATIC_LIFE(() -> new ItemStack((ItemLike)ItemScrollBuff.SpellBuff.AQUATIC_LIFE.getItem()), false, "tombstone.item.scroll_of_aquatic_life"),
        MAGIC_SCROLLS(() -> new ItemStack((ItemLike)ModItems.strange_scroll), false),
        GRAVE_GUARDIAN(() -> new ItemStack((ItemLike)Items.f_42678_), false, "entity.tombstone.grave_guardian"),
        SOUL(ItemAdvancement.IconType.ACTIVATE_MAGIC_ITEM::getItemStack, false),
        SOUL_RECEPTACLE(() -> new ItemStack((ItemLike)ModItems.soul_receptacle), false, "tombstone.item.soul_receptacle"),
        STRANGE_SCROLL(() -> new ItemStack((ItemLike)ModItems.strange_scroll), false, "tombstone.item.strange_scroll"),
        STRANGE_TABLET(() -> new ItemStack((ItemLike)ModItems.strange_tablet), false, "tombstone.item.strange_tablet"),
        TABLET_OF_HOME(() -> new ItemStack((ItemLike)ModItems.tablet_of_home), false, "tombstone.item.tablet_of_home"),
        TABLET_OF_RECALL(() -> new ItemStack((ItemLike)ModItems.tablet_of_recall), false, "tombstone.item.tablet_of_recall"),
        TABLET_OF_ASSISTANCE(() -> new ItemStack((ItemLike)ModItems.tablet_of_assistance), false, "tombstone.item.tablet_of_assistance"),
        TABLET_OF_CUPIDITY(() -> new ItemStack((ItemLike)ModItems.tablet_of_cupidity), false, "tombstone.item.tablet_of_cupidity"),
        MAGIC_TABLETS(() -> new ItemStack((ItemLike)ModItems.strange_tablet), false),
        VOODOO_POPPET(() -> new ItemStack((ItemLike)ModItems.voodoo_poppet), false, "tombstone.item.voodoo_poppet");

        private final Supplier<ItemStack> icon;
        private final boolean isMainEntry;
        private final Component title;
        private final Component description;

        private Info(Supplier<ItemStack> icon, boolean isMainEntry) {
            this(icon, isMainEntry, null);
        }

        private Info(@Nullable Supplier<ItemStack> icon, boolean isMainEntry, String titleKey) {
            this.icon = icon;
            this.isMainEntry = isMainEntry;
            this.title = new TranslatableComponent((String)(titleKey == null ? "tombstone.compendium." + this.name().toLowerCase(Locale.US) + ".title" : titleKey));
            this.description = new TranslatableComponent("tombstone.compendium." + this.name().toLowerCase(Locale.US) + ".desc");
        }

        public final Component getTitle() {
            return this.title;
        }

        public final Component getContent() {
            return this.description;
        }

        public static List<Info> getRelated(Info info) {
            ArrayList<Info> infos = new ArrayList<Info>();
            switch (info) {
                case ALIGNMENT: {
                    infos.add(KNOWLEDGE_OF_DEATH);
                    infos.add(ANKH_OF_PRAY);
                    break;
                }
                case ANKH_OF_PRAY: {
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(FAMILIAR_RECEPTACLE);
                    infos.add(KNOWLEDGE_OF_DEATH);
                    infos.add(MAGIC_ITEMS);
                    infos.add(PERK);
                    infos.add(SOUL);
                    infos.add(ALIGNMENT);
                    break;
                }
                case BONE_NEEDLE: {
                    infos.add(GRAVE_DUST);
                    infos.add(IMPREGNATED_DIAMOND);
                    infos.add(FAMILIAR_RECEPTACLE);
                    break;
                }
                case BOOK_OF_DISENCHANTMENT: {
                    infos.add(MAGIC_ITEMS);
                    infos.add(SOUL);
                    infos.add(PERK);
                    break;
                }
                case HALLOWEEN: {
                    infos.add(LOLLIPOP);
                    infos.add(SPECIAL_BONUS);
                    break;
                }
                case GRAVE_MARBLE: {
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(GRAVE_DUST);
                    break;
                }
                case DEATH: {
                    infos.add(GHOSTLY_SHAPE);
                    infos.add(GRAVE_KEY);
                    infos.add(PERK);
                    break;
                }
                case DECORATIVE_GRAVE: {
                    infos.add(GRAVE_MARBLE);
                    infos.add(MAGIC_ITEMS);
                    infos.add(SOUL);
                    infos.add(GRAVE_PLATE);
                    infos.add(ESSENCE_OF_UNDEATH);
                    infos.add(GRAVE_GUARDIAN);
                    break;
                }
                case DUST_OF_VANISHING: 
                case DUST_OF_FROST: {
                    infos.add(GRAVE_DUST);
                    infos.add(MAGIC_ITEMS);
                    break;
                }
                case ENCHANTMENTS: {
                    infos.add(SHADOW_STEP);
                    infos.add(SOULBOUND);
                    infos.add(MAGIC_SIPHON);
                    infos.add(PLAGUE_BRINGER);
                    infos.add(CURSE_OF_BONES);
                    infos.add(BLESSING);
                    infos.add(FROSTBITE);
                    break;
                }
                case SHADOW_STEP: 
                case SOULBOUND: 
                case MAGIC_SIPHON: 
                case PLAGUE_BRINGER: 
                case CURSE_OF_BONES: 
                case BLESSING: 
                case FROSTBITE: {
                    infos.add(ENCHANTMENTS);
                    break;
                }
                case ESSENCE_OF_UNDEATH: 
                case GRAVE_PLATE: 
                case GRAVE_GUARDIAN: {
                    infos.add(DECORATIVE_GRAVE);
                    break;
                }
                case FAMILIAR_RECEPTACLE: {
                    infos.add(ANKH_OF_PRAY);
                    infos.add(IMPREGNATED_DIAMOND);
                    infos.add(KNOWLEDGE_OF_DEATH);
                    infos.add(MAGIC_ITEMS);
                    infos.add(SOUL);
                    infos.add(BONE_NEEDLE);
                    break;
                }
                case FISHING_ROD_OF_MISADVENTURE: {
                    infos.add(LOST_TABLET);
                    infos.add(MAGIC_ITEMS);
                    infos.add(SOUL);
                    break;
                }
                case GHOSTLY_SHAPE: {
                    infos.add(DEATH);
                    break;
                }
                case GRAVE_DUST: {
                    infos.add(GRAVE_MARBLE);
                    infos.add(DUST_OF_VANISHING);
                    infos.add(DUST_OF_FROST);
                    infos.add(IMPREGNATED_DIAMOND);
                    infos.add(BONE_NEEDLE);
                    break;
                }
                case GRAVE_KEY: {
                    infos.add(DEATH);
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(MAGIC_ITEMS);
                    infos.add(SOUL);
                    break;
                }
                case KNOWLEDGE_OF_DEATH: {
                    infos.add(ALIGNMENT);
                    infos.add(ANKH_OF_PRAY);
                    infos.add(FAMILIAR_RECEPTACLE);
                    infos.add(SOUL);
                    infos.add(SOUL_RECEPTACLE);
                    break;
                }
                case IMPREGNATED_DIAMOND: {
                    infos.add(GRAVE_DUST);
                    infos.add(FAMILIAR_RECEPTACLE);
                    infos.add(BONE_NEEDLE);
                    break;
                }
                case LOLLIPOP: {
                    infos.add(HALLOWEEN);
                    infos.add(MAGIC_ITEMS);
                    break;
                }
                case LOST_TABLET: {
                    infos.add(FISHING_ROD_OF_MISADVENTURE);
                    infos.add(MAGIC_TABLETS);
                    infos.add(PERK);
                    infos.add(SOUL);
                    break;
                }
                case MAGIC_ITEMS: {
                    infos.add(ANKH_OF_PRAY);
                    infos.add(BOOK_OF_DISENCHANTMENT);
                    infos.add(BOOK_OF_RECYCLING);
                    infos.add(BOOK_OF_REPAIRING);
                    infos.add(BOOK_OF_MAGIC_IMPREGNATION);
                    infos.add(DUST_OF_VANISHING);
                    infos.add(DUST_OF_FROST);
                    infos.add(ENCHANTED_BUNDLE);
                    infos.add(FAMILIAR_RECEPTACLE);
                    infos.add(FISHING_ROD_OF_MISADVENTURE);
                    infos.add(GRAVE_KEY);
                    infos.add(LOLLIPOP);
                    infos.add(MAGIC_SCROLLS);
                    infos.add(MAGIC_TABLETS);
                    infos.add(SOUL_RECEPTACLE);
                    infos.add(VOODOO_POPPET);
                    break;
                }
                case MAGIC_SCROLLS: {
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(PERK);
                    infos.add(SOUL);
                    infos.add(STRANGE_SCROLL);
                    infos.add(SCROLL_OF_AQUATIC_LIFE);
                    infos.add(SCROLL_OF_FEATHER_FALL);
                    infos.add(SCROLL_OF_FROST_RESISTANCE);
                    infos.add(SCROLL_OF_KNOWLEDGE);
                    infos.add(SCROLL_OF_LIGHTNING_RESISTANCE);
                    infos.add(SCROLL_OF_PRESERVATION);
                    infos.add(SCROLL_OF_PURIFICATION);
                    infos.add(SCROLL_OF_REACH);
                    infos.add(SCROLL_OF_TRUE_SIGHT);
                    infos.add(SCROLL_OF_UNSTABLE_INTANGIBILITY);
                    break;
                }
                case STRANGE_SCROLL: {
                    infos.add(GRAVE_DUST);
                    infos.add(MAGIC_SCROLLS);
                    break;
                }
                case STRANGE_TABLET: {
                    infos.add(GRAVE_MARBLE);
                    infos.add(GRAVE_DUST);
                    infos.add(MAGIC_TABLETS);
                    break;
                }
                case MAGIC_TABLETS: {
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(PERK);
                    infos.add(SOUL);
                    infos.add(STRANGE_TABLET);
                    infos.add(LOST_TABLET);
                    infos.add(TABLET_OF_ASSISTANCE);
                    infos.add(TABLET_OF_CUPIDITY);
                    infos.add(TABLET_OF_HOME);
                    infos.add(TABLET_OF_RECALL);
                    break;
                }
                case PERK: {
                    infos.add(DEATH);
                    infos.add(GHOSTLY_SHAPE);
                    infos.add(KNOWLEDGE_OF_DEATH);
                    infos.add(MAGIC_ITEMS);
                    break;
                }
                case SCROLL_OF_FEATHER_FALL: 
                case SCROLL_OF_KNOWLEDGE: 
                case SCROLL_OF_PRESERVATION: 
                case SCROLL_OF_PURIFICATION: 
                case SCROLL_OF_TRUE_SIGHT: 
                case SCROLL_OF_REACH: 
                case SCROLL_OF_LIGHTNING_RESISTANCE: 
                case SCROLL_OF_FROST_RESISTANCE: 
                case SCROLL_OF_UNSTABLE_INTANGIBILITY: 
                case SCROLL_OF_AQUATIC_LIFE: {
                    infos.add(MAGIC_SCROLLS);
                    infos.add(SOUL);
                    break;
                }
                case SOUL: {
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(KNOWLEDGE_OF_DEATH);
                    infos.add(MAGIC_ITEMS);
                    infos.add(SOUL_RECEPTACLE);
                    break;
                }
                case SOUL_RECEPTACLE: {
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(KNOWLEDGE_OF_DEATH);
                    infos.add(MAGIC_ITEMS);
                    infos.add(SOUL);
                    break;
                }
                case SPECIAL_BONUS: {
                    infos.add(HALLOWEEN);
                    break;
                }
                case TABLET_OF_ASSISTANCE: 
                case TABLET_OF_CUPIDITY: 
                case TABLET_OF_HOME: 
                case TABLET_OF_RECALL: {
                    infos.add(MAGIC_TABLETS);
                    infos.add(SOUL);
                    break;
                }
                case VOODOO_POPPET: 
                case BOOK_OF_RECYCLING: 
                case BOOK_OF_REPAIRING: 
                case BOOK_OF_MAGIC_IMPREGNATION: 
                case ENCHANTED_BUNDLE: {
                    infos.add(MAGIC_ITEMS);
                    infos.add(SOUL);
                }
            }
            return infos;
        }
    }

    public class InfoLink {
        private final Info info;
        private final int x;
        private final int y;
        private final int width;
        private final int height;

        InfoLink(Info info, int x, int y) {
            this.info = info;
            this.x = x;
            this.y = y;
            this.width = GuiInfo.this.f_96547_.m_92852_((FormattedText)info.getTitle());
            Objects.requireNonNull(GuiInfo.this.f_96547_);
            this.height = 9 + 1;
        }

        private boolean isHovered(int mouseX, int mouseY) {
            return mouseX >= this.x && mouseY >= this.y && mouseX <= this.x + this.width & mouseY <= this.y + this.height;
        }
    }
}

