/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModEffects;

public class EffectHelper {
    private static final Method METHOD_ON_EFFECT_REMOVED = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"m_7285_", (Class[])new Class[]{MobEffectInstance.class});
    private static final Function<Random, Integer> RANDOM_EFFECT_LEVEL = random -> {
        int roll = random.nextInt(100) + 1;
        return roll < 10 ? 4 : (roll < 25 ? 3 : (roll < 45 ? 2 : (roll < 70 ? 1 : 0)));
    };

    public static int getDuration(@Nullable LivingEntity entity, @Nullable MobEffect effect) {
        MobEffectInstance effectInstance;
        return entity != null && effect != null && (effectInstance = entity.m_21124_(effect)) != null ? effectInstance.f_19503_ : 0;
    }

    public static boolean isPotionActive(@Nullable LivingEntity entity, @Nullable MobEffect effect) {
        return EffectHelper.getDuration(entity, effect) > 0;
    }

    public static boolean isPotionActive(@Nullable LivingEntity entity, @Nullable MobEffect effect, int amplifier) {
        MobEffectInstance effectInstance;
        return entity != null && effect != null && (effectInstance = entity.m_21124_(effect)) != null && effectInstance.f_19504_ >= amplifier && effectInstance.f_19503_ > 0;
    }

    public static boolean isUnstableIntangibilityActive(@Nullable LivingEntity player) {
        return TimeHelper.inIntervalAfter(EffectHelper.getDuration(player, ModEffects.unstable_intangibility), 100, 79);
    }

    public static void capDuration(LivingEntity entity, MobEffect effect, int maxDuration) {
        MobEffectInstance effectInstance = (MobEffectInstance)entity.m_21221_().get(effect);
        if (EffectHelper.capEffect(effectInstance, maxDuration)) {
            EffectHelper.clearEffect(entity, effect);
            EffectHelper.addEffect(entity, effectInstance);
        }
    }

    private static boolean capEffect(@Nullable MobEffectInstance effectInstance, int maxDuration) {
        if (effectInstance == null) {
            return false;
        }
        if (effectInstance.f_19503_ < maxDuration) {
            return EffectHelper.capEffect(effectInstance.f_19510_, maxDuration);
        }
        effectInstance.f_19503_ = maxDuration;
        effectInstance.f_19510_ = null;
        return true;
    }

    public static void addEffect(@Nullable LivingEntity entity, @Nullable MobEffect effect, int duration) {
        EffectHelper.addEffect(entity, effect, duration, 0, new boolean[0]);
    }

    public static void addEffect(@Nullable LivingEntity entity, @Nullable MobEffect effect, int duration, int amplifier, boolean ... params) {
        if (entity != null && effect != null) {
            entity.m_7292_(new MobEffectInstance(effect, duration, amplifier, params.length == 0 || params[0], params.length <= 1 || params[1]));
        }
    }

    public static void addEffect(@Nullable LivingEntity entity, @Nullable MobEffectInstance effectInstance) {
        if (entity != null && effectInstance != null && effectInstance.m_19544_() != null) {
            entity.m_7292_(effectInstance);
        }
    }

    public static boolean isPotionHidden(@Nullable LivingEntity entity, @Nullable MobEffect effect) {
        MobEffectInstance effectInstance;
        return entity != null && effect != null && (effectInstance = entity.m_21124_(effect)) != null && effectInstance.m_19571_() && !effectInstance.m_19572_();
    }

    public static MobEffectInstance copyEffectWithHidden(MobEffectInstance effectInstance) {
        MobEffectInstance effectCopy = new MobEffectInstance(effectInstance);
        if (effectInstance.f_19510_ != null) {
            effectCopy.f_19510_ = EffectHelper.copyEffectWithHidden(effectInstance.f_19510_);
        }
        return effectCopy;
    }

    public static void modifyEffectDuration(MobEffectInstance effectInstance, Function<MobEffectInstance, Integer> function) {
        effectInstance.f_19503_ = function.apply(effectInstance);
        if (effectInstance.f_19510_ != null) {
            EffectHelper.modifyEffectDuration(effectInstance.f_19510_, function);
        }
    }

    public static boolean clearEffect(@Nullable LivingEntity entity, MobEffect effect) {
        MobEffectInstance effectInstance;
        if (entity != null && !entity.f_19853_.m_5776_() && (effectInstance = entity.m_6234_(effect)) != null) {
            try {
                METHOD_ON_EFFECT_REMOVED.invoke((Object)entity, effectInstance);
                return true;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private static void clearEffect(LivingEntity entity, Predicate<MobEffect> predic) {
        if (!entity.f_19853_.m_5776_()) {
            Iterator it = entity.m_21221_().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!predic.test((MobEffect)entry.getKey())) continue;
                try {
                    METHOD_ON_EFFECT_REMOVED.invoke((Object)entity, entry.getValue());
                    it.remove();
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void clearBadEffects(@Nullable LivingEntity entity) {
        if (entity != null) {
            EffectHelper.clearEffect(entity, (MobEffect effect) -> effect != null && effect.m_19483_() == MobEffectCategory.HARMFUL);
            if (entity.m_6060_()) {
                entity.m_20095_();
            }
            if (entity.m_146886_()) {
                entity.m_146915_(false);
            }
        }
    }

    @Nullable
    public static MobEffectInstance getRandomEffect(int duration, boolean isBad) {
        return EffectHelper.getRandomEffect(duration, isBad, true, RANDOM_EFFECT_LEVEL);
    }

    @Nullable
    public static MobEffectInstance getRandomEffect(int duration, boolean isBad, boolean acceptInstantEffect, Function<Random, Integer> functionEffectLevel) {
        Predicate<MobEffect> predic;
        Predicate<MobEffect> predicate = predic = isBad ? EffectHelper::isBadEffect : EffectHelper::isAllowedEffect;
        if (!acceptInstantEffect) {
            predic = predic.and(effect -> !effect.m_8093_());
        }
        return Helper.getRandomInList(ForgeRegistries.MOB_EFFECTS.getValues().stream().filter(predic).collect(Collectors.toList())).map(effect -> new MobEffectInstance(effect, isBad && effect.m_8093_() ? 1 : duration, ((Integer)functionEffectLevel.apply(Helper.random)).intValue())).orElse(null);
    }

    public static void addRandomEffect(Player player, int duration, boolean withMessage) {
        EffectHelper.addRandomEffect(player, duration, withMessage, false, true);
    }

    public static void addRandomEffect(Player player, int duration, boolean withMessage, boolean isBad, boolean acceptInstantEffect) {
        MobEffectInstance effect = EffectHelper.getRandomEffect(duration, isBad, acceptInstantEffect, RANDOM_EFFECT_LEVEL);
        if (effect != null) {
            if (withMessage && !effect.m_19544_().m_19481_().isEmpty()) {
                LangKey.MESSAGE_SPELL_CAST_ON_YOU.sendMessage(player, StyleType.MESSAGE_SPELL, new Object[]{new TranslatableComponent(effect.m_19544_().m_19481_()).m_6270_(StyleType.MESSAGE_SPECIAL)});
            }
            EffectHelper.addEffect((LivingEntity)player, effect);
        }
    }

    public static boolean isBadEffect(@Nullable MobEffect effect) {
        return effect != null && effect.m_19483_() == MobEffectCategory.HARMFUL && !Helper.containRL((List<String>)((List)ConfigTombstone.general.unhandledHarmfulEffects.get()), effect.getRegistryName());
    }

    public static boolean isAllowedEffect(@Nullable MobEffectInstance effectInstance) {
        return effectInstance != null && EffectHelper.isAllowedEffect(effectInstance.m_19544_());
    }

    public static boolean isAllowedEffect(@Nullable MobEffect effect) {
        return effect != null && effect.m_19483_() == MobEffectCategory.BENEFICIAL && effect != ModEffects.ghostly_shape && effect != ModEffects.preservation && !Helper.containRL((List<String>)((List)ConfigTombstone.general.unhandledBeneficialEffects.get()), effect.getRegistryName());
    }

    public static ItemStack createFrostbiteArrows(int amplifier, int count) {
        ItemStack tippedArrow = new ItemStack((ItemLike)Items.f_42738_, count);
        PotionUtils.m_43552_((ItemStack)tippedArrow, Collections.singleton(new MobEffectInstance(ModEffects.frostbite, 1600, amplifier)));
        NBTStackHelper.setInteger(tippedArrow, "CustomPotionColor", 0xA0EAEA);
        return tippedArrow;
    }
}

