/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModPerks;

public class PlayerStatusHandler {
    private static final Map<UUID, PlayerStatus> PLAYER_STATUS = new ConcurrentHashMap<UUID, PlayerStatus>();

    @Nullable
    public static PlayerStatus getPlayerStatus(@Nullable Entity entity) {
        return entity == null ? null : PLAYER_STATUS.get(entity.m_142081_());
    }

    public static void updateAllStatus(MinecraftServer server) {
        PLAYER_STATUS.clear();
        server.m_6846_().m_11314_().forEach(PlayerStatusHandler::updateStatus);
    }

    public static void updateStatus(ServerPlayer player) {
        PLAYER_STATUS.put(player.m_142081_(), PlayerStatusHandler.createStatus(player));
    }

    private static PlayerStatus createStatus(ServerPlayer player) {
        int lvl;
        double modifierHighPriority = 1.0;
        if (!player.m_20159_() && (lvl = EntityHelper.getShadowStepLevel((Player)player)) > 0) {
            modifierHighPriority = Mth.m_14008_((double)((double)player.m_6073_() - (double)lvl * 0.1), (double)0.01, (double)1.0);
        }
        if ((lvl = EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.shadow_walker)) > 0) {
            modifierHighPriority *= 1.0 - (double)lvl * 0.1;
        }
        double modifierLowPriority = 1.0;
        if (EffectHelper.isPotionActive((LivingEntity)player, ModEffects.diversion) || EffectHelper.isPotionActive((LivingEntity)player, ModEffects.ghostly_shape)) {
            modifierLowPriority = 0.0;
        } else {
            MobEffectInstance bait = player.m_21124_(ModEffects.bait);
            if (bait != null) {
                modifierLowPriority *= Math.min((double)bait.m_19564_() + 1.0, 2.0);
            }
        }
        return new PlayerStatus(modifierHighPriority, modifierLowPriority);
    }

    public record PlayerStatus(double visibleFactorHighPriority, double visibleFactorLowPriority) {
    }
}

