/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.SupportStructures;
import ovh.corail.tombstone.registry.ModBlocks;

public class SpawnHelper {
    private final ResourceKey<Level> dimId;
    private BlockPos initPos;
    private final Level level;
    private final Predicate<BlockPos> withinWorldBorder;
    private final Predicate<BlockPos> withinWorldBuildHeight;
    private final int minHeight;
    private final int maxHeight;
    private ConfigTombstone.Client.GraveSpawnRule graveSpawnRule = ConfigTombstone.Client.GraveSpawnRule.getDefault();
    private boolean graveInWater = true;
    private List<BlockPos> positions;
    private BlockPos spawnPos = null;
    private SpawnResult spawnType = SpawnResult.NONE;
    private int move = 0;
    private static final Material[] UNSAFE_MATERIAL = new Material[]{Material.f_76307_, Material.f_76309_, Material.f_76298_, Material.f_76277_, Material.f_76282_, Material.f_76273_, Material.f_76311_};
    private static final Material[] GROUND_MATERIAL = new Material[]{Material.f_76274_, Material.f_76299_, Material.f_76280_, Material.f_76314_, Material.f_76276_, Material.f_76316_};

    public SpawnHelper(ServerLevel level, BlockPos initPos) {
        this.level = level;
        this.dimId = this.level.m_46472_();
        this.initPos = Helper.getCloserValidPos(this.level, initPos);
        this.withinWorldBorder = pos -> this.level.m_6857_().m_61937_(pos);
        this.minHeight = this.level.m_141937_();
        this.maxHeight = this.level.m_151558_();
        this.withinWorldBuildHeight = pos -> pos.m_123342_() >= this.minHeight && pos.m_123342_() < this.maxHeight;
    }

    public SpawnHelper withPlayerPreference(PlayerPreference playerPreference) {
        this.graveSpawnRule = playerPreference.getGraveSpawnRule();
        this.graveInWater = playerPreference.allowGraveInWater();
        return this;
    }

    private Location result() {
        return new Location(this.spawnPos, this.dimId);
    }

    public Location findSafePlace(int range, boolean withHeight) {
        this.initPositions(this.initPos.m_142082_(-range, withHeight ? -range : 0, -range), this.initPos.m_142082_(range, withHeight ? range : 0, range));
        for (BlockPos currentPos : this.positions) {
            if (!this.isIdealSpawnPlace(currentPos)) continue;
            return this.result();
        }
        return Location.ORIGIN;
    }

    public Location findStructurePlace(ResourceLocation structureRL) {
        return this.findStructurePlace(structureRL.m_135827_(), structureRL.m_135815_());
    }

    public Location findStructurePlace(String structureRL) {
        Pair<String, String> rl = Helper.parseRLString(structureRL);
        return this.findStructurePlace((String)rl.getLeft(), (String)rl.getRight());
    }

    private Location findStructurePlace(String domain, String path) {
        this.initPos = new BlockPos(this.initPos.m_123341_(), SupportStructures.getY(domain, path), this.initPos.m_123343_());
        return this.findSpawnPlace(SupportStructures.BURIED_TREASURE.is(domain, path) ? PlacementType.SPAWN_BURIED_TREASURE : PlacementType.SPAWN_STRUCTURE);
    }

    public Location findSpawnPlace() {
        return this.findSpawnPlace(PlacementType.SPAWN_PLACE);
    }

    public Location findGravePlace() {
        return this.findSpawnPlace(PlacementType.SPAWN_GRAVE);
    }

    public Pair<Location, SpawnResult> findGravePlaceWithResult() {
        return Pair.of((Object)this.findSpawnPlace(PlacementType.SPAWN_GRAVE), (Object)((Object)this.spawnType));
    }

    private BlockPos getInitPosInFluid(PlacementType placementType) {
        BlockPos adjustedPos = this.initPos;
        BlockState state = this.level.m_8055_(adjustedPos);
        FluidState fluidState = state.m_60819_();
        if (fluidState.m_76178_() && this.withinWorldBuildHeight.test(adjustedPos = adjustedPos.m_7494_())) {
            state = this.level.m_8055_(adjustedPos);
            fluidState = state.m_60819_();
        }
        if (fluidState.m_76178_() || fluidState.m_76153_((Tag)FluidTags.f_13131_) && (!placementType.isGrave() || this.graveInWater)) {
            return this.initPos;
        }
        while (!this.level.m_8055_(adjustedPos).m_60819_().m_76178_()) {
            if (this.withinWorldBuildHeight.test(adjustedPos = adjustedPos.m_7494_())) continue;
            return this.initPos;
        }
        return adjustedPos;
    }

    private Location findSpawnPlace(PlacementType placementType) {
        int minY;
        int maxY;
        boolean wasInLiquid;
        Predicate<BlockPos> predicPos;
        Predicate<BlockPos> predicate = predicPos = placementType.isGrave() ? this::isIdealGravePlace : this::isIdealSpawnPlace;
        if (predicPos.test(this.initPos)) {
            return this.result();
        }
        if (placementType.isBuriedTreasure()) {
            this.initUniquePosition();
        } else {
            this.initChunkPositions();
        }
        BlockPos adjustedPos = this.getInitPosInFluid(placementType);
        boolean bl = wasInLiquid = !adjustedPos.equals((Object)this.initPos);
        if (placementType.isGrave()) {
            maxY = this.maxHeight;
            minY = this.minHeight;
        } else {
            int borne = placementType.isSpawn() ? 70 : 16;
            maxY = Math.min(adjustedPos.m_123342_() + borne, this.maxHeight);
            minY = Math.max(adjustedPos.m_123342_() - borne, this.minHeight);
        }
        int yUp = adjustedPos.m_123342_();
        int yDown = yUp - 1;
        boolean canGoDown = true;
        boolean canGoUp = true;
        this.move = 0;
        while (canGoUp || canGoDown) {
            canGoUp = yUp < maxY;
            canGoDown = !wasInLiquid && yDown > minY;
            for (BlockPos pos : this.positions) {
                BlockPos currentPos;
                if (canGoUp && predicPos.test(currentPos = new BlockPos(pos.m_123341_(), yUp, pos.m_123343_()))) {
                    return this.result();
                }
                if (!canGoDown || !predicPos.test(currentPos = new BlockPos(pos.m_123341_(), yDown, pos.m_123343_()))) continue;
                return this.result();
            }
            ++yUp;
            --yDown;
            ++this.move;
        }
        return placementType.isGrave() && SpawnResult.MINIMAL.hasPattern(this.spawnType) ? this.result() : Location.ORIGIN;
    }

    private boolean isIdealSpawnPlace(BlockPos pos) {
        if (this.isSafeGround(pos.m_7495_()) && this.isSafePlace(pos) && this.isSafePlace(pos.m_7494_())) {
            this.setTypeAndPosition(SpawnResult.IDEAL, pos);
            return true;
        }
        return false;
    }

    private boolean isIdealGravePlace(BlockPos pos) {
        if (this.isGravePlace(pos)) {
            SpawnResult type = this.isSafeGround(pos.m_7495_()) ? (this.isSafePlace(pos.m_7494_()) ? (this.isSafePlace(pos.m_6630_(2)) ? SpawnResult.IDEAL : SpawnResult.FIT) : SpawnResult.NORMAL) : SpawnResult.MINIMAL;
            this.setTypeAndPosition(type, pos);
            if (this.graveSpawnRule == ConfigTombstone.Client.GraveSpawnRule.SAFEST) {
                return type == SpawnResult.IDEAL;
            }
            if (this.graveSpawnRule == ConfigTombstone.Client.GraveSpawnRule.NEAREST) {
                return SpawnResult.MINIMAL.hasPattern(type);
            }
            return this.move > 70 ? SpawnResult.NORMAL.hasPattern(this.spawnType) : type == SpawnResult.IDEAL;
        }
        return false;
    }

    private boolean isGravePlace(BlockPos pos) {
        BlockState state = this.level.m_8055_(pos);
        return (state.m_60795_() || state.m_60767_() == Material.f_76308_ || state.m_60767_() == Material.f_76309_ || this.graveInWater && state.m_60819_().m_76153_((Tag)FluidTags.f_13131_)) && !state.m_155947_();
    }

    private boolean isSafeGround(BlockPos pos) {
        PlaceType placeType = this.getPlaceType(pos, true);
        return placeType.isGround() || placeType.isWater();
    }

    private boolean isSafePlace(BlockPos pos) {
        PlaceType placeType = this.getPlaceType(pos);
        return placeType.isSafe() || placeType.isWater();
    }

    private void setTypeAndPosition(SpawnResult type, BlockPos pos) {
        if (type.ordinal() > this.spawnType.ordinal()) {
            this.spawnType = type;
            this.spawnPos = pos;
        }
    }

    private void initChunkPositions() {
        ChunkPos chunkPos = new ChunkPos(this.initPos);
        this.initPositions(new BlockPos(chunkPos.m_45604_(), 0, chunkPos.m_45605_()), new BlockPos(chunkPos.m_45608_(), 0, chunkPos.m_45609_()));
    }

    private void initPositions(BlockPos startPos, BlockPos endPos) {
        this.spawnPos = null;
        this.spawnType = SpawnResult.NONE;
        this.positions = SpawnHelper.getAllInBox(startPos, endPos).sorted(Comparator.comparingDouble(pos -> Helper.getDistanceSq((Vec3i)pos, this.initPos.m_123341_(), 0, this.initPos.m_123343_()))).toList();
    }

    private void initUniquePosition() {
        this.spawnPos = null;
        this.spawnType = SpawnResult.NONE;
        this.positions = ImmutableList.of((Object)this.initPos);
    }

    public static Stream<BlockPos> getAllInBox(BlockPos startPos, BlockPos endPos) {
        int minX = Math.min(startPos.m_123341_(), endPos.m_123341_());
        int maxX = Math.max(startPos.m_123341_(), endPos.m_123341_());
        int minY = Math.min(startPos.m_123342_(), endPos.m_123342_());
        int maxY = Math.max(startPos.m_123342_(), endPos.m_123342_());
        int minZ = Math.min(startPos.m_123343_(), endPos.m_123343_());
        int maxZ = Math.max(startPos.m_123343_(), endPos.m_123343_());
        Stream.Builder<BlockPos> list = Stream.builder();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    list.accept(new BlockPos(x, y, z));
                }
            }
        }
        return list.build();
    }

    private PlaceType getPlaceType(BlockPos pos) {
        return this.getPlaceType(pos, false);
    }

    private PlaceType getPlaceType(BlockPos pos, boolean preciseGround) {
        if (!this.withinWorldBorder.test(pos)) {
            return PlaceType.UNSAFE;
        }
        BlockState state = this.level.m_8055_(pos);
        Block block = state.m_60734_();
        BlockPathTypes type = state.getBlockPathType((BlockGetter)this.level, pos, null);
        if (type != null) {
            return switch (type) {
                case BlockPathTypes.OPEN, BlockPathTypes.BREACH -> PlaceType.SAFE;
                case BlockPathTypes.BLOCKED, BlockPathTypes.WALKABLE, BlockPathTypes.LEAVES, BlockPathTypes.COCOA, BlockPathTypes.RAIL -> PlaceType.GROUND;
                case BlockPathTypes.WATER, BlockPathTypes.WATER_BORDER -> PlaceType.WATER;
                default -> PlaceType.UNSAFE;
            };
        }
        Material mat = state.m_60767_();
        if (Arrays.stream(UNSAFE_MATERIAL).anyMatch(m -> m == mat) || block == Blocks.f_50685_ || block == Blocks.f_50450_) {
            return PlaceType.UNSAFE;
        }
        FluidState fluidState = state.m_60819_();
        if (!fluidState.m_76178_()) {
            return fluidState.m_76153_((Tag)FluidTags.f_13131_) && Helper.hasNoCollision((BlockGetter)this.level, pos, state) ? PlaceType.WATER : PlaceType.UNSAFE;
        }
        if (mat == Material.f_76308_ || state.m_60795_()) {
            return PlaceType.SAFE;
        }
        if (Arrays.stream(GROUND_MATERIAL).anyMatch(m -> m == mat)) {
            return PlaceType.GROUND;
        }
        VoxelShape collisionShape = state.m_60812_((BlockGetter)this.level, pos);
        if (collisionShape == Shapes.m_83040_()) {
            return PlaceType.SAFE;
        }
        if (!preciseGround) {
            return PlaceType.UNSAFE;
        }
        if (collisionShape == Shapes.m_83144_()) {
            return PlaceType.GROUND;
        }
        if (!mat.m_76334_()) {
            return block == Blocks.f_50196_ ? PlaceType.GROUND : PlaceType.UNSAFE;
        }
        if (state.m_60620_((Tag)BlockTags.f_13031_) || state.m_60620_((Tag)BlockTags.f_13030_) || state.m_60620_((Tag)BlockTags.f_13032_) || state.m_60620_((Tag)BlockTags.f_13038_) || ModBlocks.isAnyGrave(block)) {
            return PlaceType.GROUND;
        }
        return PlaceType.UNSAFE;
    }

    public static enum SpawnResult {
        NONE,
        MINIMAL,
        NORMAL,
        FIT,
        IDEAL;


        public boolean hasPattern(SpawnResult actualPattern) {
            return this.ordinal() <= actualPattern.ordinal();
        }
    }

    private static enum PlacementType {
        SPAWN_PLACE,
        SPAWN_GRAVE,
        SPAWN_STRUCTURE,
        SPAWN_BURIED_TREASURE;


        public boolean isSpawn() {
            return this == SPAWN_PLACE;
        }

        public boolean isGrave() {
            return this == SPAWN_GRAVE;
        }

        public boolean isStructure() {
            return this == SPAWN_STRUCTURE || this == SPAWN_BURIED_TREASURE;
        }

        public boolean isBuriedTreasure() {
            return this == SPAWN_BURIED_TREASURE;
        }
    }

    private static enum PlaceType {
        SAFE,
        GROUND,
        UNSAFE,
        WATER;


        public boolean isSafe() {
            return this == SAFE;
        }

        public boolean isGround() {
            return this == GROUND;
        }

        public boolean isWater() {
            return this == WATER;
        }
    }
}

