/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThreadedBackup
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger((String)"Backup");
    public static final ThreadedBackup INSTANCE = new ThreadedBackup();
    private final List<IThreadedBackup> threadedBackupQueue = Collections.synchronizedList(Lists.newArrayList());
    private final AtomicInteger queuedCounter = new AtomicInteger();
    private final AtomicInteger counter = new AtomicInteger();
    private volatile boolean isFlushing = false;
    private volatile boolean isStopping = false;

    private ThreadedBackup() {
    }

    public void startThread() {
        this.isStopping = false;
        Thread thread = new Thread((Runnable)this, "Backup");
        thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandlerWithName(LOGGER));
        thread.setPriority(1);
        thread.start();
    }

    public void stopThread() {
        this.isStopping = true;
    }

    @Override
    public void run() {
        while (!this.isStopping) {
            this.processQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void processQueue() {
        for (int i = 0; i < this.threadedBackupQueue.size(); ++i) {
            IThreadedBackup backup;
            IThreadedBackup iThreadedBackup = backup = this.threadedBackupQueue.get(i);
            // MONITORENTER : backup
            boolean success = backup.writeNextBackup();
            // MONITOREXIT : iThreadedBackup
            if (success) {
                this.threadedBackupQueue.remove(i--);
                this.counter.incrementAndGet();
            }
            try {
                Thread.sleep(this.isFlushing ? 0L : 10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.threadedBackupQueue.isEmpty()) return;
        try {
            Thread.sleep(25L);
            return;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void queueBackup(IThreadedBackup backup) {
        if (!this.threadedBackupQueue.contains(backup)) {
            this.queuedCounter.incrementAndGet();
            this.threadedBackupQueue.add(backup);
        }
    }

    public void flush() throws InterruptedException {
        this.isFlushing = true;
        while (this.queuedCounter.get() != this.counter.get()) {
            Thread.sleep(10L);
        }
        this.isFlushing = false;
    }

    public record DefaultUncaughtExceptionHandlerWithName(Logger logger) implements Thread.UncaughtExceptionHandler
    {
        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            this.logger.error("Caught previously unhandled exception :");
            this.logger.error(thread.getName(), throwable);
        }
    }

    public static interface IThreadedBackup {
        public boolean writeNextBackup();
    }
}

