/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.block.BlockDecorativeGrave;
import ovh.corail.tombstone.block.SoulType;
import ovh.corail.tombstone.capability.ProtectedEntityProvider;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.capability.TBSoulConsumerProvider;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TameableType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.network.EffectMessage;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemAnkhOfPray
extends ItemGeneric
implements ISoulConsumer {
    public ItemAnkhOfPray() {
        super("ankh_of_pray", ItemAnkhOfPray.getBuilder().m_41499_(30).m_41486_());
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public Component m_7626_(ItemStack stack) {
        return super.m_7626_(stack).m_6879_().m_6270_(StyleType.MESSAGE_SPECIAL);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        if (Helper.canShowTooltip(level)) {
            this.addItemDesc(list);
            Player player = ModTombstone.PROXY.getClientPlayer();
            if (player != null) {
                if (!this.m_5812_(stack)) {
                    int cd = CooldownHandler.INSTANCE.getCooldown(player, CooldownType.NEXT_PRAY);
                    if (cd > 0) {
                        this.addInfo(list, this.m_5524_() + ".use1", new TextComponent("[" + TimeHelper.getTimeString(cd) + "]").m_130948_(StyleType.TOOLTIP_DESC));
                    }
                } else {
                    this.addItemUse(list, "2", new Object[0]);
                }
                if (CooldownHandler.INSTANCE.getCooldown(player, CooldownType.RESET_PERKS) <= 0) {
                    this.addItemUse(list, "3", new Object[0]);
                }
            }
        } else {
            this.addInfoShowTooltip(list);
        }
        super.m_7373_(stack, level, list, flag);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (EntityHelper.isValidPlayer(context.m_43723_())) {
            BlockState state = context.m_43725_().m_8055_(context.m_8083_());
            if (ModBlocks.isDecorativeGrave(state.m_60734_()) && ((SoulType)((Object)state.m_61143_(BlockDecorativeGrave.SOUL_TYPE))).hasSoul()) {
                return InteractionResult.PASS;
            }
            return this.m_7203_(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_();
        }
        return InteractionResult.FAIL;
    }

    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        if (EntityHelper.isValidPlayer(playerIn) && hand == InteractionHand.MAIN_HAND && playerIn.m_21205_().m_150930_((Item)this) && !EntityHelper.hasGlobalItemCooldown(playerIn, this) && target != null) {
            if (target instanceof ZombieVillager) {
                ZombieVillager zombieVillager2 = (ZombieVillager)target;
                EntityHelper.setGlobalItemCooldown(playerIn, this, 10);
                if (CooldownHandler.INSTANCE.noCooldown(playerIn, CooldownType.NEXT_PRAY) && !playerIn.f_19853_.m_5776_()) {
                    ServerPlayer player = (ServerPlayer)playerIn;
                    MobEffectInstance effectInstance = new MobEffectInstance(ModEffects.exorcism, 200, 1);
                    EffectHelper.addEffect((LivingEntity)zombieVillager2, effectInstance);
                    PacketHandler.sendToAllTrackingPlayers(new EffectMessage(zombieVillager2.m_142049_(), effectInstance), (LivingEntity)zombieVillager2);
                    zombieVillager2.f_34360_ = null;
                    zombieVillager2.f_34365_ = 200;
                    zombieVillager2.m_20088_().m_135381_(ZombieVillager.f_34359_, (Object)true);
                    zombieVillager2.m_21195_(MobEffects.f_19613_);
                    zombieVillager2.f_19853_.m_7605_((Entity)zombieVillager2, (byte)16);
                    zombieVillager2.getPersistentData().m_128379_("tb_converting", true);
                    CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.NEXT_PRAY);
                    player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.reward(player, 3, (Integer)ConfigTombstone.alignment.pointsExorcismZombieVillager.get()));
                    Helper.damageItem(player.m_21205_(), 3, player, InteractionHand.MAIN_HAND);
                    LangKey.MESSAGE_EXORCISM.sendMessage((Player)player, StyleType.MESSAGE_SPECIAL, new Object[0]);
                    ModTriggers.EXORCISM.trigger(player);
                }
                return InteractionResult.SUCCESS;
            }
            int alignment = playerIn.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(ITBCapability::getAlignmentLevel).orElse(0);
            if (alignment < 0 && target instanceof Villager) {
                Villager villager = (Villager)target;
                if (villager.f_19853_.m_46791_() != Difficulty.PEACEFUL) {
                    EntityHelper.setGlobalItemCooldown(playerIn, this, 10);
                    if (!playerIn.f_19853_.m_5776_() && CooldownHandler.INSTANCE.noCooldown(playerIn, CooldownType.NEXT_PRAY)) {
                        ServerPlayer player = (ServerPlayer)playerIn;
                        Optional.ofNullable((ZombieVillager)villager.m_21406_(EntityType.f_20530_, false)).ifPresent(zombieVillager -> {
                            zombieVillager.m_6518_((ServerLevelAccessor)player.m_183503_(), player.m_183503_().m_6436_(zombieVillager.m_142538_()), MobSpawnType.CONVERSION, (SpawnGroupData)new Zombie.ZombieGroupData(false, false), null);
                            zombieVillager.m_141967_(villager.m_7141_());
                            zombieVillager.m_34391_((Tag)villager.m_35517_().m_26179_((DynamicOps)NbtOps.f_128958_).getValue());
                            zombieVillager.m_34411_(villager.m_6616_().m_45388_());
                            zombieVillager.m_34373_(villager.m_7809_());
                            MobEffectInstance effectInstance = new MobEffectInstance(ModEffects.exorcism, 200, 1);
                            EffectHelper.addEffect((LivingEntity)zombieVillager, effectInstance);
                            zombieVillager.getPersistentData().m_128379_("tb_converting", true);
                            PacketHandler.sendToAllTrackingPlayers(new EffectMessage(zombieVillager.m_142049_(), effectInstance), (LivingEntity)zombieVillager);
                            CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.NEXT_PRAY);
                            player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.reward(player, 3, -((Integer)ConfigTombstone.alignment.pointsExorcismZombieVillager.get()).intValue()));
                            Helper.damageItem(player.m_21205_(), 3, player, InteractionHand.MAIN_HAND);
                            LangKey.MESSAGE_EXORCISM.sendMessage((Player)player, StyleType.MESSAGE_SPECIAL, new Object[0]);
                            ModTriggers.ZOMBIFY.trigger(player);
                        });
                    }
                    return InteractionResult.SUCCESS;
                }
            }
            if (alignment > 0) {
                return target.getCapability(ProtectedEntityProvider.PROTECTED_ENTITY_CAPABILITY).map(protCap -> {
                    EntityHelper.setGlobalItemCooldown(playerIn, this, 10);
                    if (CooldownHandler.INSTANCE.noCooldown(playerIn, CooldownType.NEXT_PRAY) && !playerIn.f_19853_.m_5776_()) {
                        ServerPlayer player = (ServerPlayer)playerIn;
                        if (!protCap.isActive()) {
                            protCap.apply(target, true);
                            CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.NEXT_PRAY);
                            player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.reward(player, 3, (Integer)ConfigTombstone.alignment.pointsPrayOfProtection.get()));
                            Helper.damageItem(player.m_21205_(), 3, player, InteractionHand.MAIN_HAND);
                            LangKey.MESSAGE_PRAY_OF_PROTECTION_SUCCESS.sendMessage((Player)player, StyleType.MESSAGE_SPECIAL, new Object[]{target.m_7755_()});
                            ModTriggers.PRAY_OF_PROTECTION.trigger(player);
                        } else {
                            LangKey.MESSAGE_PRAY_OF_PROTECTION_FAILED.sendMessage((Player)player, StyleType.MESSAGE_SPECIAL, new Object[]{target.m_7755_()});
                        }
                    }
                    return InteractionResult.SUCCESS;
                }).orElse(InteractionResult.FAIL);
            }
        }
        return InteractionResult.FAIL;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack heldStack = player.m_21120_(hand);
        if (hand == InteractionHand.MAIN_HAND && heldStack.m_150930_((Item)this)) {
            if (EntityHelper.hasGlobalItemCooldown(player, this)) {
                return new InteractionResultHolder(InteractionResult.CONSUME, (Object)heldStack);
            }
            if (CooldownHandler.INSTANCE.getCooldown(player, CooldownType.NEXT_PRAY) <= 0) {
                MutableComponent failedMessage = null;
                ItemStack offhand = player.m_21206_();
                if (ModItems.familiar_receptacle.containSoul(offhand)) {
                    if (ModItems.familiar_receptacle.getDurability(offhand) != 0.0) {
                        failedMessage = LangKey.MESSAGE_RECOVERING_RECEPTACLE.getText(StyleType.COLOR_OFF, new Object[0]);
                    } else if (player.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(ITBCapability::getTotalPerkPoints).orElse(0) < (Integer)SharedConfigTombstone.general.familiarReceptacleRequiredLevel.get()) {
                        failedMessage = LangKey.MESSAGE_CRAFTING_KNOWLEDGE_REQUIRED.getText(StyleType.COLOR_OFF, SharedConfigTombstone.general.familiarReceptacleRequiredLevel.get());
                    }
                    if (failedMessage != null) {
                        EntityHelper.setGlobalItemCooldown(player, this, 10);
                        if (!player.f_19853_.m_5776_()) {
                            LangKey.sendMessage((Component)failedMessage, player);
                        }
                        return new InteractionResultHolder(InteractionResult.FAIL, (Object)heldStack);
                    }
                }
                player.m_6672_(hand);
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)heldStack);
            }
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)heldStack);
    }

    @Nullable
    private BlockPos findGraveAround(Level level, BlockPos startPos) {
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos currentPos = new BlockPos(startPos.m_123341_() + x, startPos.m_123342_() + y, startPos.m_123343_() + z);
                    if (!ModBlocks.isDecorativeGrave(level.m_8055_(currentPos).m_60734_())) continue;
                    return currentPos;
                }
            }
        }
        return null;
    }

    public ItemStack m_5922_(ItemStack stack, @Nullable Level level, LivingEntity entity) {
        ServerPlayer player;
        if (EntityHelper.isValidServerPlayer((Entity)entity) && !EntityHelper.hasGlobalItemCooldown((Player)(player = (ServerPlayer)entity), this)) {
            BlockPos gravePos = this.findGraveAround(player.f_19853_, player.m_142538_());
            if (gravePos != null) {
                player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> {
                    ItemStack offhandStack = player.m_21206_();
                    if (offhandStack.m_150930_((Item)ModItems.familiar_receptacle)) {
                        if (ModItems.familiar_receptacle.containSoul(offhandStack)) {
                            if (ModItems.familiar_receptacle.getDurability(offhandStack) > 0.0) {
                                LangKey.MESSAGE_RECOVERING_RECEPTACLE.sendMessage((Player)player, StyleType.COLOR_OFF, new Object[0]);
                            } else if (ModItems.familiar_receptacle.revive((Player)player, gravePos, offhandStack)) {
                                CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.NEXT_PRAY);
                                cap.reward(player, 5, 0);
                                Helper.damageItem(stack, 1, player, InteractionHand.MAIN_HAND);
                                ModTriggers.REVIVE_FAMILIAR.trigger(player);
                                LangKey.MESSAGE_REVIVE_FAMILIAR.sendMessage((Player)player, LangKey.MESSAGE_YOUR_FAMILIAR.getText(new Object[0]));
                                offhandStack.m_41774_(1);
                            } else {
                                offhandStack.m_41749_("dead_pet");
                                LangKey.MESSAGE_CANT_REVIVE_FAMILIAR.sendMessage((Player)player, StyleType.COLOR_OFF, new Object[]{LangKey.MESSAGE_YOUR_FAMILIAR.getText(new Object[0])});
                            }
                        } else {
                            LangKey.MESSAGE_EMPTY_RECEPTACLE.sendMessage((Player)player, StyleType.COLOR_OFF, new Object[0]);
                        }
                    } else {
                        CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.NEXT_PRAY);
                        cap.reward(player, 1, 0);
                        Helper.damageItem(stack, 1, player, InteractionHand.MAIN_HAND);
                        ModTriggers.PRAY_ON_GRAVE.trigger(player);
                        if (TimeHelper.isAprilFoolsDay()) {
                            EffectHelper.addEffect((LivingEntity)player, MobEffects.f_19594_, TimeHelper.tickFromDay(1));
                        } else if (EffectHelper.clearEffect((LivingEntity)player, MobEffects.f_19594_)) {
                            LangKey.MESSAGE_DISPEL_BAD_OMEN.sendMessage((Player)player, StyleType.MESSAGE_SPELL, new Object[0]);
                        }
                        int totalPerkPoints = cap.getTotalPerkPoints();
                        int res = Helper.random.nextInt(100) + totalPerkPoints;
                        if (res >= 110 || TimeHelper.isAprilFoolsDay() && res < 30) {
                            EntityType.m_20632_((String)TameableType.getRandomTameableEntityTypeString()).ifPresent(entityType -> {
                                Entity pet = entityType.m_20615_(player.f_19853_);
                                if (pet != null) {
                                    pet.m_6034_((double)((float)gravePos.m_123341_() + Helper.random.nextFloat()) - 0.5, (double)gravePos.m_123342_() + 1.0, (double)((float)gravePos.m_123343_() + Helper.random.nextFloat()) - 0.5);
                                    if (pet instanceof Mob) {
                                        ((Mob)pet).m_6518_((ServerLevelAccessor)player.m_183503_(), player.f_19853_.m_6436_(pet.m_142538_()), MobSpawnType.MOB_SUMMONED, null, null);
                                    }
                                    TameableType.setTamedBy((Player)player, pet);
                                    player.f_19853_.m_7967_(pet);
                                    LangKey.MESSAGE_SUMMON_FAMILIAR.sendMessage((Player)player, new Object[0]);
                                }
                            });
                        }
                        if (TimeHelper.isDateAroundHalloween() || res < (Integer)ConfigTombstone.decorative_grave.chancePrayReward.get() + totalPerkPoints * 3) {
                            EffectHelper.addRandomEffect((Player)player, (Integer)SharedConfigTombstone.decorative_grave.cooldownToPray.get() * 5000, true);
                        }
                    }
                });
            } else {
                LangKey.MESSAGE_CANT_PRAY.sendMessage((Player)player, StyleType.COLOR_OFF, new Object[0]);
            }
            EntityHelper.setGlobalItemCooldown((Player)player, this, 10);
        }
        return stack;
    }

    public void onUsingTick(ItemStack stack, LivingEntity entity, int timeLeft) {
        if (entity != null && entity.f_19853_.m_5776_() && timeLeft == this.m_8105_(stack)) {
            ModTombstone.PROXY.produceParticleCasting(entity, p -> !p.m_6117_() || p.m_21252_() == 1);
        }
    }

    @Override
    public boolean m_5812_(ItemStack stack) {
        Player player = ModTombstone.PROXY.getClientPlayer();
        if (player == null || EntityHelper.hasGlobalItemCooldown(player, stack)) {
            return false;
        }
        int cooldownToPray = CooldownHandler.INSTANCE.getCooldown(player, CooldownType.NEXT_PRAY);
        if (cooldownToPray > 0) {
            int maxTime = CooldownType.NEXT_PRAY.getMaxCooldown(player);
            int elapsedTime = maxTime - cooldownToPray;
            ItemCooldowns cd = player.m_36335_();
            cd.f_41516_ -= elapsedTime;
            cd.m_41524_((Item)this, maxTime);
            cd.f_41516_ += elapsedTime;
            return false;
        }
        return true;
    }

    public int m_8105_(ItemStack stack) {
        return 60;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return false;
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        return player.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(cap -> {
            boolean hasReset = cap.resetPerks(player);
            if (hasReset) {
                ModTriggers.RESET_PERKS.trigger(player);
                return ISoulConsumer.ConsumeResult.success((Component)LangKey.MESSAGE_PERK_RESET_SUCCESS.getText(new Object[0]), 1);
            }
            int cd = CooldownHandler.INSTANCE.getCooldown((Player)player, CooldownType.RESET_PERKS);
            if (cd > 0) {
                int min = cd / 1200;
                if (min > 0) {
                    cd -= min * 1200;
                }
                return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_PERK_RESET_IN_COOLDOWN.getText(min, cd / 20));
            }
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_PERK_RESET_FAILED.getText(new Object[0]));
        }).orElse(ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_PERK_RESET_FAILED.getText(new Object[0])));
    }

    @Override
    public int getKnowledge() {
        return 0;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new TBSoulConsumerProvider(this);
    }
}

