/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.IDefaultImpregnable;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemBoneNeedle
extends ItemGeneric
implements IDefaultImpregnable {
    private static final int IMPREGNATED_MAX_TIME = TimeHelper.tickFromMinute(30);
    private static final String IMPREGNATED_TIME_NBT_LONG = "impregnated_time";

    public ItemBoneNeedle() {
        super("bone_needle", ItemBoneNeedle.getBuilder().m_41487_(1));
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        if (Helper.canShowTooltip(level)) {
            this.addItemDesc(list);
            Component impregnated = this.getTooltipDisplay(stack);
            if (impregnated == null) {
                this.addItemUse(list);
            } else {
                list.add(impregnated);
            }
        } else {
            this.addInfoShowTooltip(list);
        }
        super.m_7373_(stack, level, list, flag);
        int impregnatedTime = this.getImpregnatedTime(level, stack);
        if (impregnatedTime > 0) {
            this.addWarn(list, LangKey.MESSAGE_IMPREGNATE_DURATION, TimeHelper.getTimeStringWithUnit(impregnatedTime));
        }
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        ItemStack mainHandstack;
        if (player != null && hand == InteractionHand.MAIN_HAND && (mainHandstack = player.m_21205_()).m_150930_((Item)this) && !EntityHelper.hasGlobalItemCooldown(player, this)) {
            EntityHelper.setGlobalItemCooldown(player, this, 10);
            if (!player.f_19853_.m_5776_()) {
                if (this.impregnate(mainHandstack, target)) {
                    NBTStackHelper.setLong(stack, IMPREGNATED_TIME_NBT_LONG, TimeHelper.worldTicks(player.f_19853_) + (long)IMPREGNATED_MAX_TIME);
                    LangKey.MESSAGE_IMPREGNATE_NEEDLE_SUCCESS.sendMessage(player, StyleType.MESSAGE_SPECIAL, new Object[]{target.m_7755_()});
                    ModTriggers.IMPREGNATED_BONE_NEEDLE.trigger((ServerPlayer)player);
                } else {
                    LangKey.MESSAGE_IMPREGNATE_NEEDLE_FAILED.sendMessage(player, StyleType.MESSAGE_SPECIAL, new Object[0]);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!level.m_5776_() && stack.m_150930_((Item)this) && EntityHelper.isValidPlayer(entity) && !this.getEntityType(stack).isEmpty() && this.getImpregnatedTime(level, stack) == 1) {
            NBTStackHelper.removeKeyName(stack, IMPREGNATED_TIME_NBT_LONG);
            NBTStackHelper.removeKeyName(stack, "entity_type");
        }
    }

    private int getImpregnatedTime(@Nullable Level level, ItemStack stack) {
        long impregnatedTime;
        if (level != null && stack.m_150930_((Item)this) && (impregnatedTime = NBTStackHelper.getLong(stack, IMPREGNATED_TIME_NBT_LONG, 0L)) > 0L) {
            int cd = (int)(impregnatedTime - TimeHelper.worldTicks(level));
            if (cd > IMPREGNATED_MAX_TIME) {
                NBTStackHelper.setLong(stack, IMPREGNATED_TIME_NBT_LONG, TimeHelper.worldTicks(level) + (long)IMPREGNATED_MAX_TIME);
                return IMPREGNATED_MAX_TIME;
            }
            return Math.max(cd, 0);
        }
        return 0;
    }
}

