/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.capability.TBSoulConsumerProvider;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModItems;

public abstract class ItemBook
extends ItemGeneric
implements ISoulConsumer {
    public ItemBook(String name, BooleanSupplier supplierEnabled) {
        super(name, supplierEnabled);
    }

    public Component m_7626_(ItemStack stack) {
        return super.m_7626_(stack).m_6879_().m_6270_(StyleType.MESSAGE_SPECIAL);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (Helper.canShowTooltip(level)) {
            this.addItemDesc(tooltip);
            this.addItemUse(tooltip);
        } else {
            this.addInfoShowTooltip(tooltip);
        }
        super.m_7373_(stack, level, tooltip, flag);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return false;
    }

    @Override
    public boolean canEnchant(Level level, BlockPos gravePos, Player player, ItemStack stack) {
        return this.isEnabled();
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new TBSoulConsumerProvider(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Mod.EventBusSubscriber(modid="tombstone", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class Event {
        @SubscribeEvent
        public static void registerItemColors(ColorHandlerEvent.Item event) {
            event.getItemColors().m_92689_((stack, i) -> i == 0 ? -9865852 : -1, new ItemLike[]{ModItems.book_of_disenchantment});
            event.getItemColors().m_92689_((stack, i) -> i == 0 ? -7252579 : -1, new ItemLike[]{ModItems.book_of_recycling});
            event.getItemColors().m_92689_((stack, i) -> i == 0 ? -11246691 : -1, new ItemLike[]{ModItems.book_of_repairing});
            event.getItemColors().m_92689_((stack, i) -> i == 0 ? -11806832 : -1, new ItemLike[]{ModItems.book_of_magic_impregnation});
        }
    }
}

