/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EnchantHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.item.ItemBook;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemBookOfMagicImpregnation
extends ItemBook {
    public ItemBookOfMagicImpregnation() {
        super("book_of_magic_impregnation", () -> SharedConfigTombstone.allowed_magic_items.allowBookOfMagicImpregnation.get());
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        this.addInfoInBeta(tooltip);
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        int consumed;
        ItemStack offhand;
        if (stack.m_41720_() != this || (offhand = player.m_21206_()).m_41619_()) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_MAGIC_IMPREGNATION_FAILED.getText(new Object[0]));
        }
        Map<Enchantment, Integer> enchantments = EnchantHelper.getEnchantments(offhand);
        if (enchantments.size() == 0) {
            if (!offhand.m_41792_()) {
                return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_MAGIC_IMPREGNATION_FAILED.getText(new Object[0]));
            }
            consumed = soulStrength;
            enchantments = this.getRandomEnchantments(soulStrength * 10 + Helper.random.nextInt(20), offhand, soulStrength > 1);
            if (offhand.m_150930_(Items.f_42517_)) {
                offhand = new ItemStack((ItemLike)Items.f_42690_);
                player.m_8061_(EquipmentSlot.OFFHAND, offhand);
            }
        } else {
            List upgradables = enchantments.entrySet().stream().filter(e -> ((Enchantment)e.getKey()).m_6586_() > (Integer)e.getValue()).collect(Collectors.toList());
            if (upgradables.size() == 0) {
                return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_MAGIC_IMPREGNATION_MAX.getText(new Object[0]));
            }
            if (soulStrength == 1 || upgradables.size() == 1) {
                Map.Entry entry2 = (Map.Entry)upgradables.get(Helper.random.nextInt(upgradables.size()));
                consumed = 1;
                enchantments.put((Enchantment)entry2.getKey(), (Integer)entry2.getValue() + 1);
            } else {
                consumed = 2;
                enchantments.entrySet().stream().filter(e -> ((Enchantment)e.getKey()).m_6586_() > (Integer)e.getValue()).forEach(entry -> entry.setValue((Integer)entry.getValue() + 1));
            }
        }
        EnchantmentHelper.m_44865_(enchantments, (ItemStack)offhand);
        stack.m_41774_(1);
        ModTriggers.USE_MAGIC_IMPREGNATION.trigger(player);
        return ISoulConsumer.ConsumeResult.success((Component)LangKey.MESSAGE_MAGIC_IMPREGNATION_SUCCESS.getText(new Object[0]), consumed);
    }

    private Map<Enchantment, Integer> getRandomEnchantments(int roll, ItemStack stack, boolean hasStrongSoul) {
        ArrayList<EnchantmentInstance> availableEnchantments = new ArrayList<EnchantmentInstance>();
        boolean isBook = stack.m_150930_(Items.f_42517_);
        block0: for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS) {
            int maxLevel;
            if ((!enchantment.m_6592_() || !enchantment.canApplyAtEnchantingTable(stack) && (!isBook || !enchantment.isAllowedOnBooks())) && !hasStrongSoul) continue;
            for (int i = maxLevel = enchantment.m_6586_(); i >= enchantment.m_44702_(); --i) {
                if (roll < enchantment.m_6183_(i) || i != maxLevel && roll > enchantment.m_6175_(i)) continue;
                availableEnchantments.add(new EnchantmentInstance(enchantment, i));
                continue block0;
            }
        }
        HashMap<Enchantment, Integer> res = new HashMap<Enchantment, Integer>();
        if (!availableEnchantments.isEmpty()) {
            int max = hasStrongSoul ? 6 : 3;
            for (int i = 0; i < max && !availableEnchantments.isEmpty(); ++i) {
                WeightedRandom.m_146317_((Random)Helper.random, availableEnchantments).ifPresent(enchantmentInstance -> {
                    res.put(enchantmentInstance.f_44947_, enchantmentInstance.f_44948_);
                    availableEnchantments.removeIf(e -> !e.f_44947_.m_44695_(enchantmentInstance.f_44947_));
                });
            }
        }
        return res;
    }
}

