/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.item.ItemBook;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemBookOfRecycling
extends ItemBook {
    public ItemBookOfRecycling() {
        super("book_of_recycling", () -> SharedConfigTombstone.allowed_magic_items.allowBookOfRecycling.get());
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        this.addInfoInBeta(tooltip);
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        ItemStack recipeResult;
        ItemStack offhand;
        if (stack.m_41720_() != this || (offhand = player.m_21206_()).m_41619_()) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_RECYCLING_FAILED.getText(new Object[0]));
        }
        if (Helper.containRL((List<String>)((List)ConfigTombstone.decorative_grave.deniedItemToRecycle.get()), offhand.m_41720_().getRegistryName())) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_RECYCLING_DENIED.getText(new Object[0]));
        }
        if (offhand.m_41768_() && !((Boolean)ConfigTombstone.decorative_grave.canRecycleDamagedItem.get()).booleanValue()) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_CANT_RECYCLE_DAMAGED.getText(new Object[0]));
        }
        if (offhand.m_41783_() != null && offhand.m_41783_().m_128425_("Items", 9) || offhand.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_CANT_RECYCLE_CONTAINER.getText(new Object[0]));
        }
        ItemStack toSearch = offhand.m_41777_();
        if (toSearch.m_41768_()) {
            toSearch.m_41721_(toSearch.m_41773_());
        }
        NonNullList ingredients = NonNullList.m_122779_();
        if (toSearch.m_41720_() == Items.f_42654_) {
            ingredients.add(new ItemStack((ItemLike)Items.f_42454_, 7));
            recipeResult = new ItemStack((ItemLike)Items.f_42654_, 1);
        } else if (toSearch.m_41720_() == Items.f_42651_) {
            ingredients.add(new ItemStack((ItemLike)Items.f_42416_, 7));
            recipeResult = new ItemStack((ItemLike)Items.f_42651_, 1);
        } else if (toSearch.m_41720_() == Items.f_42652_) {
            ingredients.add(new ItemStack((ItemLike)Items.f_42417_, 7));
            recipeResult = new ItemStack((ItemLike)Items.f_42652_, 1);
        } else if (toSearch.m_41720_() == Items.f_42653_) {
            ingredients.add(new ItemStack((ItemLike)Items.f_42415_, 7));
            recipeResult = new ItemStack((ItemLike)Items.f_42653_, 1);
        } else {
            CraftingRecipe recipe = Objects.requireNonNull(player.m_20194_()).m_129894_().m_44013_(RecipeType.f_44107_).stream().filter(r -> ItemStack.m_150942_((ItemStack)r.m_8043_(), (ItemStack)toSearch)).max(Comparator.comparingLong(r -> r.m_7527_().stream().filter(i -> !i.m_43947_()).count())).orElse(null);
            if (recipe == null) {
                return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_NO_RECIPE_TO_RECYCLE.getText(new Object[0]));
            }
            if (recipe.m_8043_().m_41613_() > offhand.m_41613_()) {
                return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_RECYCLING_NOT_ENOUGH.getText(new Object[0]));
            }
            for (Ingredient ing : recipe.m_7527_()) {
                ItemStack[] items;
                ItemStack result;
                if (ing.m_43947_() || (result = (items = ing.m_43908_())[Helper.random.nextInt(items.length)]).m_41619_()) continue;
                ingredients.add(result);
            }
            recipeResult = recipe.m_8043_();
            if (ingredients.isEmpty()) {
                return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_NO_RECIPE_TO_RECYCLE.getText(new Object[0]));
            }
        }
        int maxRecycle = offhand.m_41613_() / recipeResult.m_41613_();
        for (ItemStack ingredient : ingredients) {
            int count = ingredient.m_41613_() * maxRecycle;
            int maxSize = ingredient.m_41741_();
            int fullStacks = count / maxSize;
            for (int i = 0; i < fullStacks; ++i) {
                ItemStack newStack = ingredient.m_41777_();
                newStack.m_41764_(maxSize);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)newStack);
            }
            int left = count - fullStacks * maxSize;
            if (left <= 0) continue;
            ItemStack leftStack = ingredient.m_41777_();
            leftStack.m_41764_(left);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)leftStack);
        }
        stack.m_41774_(1);
        offhand.m_41774_(recipeResult.m_41613_() * maxRecycle);
        ModTriggers.USE_RECYCLING.trigger(player);
        return ISoulConsumer.ConsumeResult.success((Component)LangKey.MESSAGE_RECYCLING_SUCCESS.getText(new Object[0]), 1);
    }
}

