/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;

public abstract class ItemDust
extends ItemGeneric {
    protected ItemDust(String name, BooleanSupplier supplierEnabled) {
        super(name, supplierEnabled);
    }

    public Component m_7626_(ItemStack stack) {
        return super.m_7626_(stack).m_6879_().m_6270_(StyleType.MESSAGE_SPECIAL);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        if (Helper.canShowTooltip(level)) {
            list.add((Component)new TranslatableComponent("tombstone.item.dust_of_vanishing.desc").m_6270_(StyleType.TOOLTIP_DESC));
            list.add((Component)new TranslatableComponent("tombstone.item.dust_of_vanishing.use").m_6270_(StyleType.TOOLTIP_DESC));
        } else {
            this.addInfoShowTooltip(list);
        }
        super.m_7373_(stack, level, list, flag);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_((Item)this)) {
            if (EntityHelper.hasGlobalItemCooldown(player, this)) {
                return new InteractionResultHolder(InteractionResult.CONSUME, (Object)stack);
            }
            if (!level.m_5776_()) {
                Vec3 posVec = player.m_20182_();
                Vec3 lookVec = new Vec3(player.m_20154_().f_82479_, 0.0, player.m_20154_().f_82481_).m_82541_();
                level.m_6263_(null, posVec.f_82479_, posVec.f_82480_, posVec.f_82481_, SoundEvents.f_11937_, SoundSource.PLAYERS, 0.5f, 0.5f);
                ServerLevel targetWorld = (ServerLevel)level;
                Location spawnPos = this.findBackwardLocation(targetWorld, posVec, lookVec, 8.0);
                if (spawnPos.isOrigin()) {
                    spawnPos = this.findBackwardLocation(targetWorld, posVec, lookVec, 3.0);
                }
                if (spawnPos.isOrigin()) {
                    spawnPos = new Location((Entity)player);
                } else {
                    Helper.teleport(player, spawnPos, targetWorld);
                }
                player.f_19789_ = 0.0f;
                this.onTeleportBackward((ServerPlayer)player, posVec, lookVec, spawnPos);
                ModTriggers.USE_VANISHING.trigger((ServerPlayer)player);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                EntityHelper.setGlobalItemCooldown(player, this, 200);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    protected abstract void onTeleportBackward(ServerPlayer var1, Vec3 var2, Vec3 var3, Location var4);

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        return InteractionResult.FAIL;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (EntityHelper.isValidPlayer(context.m_43723_())) {
            return this.m_7203_(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_();
        }
        return InteractionResult.FAIL;
    }

    private Location findBackwardLocation(ServerLevel level, Vec3 posVec, Vec3 lookVec, double range) {
        return new SpawnHelper(level, new BlockPos(posVec.m_82492_(lookVec.f_82479_ * range, 0.0, lookVec.f_82481_ * range))).findSafePlace(2, true);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Mod.EventBusSubscriber(modid="tombstone", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class Event {
        @SubscribeEvent
        public static void registerItemColors(ColorHandlerEvent.Item event) {
            event.getItemColors().m_92689_((stack, tint) -> tint == 0 ? -16711904 : -16733664, new ItemLike[]{ModItems.dust_of_vanishing});
            event.getItemColors().m_92689_((stack, tint) -> tint == 0 ? -16760672 : -16756550, new ItemLike[]{ModItems.grave_dust});
            event.getItemColors().m_92689_((stack, tint) -> tint == 0 ? -257896288 : -257896288, new ItemLike[]{ModItems.dust_of_frost});
        }
    }
}

