/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.item.IDisableable;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.registry.ModTabs;

public class ItemGeneric
extends Item
implements IDisableable {
    protected final String name;
    private boolean hasEffect = false;
    private boolean isCraftingIngredient = false;
    private final BooleanSupplier supplierEnabled;
    protected static final String ENCHANT_NBT_BOOL = "enchant";

    public ItemGeneric(String name) {
        this(name, ItemGeneric.getBuilder(), () -> true);
    }

    public ItemGeneric(String name, BooleanSupplier supplierEnabled) {
        this(name, ItemGeneric.getBuilder(), supplierEnabled);
    }

    public ItemGeneric(String name, Item.Properties builder) {
        this(name, builder, () -> true);
    }

    public ItemGeneric(String name, Item.Properties builder, BooleanSupplier supplierEnabled) {
        super(builder);
        this.name = name;
        this.supplierEnabled = supplierEnabled;
    }

    public String getSimpleName() {
        return this.name;
    }

    @Override
    public boolean isEnabled() {
        return this.supplierEnabled.getAsBoolean();
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (this.m_41389_(tab) && this.isEnabled()) {
            items.add((Object)new ItemStack((ItemLike)this));
        }
    }

    public ItemGeneric withEffect() {
        this.hasEffect = true;
        return this;
    }

    public ItemGeneric withCraftingInfo() {
        this.isCraftingIngredient = true;
        return this;
    }

    public boolean m_5812_(ItemStack stack) {
        return this.hasEffect || NBTStackHelper.getBoolean(stack, ENCHANT_NBT_BOOL);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (this.isCraftingIngredient) {
            tooltip.add((Component)LangKey.MESSAGE_CRAFTING_INGREDIENT.getText(StyleType.TOOLTIP_ITEM, new Object[0]));
        }
        if (!this.isEnabled()) {
            this.addWarn(tooltip, LangKey.MESSAGE_DISABLED, new Object[0]);
        }
    }

    public String m_5524_() {
        return "tombstone.item." + this.name;
    }

    public String m_5671_(ItemStack stack) {
        return this.m_5524_();
    }

    public void addItemDesc(List<Component> list) {
        this.addItemDesc(list, "", new Object[0]);
    }

    public void addItemDesc(List<Component> list, String id, Object ... format) {
        list.add((Component)new TranslatableComponent(this.m_5524_() + ".desc" + id, format).m_6270_(StyleType.TOOLTIP_DESC));
    }

    public void addItemUse(List<Component> list) {
        this.addItemUse(list, "", new Object[0]);
    }

    public void addItemUse(List<Component> list, String id, Object ... format) {
        list.add((Component)new TranslatableComponent(this.m_5524_() + ".use" + id, format).m_6270_(StyleType.TOOLTIP_USE));
    }

    public void addItemUse(List<Component> list, LangKey langKey, Object ... format) {
        list.add((Component)langKey.getText(StyleType.TOOLTIP_USE, format));
    }

    public void addInfo(List<Component> list, String key, Object ... format) {
        list.add((Component)new TranslatableComponent(key, format).m_6270_(StyleType.INFO));
    }

    public void addInfo(List<Component> list, LangKey langKey, Object ... format) {
        list.add((Component)langKey.getText(StyleType.INFO, format));
    }

    public void addWarn(List<Component> list, LangKey langKey, Object ... format) {
        list.add((Component)langKey.getText(StyleType.COLOR_OFF, format));
    }

    public void addInfoInBeta(List<Component> list) {
        list.add((Component)LangKey.TOOLTIP_BETA.getText(StyleType.TOOLTIP_IN_BETA, new Object[0]));
    }

    public void addInfoShowTooltip(List<Component> list) {
        this.addInfo(list, LangKey.TOOLTIP_MORE_INFO, new Object[0]);
    }

    public void addItemPosition(List<Component> list, Location location) {
        Player player = ModTombstone.PROXY.getClientPlayer();
        if (player != null && !location.isOrigin()) {
            BlockPos pos = player.m_142538_();
            list.add((Component)LangKey.MESSAGE_DISTANCE.getText(ChatFormatting.BLUE, new Object[]{(int)Helper.getDistance((Vec3i)location.getPos(), (Vec3i)pos), location.x, location.y, location.z, location.getDimString()}));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.m_150942_((ItemStack)oldStack, (ItemStack)newStack);
    }

    public String getCreatorModId(ItemStack itemStack) {
        return "tombstone";
    }

    protected static Item.Properties getBuilder() {
        return new Item.Properties().m_41491_(ModTabs.mainTab);
    }
}

