/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.TriggerCombineInInventoryMessage;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTags;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.tileentity.BlockEntityPlayerGrave;

public class ItemGraveKey
extends ItemGraveMagic {
    private static final String OWNER_ID_NBT_UUID = "owner_id";
    private static final String TOMB_POS_NBT_LOCATION = "tomb_pos";

    public ItemGraveKey() {
        super("grave_key", () -> SharedConfigTombstone.allowed_magic_items.allowGraveKey.get());
    }

    @Override
    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (Helper.canShowTooltip(level)) {
            Location location;
            String id = this.isEnchanted(stack) ? "2" : "1";
            this.addItemDesc(tooltip, id, new Object[0]);
            this.addItemDesc(tooltip, "3", new Object[0]);
            if (ModTags.Items.enchanted_grave_key_ingredients.m_6497_().size() > 0) {
                TextComponent content = new TextComponent("");
                ModTags.Items.enchanted_grave_key_ingredients.m_6497_().stream().limit(5L).forEach(item -> content.m_130946_(" [").m_7220_(item.m_41466_()).m_130946_("] "));
                this.addInfo(tooltip, this.m_5524_() + ".info", content.m_6270_(StyleType.TOOLTIP_ITEM));
            }
            if (!(location = this.getTombPos(stack)).isOrigin()) {
                this.addItemPosition(tooltip, location);
            }
            this.addItemUse(tooltip, id, new Object[0]);
            tooltip.add(ModEnchantments.soulbound.m_44700_(1));
        }
        super.m_7373_(stack, level, tooltip, flag);
    }

    public boolean m_142305_(ItemStack graveKey, ItemStack added, Slot slot, ClickAction action, Player player, SlotAccess slotAccess) {
        if (action == ClickAction.SECONDARY && slot.m_150651_(player) && graveKey.m_150930_((Item)this) && added.m_150922_(ModTags.Items.enchanted_grave_key_ingredients)) {
            if (this.isEnchanted(graveKey)) {
                if (player.f_19853_.m_5776_()) {
                    ModTombstone.PROXY.addToast(added.m_41777_(), new ItemStack((ItemLike)ModItems.grave_key), (Component)LangKey.MESSAGE_ENCHANT_ITEM_ALREADY_ENCHANTED.getText(new Object[0]));
                }
                return true;
            }
            NBTStackHelper.setBoolean(graveKey, "enchant", true);
            added.m_41774_(1);
            PacketHandler.sendToServer(new TriggerCombineInInventoryMessage(TriggerCombineInInventoryMessage.CombineType.GRAVE_KEY));
            return true;
        }
        return false;
    }

    public ItemStack createWithInfo(Player player, Location location) {
        ItemStack stack = new ItemStack((ItemLike)this);
        if (!location.isOrigin()) {
            CompoundTag tag = stack.m_41784_();
            NBTStackHelper.setUUID(tag, OWNER_ID_NBT_UUID, player.m_142081_());
            NBTStackHelper.setLocation(tag, TOMB_POS_NBT_LOCATION, location);
        }
        return stack;
    }

    @Nullable
    public UUID getOwnerId(ItemStack stack) {
        if (stack.m_150930_((Item)this)) {
            return NBTStackHelper.getUUID(stack, OWNER_ID_NBT_UUID, null);
        }
        return null;
    }

    public Location getTombPos(ItemStack stack) {
        return stack.m_150930_((Item)this) ? NBTStackHelper.getLocation(stack, TOMB_POS_NBT_LOCATION) : Location.ORIGIN;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!level.m_5776_() && EntityHelper.isValidPlayer(entity) && stack.m_150930_((Item)this)) {
            Location location = this.getTombPos(stack);
            boolean isBadKey = location.isOrigin();
            if (!isBadKey && TimeHelper.atInterval(entity, TimeHelper.tickFromSecond(isSelected && entity.m_20275_((double)location.getPos().m_123341_(), (double)location.getPos().m_123342_(), (double)location.getPos().m_123343_()) < 100.0 ? 10 : 120))) {
                if (!location.isSameDimension(level)) {
                    return;
                }
                if (!level.m_151570_(location.getPos())) {
                    if (!level.m_46805_(location.getPos())) {
                        level.m_8055_(location.getPos());
                    }
                    isBadKey = !(level.m_7702_(location.getPos()) instanceof BlockEntityPlayerGrave);
                } else {
                    isBadKey = true;
                }
            }
            if (isBadKey) {
                stack.m_41774_(1);
                ((Player)entity).f_36095_.m_38946_();
            }
        }
    }

    public boolean removeKeyForGraveInInventory(Player player, BlockEntityPlayerGrave grave) {
        assert (grave.m_58904_() != null);
        return InventoryHelper.removeFirstInInventory(player, stack -> stack.m_150930_((Item)this) && this.getTombPos((ItemStack)stack).equals(new Location(grave.m_58899_(), grave.m_58904_())) && Optional.ofNullable(this.getOwnerId((ItemStack)stack)).map(id -> id.equals(grave.getOwnerId())).orElse(false) != false);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.m_150930_((Item)this) && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        if (stack.m_150930_((Item)this)) {
            NBTStackHelper.setBoolean(stack, "enchant", true);
            return ISoulConsumer.ConsumeResult.success(1);
        }
        return ISoulConsumer.ConsumeResult.fail();
    }

    @Override
    protected boolean doEffects(ServerLevel level, ServerPlayer player, ItemStack stack) {
        Location location = this.getTombPos(stack);
        if (location.isOrigin()) {
            LangKey.MESSAGE_INVALID_LOCATION.sendMessage((Player)player, new Object[0]);
            return false;
        }
        if (!location.isSameDimension((Level)level) && !((Boolean)ConfigTombstone.general.teleportDim.get()).booleanValue()) {
            LangKey.MESSAGE_TELEPORT_SAME_DIMENSION.sendMessage((Player)player, new Object[0]);
            return false;
        }
        ServerLevel targetWorld = Objects.requireNonNull(player.m_20194_()).m_129880_(location.dim);
        if (targetWorld == null || !Helper.isValidPos((Level)targetWorld, location.getPos())) {
            LangKey.MESSAGE_INVALID_LOCATION.sendMessage((Player)player, new Object[0]);
            return false;
        }
        NBTStackHelper.setBoolean(stack, "enchant", false);
        CallbackHandler.addFastCallback(() -> {
            Player newPlayer = (Player)Helper.teleportToGrave(player, location, targetWorld);
            if (((Boolean)ConfigTombstone.player_death.nerfGhostlyShapeTeleportWithKey.get()).booleanValue()) {
                EffectHelper.capDuration((LivingEntity)newPlayer, ModEffects.ghostly_shape, 200);
            }
            LangKey.MESSAGE_TELEPORT_SUCCESS.sendMessage(newPlayer, new Object[0]);
            ModTriggers.TELEPORT_TO_GRAVE.trigger(player);
        });
        return true;
    }

    @Override
    public boolean canConsumeOnUse() {
        return false;
    }

    @Override
    public int getCastingCooldown() {
        return 0;
    }

    @Override
    public int getUseMax() {
        return 1;
    }

    public void reenchantOnDeath(Player player, ItemStack key) {
        int chanceEnchantedKey;
        if (key.m_150930_((Item)this) && (chanceEnchantedKey = ((Integer)SharedConfigTombstone.general.chanceEnchantedGraveKey.get()).intValue()) >= 0 && ((chanceEnchantedKey += EntityHelper.getPerkLevelWithBonus(player, ModPerks.jailer) * 20) >= 100 || chanceEnchantedKey > 0 && Helper.getRandom(1, 100) <= chanceEnchantedKey)) {
            NBTStackHelper.setBoolean(key, "enchant", true);
        }
    }

    @Override
    protected boolean canBlockInteractFirst(BlockState state, ItemStack stack) {
        return super.canBlockInteractFirst(state, stack) || ModBlocks.isPlayerGrave(state.m_60734_());
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        if (stack.m_41783_() != null) {
            CompoundTag tag = stack.m_41783_().m_6426_();
            tag.m_128473_(OWNER_ID_NBT_UUID);
            return tag;
        }
        return null;
    }
}

