/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemScroll;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemScrollBuff
extends ItemScroll {
    private final SpellBuff spellBuff;

    public ItemScrollBuff(SpellBuff spellBuff) {
        super("scroll_of_" + spellBuff.getName(), spellBuff::isEnable);
        this.spellBuff = spellBuff;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        if (Helper.canShowTooltip(level)) {
            this.addItemDesc(list);
            this.addItemUse(list, this.isEnchanted(stack) ? LangKey.ITEM_SCROLL_BUFF_USE2 : LangKey.ITEM_SCROLL_BUFF_USE1, new Object[0]);
            Player player = ModTombstone.PROXY.getClientPlayer();
            list.add((Component)new TextComponent("(" + StringUtil.m_14404_((int)Mth.m_14143_((float)((float)((Integer)SharedConfigTombstone.general.scrollDuration.get()).intValue() * (1.0f + (float)EntityHelper.getPerkLevelWithBonus(player, ModPerks.scribe) / 10.0f)))) + ")").m_6270_(StyleType.MESSAGE_SPELL));
        }
        super.m_7373_(stack, level, list, flag);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        if (stack.m_150930_((Item)this)) {
            NBTStackHelper.setBoolean(stack, "enchant", true);
            return ISoulConsumer.ConsumeResult.success(1);
        }
        return ISoulConsumer.ConsumeResult.fail();
    }

    @Override
    protected boolean doEffects(ServerLevel world, ServerPlayer player, ItemStack stack) {
        MobEffect potion = this.spellBuff.potionSupplier.get();
        EffectHelper.addEffect((LivingEntity)player, potion, Mth.m_14143_((float)((float)((Integer)SharedConfigTombstone.general.scrollDuration.get()).intValue() * (1.0f + (float)EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.scribe) / 10.0f))), this.spellBuff.amplifier, new boolean[0]);
        LangKey.MESSAGE_SPELL_CAST_ON_YOU.sendMessage((Player)player, StyleType.MESSAGE_SPELL, new Object[]{new TranslatableComponent(potion.m_19481_()).m_6270_(StyleType.MESSAGE_SPECIAL)});
        ModTriggers.SPELL_BUFF.get((Object)this.spellBuff).trigger(player);
        return true;
    }

    public static enum SpellBuff {
        PRESERVATION(() -> ModEffects.preservation, 0, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfPreservation.get()),
        UNSTABLE_INTANGIBILITY(() -> ModEffects.unstable_intangibility, 0, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfUnstableIntangibility.get()),
        FEATHER_FALL(() -> ModEffects.feather_fall, 2, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfFeatherFall.get()),
        PURIFICATION(() -> ModEffects.purification, 0, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfPurification.get()),
        TRUE_SIGHT(() -> ModEffects.true_sight, 0, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfTrueSight.get()),
        REACH(() -> ModEffects.reach, 4, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfReach.get()),
        LIGHTNING_RESISTANCE(() -> ModEffects.lightning_resistance, 0, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfLightningResistance.get()),
        FROST_RESISTANCE(() -> ModEffects.frost_resistance, 0, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfFrostResistance.get()),
        AQUATIC_LIFE(() -> ModEffects.aquatic_life, 0, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfAquaticLife.get());

        private final Supplier<MobEffect> potionSupplier;
        private final int amplifier;
        private final BooleanSupplier supplierEnabled;

        private SpellBuff(Supplier<MobEffect> potionSupplier, int amplifier, BooleanSupplier supplierEnabled) {
            this.potionSupplier = potionSupplier;
            this.amplifier = amplifier;
            this.supplierEnabled = supplierEnabled;
        }

        public String getName() {
            return this.name().toLowerCase(Locale.US);
        }

        public boolean isEnable() {
            return this.supplierEnabled.getAsBoolean();
        }

        public Item getItem() {
            return ModItems.scroll_buff.get((Object)this);
        }

        public static Optional<ItemStack> getRandomEnchantedScroll() {
            return Helper.getRandomInList(Arrays.stream(SpellBuff.values()).filter(SpellBuff::isEnable).collect(Collectors.toList())).map(buff -> NBTStackHelper.setBoolean(new ItemStack((ItemLike)buff.getItem()), "enchant", true));
        }
    }
}

