/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.command.CommandTBTeleport;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.item.ItemTablet;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemTabletOfHome
extends ItemTablet {
    public ItemTabletOfHome() {
        super("tablet_of_home", () -> SharedConfigTombstone.allowed_magic_items.allowTabletOfHome.get());
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        if (Helper.canShowTooltip(level)) {
            this.addItemDesc(list);
            boolean isAncient = this.isAncient(stack);
            if (isAncient) {
                this.addItemDesc(list, "_ancient", new Object[0]);
            }
            this.addItemUse(list, !this.isEnchanted(stack) ? "1" : "2", new Object[0]);
        }
        super.m_7373_(stack, level, list, flag);
    }

    @Override
    protected boolean doEffects(ServerLevel world, ServerPlayer player, ItemStack stack) {
        MinecraftServer server = Objects.requireNonNull(player.m_20194_());
        Pair<ServerLevel, BlockPos> respawnPoint = CommandTBTeleport.getRespawnPoint(server, player);
        if (!((Boolean)ConfigTombstone.general.teleportDim.get()).booleanValue() && !((ServerLevel)respawnPoint.getLeft()).m_46472_().equals((Object)world.m_46472_())) {
            LangKey.MESSAGE_TELEPORT_SAME_DIMENSION.sendMessage((Player)player, new Object[0]);
            return false;
        }
        Location location = new SpawnHelper((ServerLevel)respawnPoint.getLeft(), (BlockPos)respawnPoint.getRight()).findSpawnPlace();
        if (location.isOrigin()) {
            LangKey.MESSAGE_TELEPORT_FAILED.sendMessage((Player)player, new Object[0]);
            return false;
        }
        CallbackHandler.addFastCallback(() -> {
            boolean isAncient = this.isAncient(stack);
            ServerPlayer newPlayer = Helper.teleport(player, location, (ServerLevel)respawnPoint.getLeft());
            if (isAncient) {
                world.m_6249_((Entity)player, player.m_142469_().m_82377_(3.0, 0.0, 3.0), e -> e.m_6084_() && e.m_6072_() && !e.m_5833_()).forEach(entity -> Helper.teleport(entity, new Location((Entity)newPlayer), (ServerLevel)respawnPoint.getLeft()));
            }
            LangKey.MESSAGE_TELEPORT_SUCCESS.sendMessage((Player)newPlayer, new Object[0]);
            ModTriggers.USE_HOME.trigger(player);
        });
        return true;
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        NBTStackHelper.setBoolean(stack, "enchant", true);
        this.setUseCount(stack, this.getUseMax());
        if (!this.isAncient(stack) && soulStrength > 1) {
            NBTStackHelper.setBoolean(stack, "ancient", true);
            ModTriggers.CREATE_ANCIENT_TABLET.trigger(player);
            return ISoulConsumer.ConsumeResult.success(2);
        }
        return ISoulConsumer.ConsumeResult.success(1);
    }
}

