/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.particle;

import java.lang.ref.WeakReference;
import java.util.function.Predicate;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.particle.CustomParticle;

@OnlyIn(value=Dist.CLIENT)
public class ParticleCasting
extends CustomParticle {
    private static final ResourceLocation COMMON_TEXTURE = new ResourceLocation("tombstone", "textures/particle/casting.png");
    private final WeakReference<LivingEntity> entityWeakReference;
    private final Predicate<LivingEntity> predic;
    private final double radius = 1.1;
    private double angle;
    private static final float rotIncrement = 0.15707964f;
    private final float colorR;
    private final float colorG;
    private final float colorB;
    private boolean goUp;

    public ParticleCasting(ClientLevel world, LivingEntity caster, Predicate<LivingEntity> predic, double addY, double angle) {
        super(world, caster.m_20185_(), caster.m_20186_() + addY, caster.m_20189_());
        this.f_107217_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107215_ = 0.0;
        this.m_107271_(1.0f);
        this.goUp = addY < 1.0;
        this.entityWeakReference = new WeakReference<LivingEntity>(caster);
        this.predic = predic;
        this.f_107663_ = world.f_46441_.nextFloat() * 0.1f + 0.15f;
        this.angle = angle + Helper.getRandom(-0.25, 0.25);
        this.f_107231_ = world.f_46441_.nextFloat() * ((float)Math.PI * 2);
        float[] color = Helper.getRGBColor3F((Integer)ConfigTombstone.client.particleCastingColor.get());
        this.colorR = color[0];
        this.colorG = color[1];
        this.colorB = color[2];
        this.f_107219_ = false;
        this.updatePosition(caster);
    }

    private void updatePosition(LivingEntity caster) {
        this.angle += (double)0.01f;
        this.f_107209_ = this.f_107212_ = caster.m_20185_() + this.radius * Math.cos(Math.PI * 2 * this.angle);
        this.f_107210_ = this.f_107213_ += this.goUp ? 0.02 : -0.02;
        this.f_107211_ = this.f_107214_ = caster.m_20189_() + this.radius * Math.sin(Math.PI * 2 * this.angle);
        this.m_107253_(this.clampColor(this.colorR + Helper.getRandom(-20.0f, 20.0f) / 255.0f), this.clampColor(this.colorG - Helper.getRandom(-20.0f, 20.0f) / 255.0f), this.clampColor(this.colorB + Helper.getRandom(-20.0f, 20.0f) / 255.0f));
        this.f_107204_ = this.f_107231_;
        this.f_107231_ += 0.15707964f;
    }

    private float clampColor(float color) {
        return Mth.m_14036_((float)color, (float)0.0f, (float)1.0f);
    }

    public void m_5989_() {
        LivingEntity caster = (LivingEntity)this.entityWeakReference.get();
        if (caster == null || this.predic.test(caster)) {
            this.m_107274_();
            return;
        }
        if (this.f_107213_ > caster.m_20186_() + 2.0 || this.f_107213_ < caster.m_20186_()) {
            this.goUp = !this.goUp;
        }
        this.updatePosition(caster);
        ++this.f_107224_;
    }

    @Override
    protected int m_6355_(float partialTick) {
        return 0x5000F0;
    }

    @Override
    ResourceLocation getTexture() {
        return COMMON_TEXTURE;
    }
}

