/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.particle.TransparentParticle;

@OnlyIn(value=Dist.CLIENT)
public class ParticleGraveSmoke
extends TransparentParticle {
    private final SpriteSet spriteSet;
    protected final int halfMaxAge;
    protected final float alphaStep;
    private final float rotIncrement;
    private final Vec3 move;

    private ParticleGraveSmoke(SpriteSet spriteSet, ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(world, x, y, z);
        this.f_107215_ = motionX;
        this.f_107216_ = motionY;
        this.f_107217_ = motionZ;
        this.f_107230_ = 0.11f;
        this.m_6569_(1.4f);
        this.f_107231_ = (float)Math.PI * 2 * world.f_46441_.nextFloat();
        this.rotIncrement = (float)(Math.PI * (double)world.f_46441_.nextFloat() * 0.005) * (float)(Helper.random.nextBoolean() ? -1 : 1);
        this.f_107204_ = this.f_107231_ - this.rotIncrement;
        this.m_107257_(((ConfigTombstone.Client.FogDensity)((Object)ConfigTombstone.client.fogDensity.get())).ordinal() * 20 + 30);
        this.halfMaxAge = this.f_107225_ / 2;
        this.alphaStep = 0.03f;
        this.f_172259_ = false;
        this.f_107219_ = false;
        this.move = new Vec3((double)(Helper.random.nextFloat() - Helper.random.nextFloat()) / 200.0, 0.0, (double)(Helper.random.nextFloat() - Helper.random.nextFloat()) / 200.0);
        float[] colors = Helper.getRGBColor3F((Integer)ConfigTombstone.client.fogColor.get());
        if (TimeHelper.isDateAroundHalloween()) {
            this.m_107253_(0.7f, 0.7f, 0.7f);
        } else {
            this.m_107253_(colors[0] * 0.7f, colors[1] * 0.7f, colors[2] * 0.7f);
        }
        this.spriteSet = spriteSet;
        this.m_108339_(this.spriteSet);
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.m_6257_(this.move.f_82479_, this.move.f_82480_, this.move.f_82481_);
            this.m_108339_(this.spriteSet);
            this.f_107204_ = this.f_107231_;
            this.f_107231_ += this.rotIncrement;
            this.m_107271_(Mth.m_14036_((float)(Mth.m_14036_((float)(this.f_107224_ < this.halfMaxAge ? (float)this.f_107224_ : (float)(this.f_107225_ - this.f_107224_)), (float)0.0f, (float)this.halfMaxAge) * this.alphaStep), (float)0.11f, (float)0.3f));
        }
    }

    protected int m_6355_(float partialTick) {
        return 0xF000F0;
    }

    @Override
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public record Factory(SpriteSet spriteSet) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double motionX, double motionY, double motionZ) {
            return new ParticleGraveSmoke(this.spriteSet, level, x, y + 0.4, z, (double)(level.f_46441_.nextFloat() - 0.5f) * 0.03, 0.0, (double)(level.f_46441_.nextFloat() - 0.5f) * 0.03);
        }
    }
}

