/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.particle;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.block.SoulType;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.particle.ParticleBlinkingAura;

@OnlyIn(value=Dist.CLIENT)
public class ParticleGraveSoul
extends SimpleAnimatedParticle {
    private final SpriteSet spriteSet;
    private final double radius;
    private final double centerX;
    private final double centerZ;
    private final float[] colorCode;

    private ParticleGraveSoul(SpriteSet spriteSet, ClientLevel level, double x, double y, double z, int soulTypeId) {
        super(level, x, y + 0.85, z, spriteSet, 0.0f);
        this.f_107225_ = 100;
        this.f_107663_ = soulTypeId > 1 ? 0.04f : 0.03f;
        this.centerX = x + 0.5;
        this.centerZ = z + 0.5;
        this.radius = 0.3;
        this.colorCode = Helper.getRGBColor3F(SoulType.byId(soulTypeId).getColorCode());
        this.m_107271_(0.5f);
        this.m_107253_(this.colorCode[0], this.colorCode[1], this.colorCode[2]);
        this.updatePosition();
        this.f_107219_ = false;
        this.spriteSet = spriteSet;
        this.m_108339_(this.spriteSet);
    }

    private void updatePosition() {
        double ratio = (double)this.f_107224_ / (double)this.f_107225_;
        this.f_107217_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107215_ = 0.0;
        this.f_107209_ = this.f_107212_ = this.centerX + this.radius * Math.cos(Math.PI * 2 * ratio);
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_ = this.centerZ + this.radius * Math.sin(Math.PI * 2 * ratio);
    }

    public void m_5989_() {
        super.m_5989_();
        if (this.m_107276_()) {
            this.m_108339_(this.spriteSet);
            this.updatePosition();
            Minecraft.m_91087_().f_91061_.m_107344_((Particle)new ParticleBlinkingAura(this.f_107208_, this.f_107212_, this.f_107213_ + 0.02, this.f_107214_, this.colorCode));
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public record Factory(SpriteSet spriteSet) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double motionX, double motionY, double motionZ) {
            return new ParticleGraveSoul(this.spriteSet, level, x, y, z, (int)motionX);
        }
    }
}

