/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.particle;

import java.lang.ref.WeakReference;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.particle.CustomParticle;

@OnlyIn(value=Dist.CLIENT)
public class ParticleShadowStep
extends CustomParticle {
    private static final ResourceLocation COMMON_TEXTURE = new ResourceLocation("tombstone", "textures/particle/fake_fog.png");
    private static final double twoPi = Math.PI * 2;
    private final WeakReference<LivingEntity> entityWeakReference;
    private final double angle;
    private final double spin;

    public ParticleShadowStep(ClientLevel level, LivingEntity entity, double angle) {
        super(level, ParticleShadowStep.getPos(entity, angle));
        this.entityWeakReference = new WeakReference<LivingEntity>(entity);
        this.angle = angle;
        this.f_107217_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107215_ = 0.0;
        this.f_107224_ = 1;
        this.f_107225_ = 20;
        this.spin = Math.PI * 2 / (double)this.f_107225_;
        this.m_107271_(0.5f);
        this.f_107663_ = 0.25f;
        this.f_107219_ = false;
        this.f_107226_ = 0.0f;
        this.f_107204_ = this.f_107231_ = (float)(Math.PI * 2 * angle);
        float currentColor = 0.4509804f;
        this.m_107253_(currentColor, currentColor, currentColor);
    }

    private static Vec3 getPos(LivingEntity entity, double angle) {
        double ratio = (double)(entity.f_19797_ % 100) / 100.0;
        return entity.m_20182_().m_82520_(0.6 * Math.cos(Math.PI * 2 * (angle + ratio)), 0.3, 0.6 * Math.sin(Math.PI * 2 * (angle + ratio)));
    }

    public void m_5989_() {
        LivingEntity entity = (LivingEntity)this.entityWeakReference.get();
        if (entity == null || this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
            return;
        }
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        Vec3 pos = ParticleShadowStep.getPos(entity, this.angle);
        this.f_107212_ = pos.f_82479_;
        this.f_107213_ = pos.f_82480_;
        this.f_107214_ = pos.f_82481_;
        this.f_107231_ = (float)((double)this.f_107231_ + this.spin);
        if ((double)this.f_107231_ > Math.PI * 2) {
            this.f_107231_ = (float)((double)this.f_107231_ - Math.PI * 2);
        }
        this.f_107204_ = this.f_107231_;
    }

    @Override
    ResourceLocation getTexture() {
        return COMMON_TEXTURE;
    }
}

